/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.jupyter;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.io.DisplayConfiguration;
import org.jetbrains.kotlinx.dataframe.io.HtmlKt;
import org.jetbrains.kotlinx.dataframe.io.StringKt;
import org.jetbrains.kotlinx.dataframe.jupyter.ChainedCellRenderer;
import org.jetbrains.kotlinx.dataframe.jupyter.DefaultCellRenderer;
import org.jetbrains.kotlinx.dataframe.jupyter.RenderedContent;
import org.jetbrains.kotlinx.jupyter.api.MimeTypedResult;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.Renderable;
import org.jetbrains.kotlinx.jupyter.api.RenderersProcessor;
import org.jetbrains.kotlinx.jupyter.api.libraries.ExecutionHost;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/dataframe/jupyter/JupyterCellRenderer;", "Lorg/jetbrains/kotlinx/dataframe/jupyter/ChainedCellRenderer;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "host", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ExecutionHost;", "(Lorg/jetbrains/kotlinx/jupyter/api/Notebook;Lorg/jetbrains/kotlinx/jupyter/api/libraries/ExecutionHost;)V", "maybeContent", "Lorg/jetbrains/kotlinx/dataframe/jupyter/RenderedContent;", "value", "", "configuration", "Lorg/jetbrains/kotlinx/dataframe/io/DisplayConfiguration;", "maybeTooltip", "", "core"})
public final class JupyterCellRenderer
extends ChainedCellRenderer {
    @NotNull
    private final Notebook notebook;
    @NotNull
    private final ExecutionHost host;

    public JupyterCellRenderer(@NotNull Notebook notebook, @NotNull ExecutionHost host) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(DefaultCellRenderer.INSTANCE);
        this.notebook = notebook;
        this.host = host;
    }

    @Override
    @Nullable
    public RenderedContent maybeContent(@Nullable Object value, @NotNull DisplayConfiguration configuration) {
        Object finalVal;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        RenderersProcessor renderersProcessor = this.notebook.getRenderersProcessor();
        if (StringKt.internallyRenderable(value)) {
            return null;
        }
        Object renderedVal = renderersProcessor.renderValue(this.host, value);
        Object object = finalVal = renderedVal instanceof Renderable ? ((Renderable)renderedVal).render(this.notebook) : renderedVal;
        if (finalVal instanceof MimeTypedResult && ((Map)finalVal).containsKey("text/html")) {
            String string = (String)((MimeTypedResult)finalVal).get((Object)"text/html");
            if (string == null) {
                string = "";
            }
            return RenderedContent.Companion.media(string);
        }
        return HtmlKt.renderValueForHtml-uKGgf_E(finalVal, configuration.getCellContentLimit(), configuration.getDecimalFormat-3Sl7FsM());
    }

    @Override
    @Nullable
    public String maybeTooltip(@Nullable Object value, @NotNull DisplayConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return null;
    }
}

