/* sithwm - Minimalist Window Manager for X
 * see README for Copyright, license and other details. */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include "sithwm.h"

/* Commonly used X information */
XGCValues glob_gcv;
char global_buffer[STRLEN];
Display      *dpy;
XFontStruct  *font;
int	    font_height;
unsigned int     numlockmask;

Atom xa_wm_state;
Atom xa_wm_protos;
Atom xa_wm_delete;

/* Things that affect user interaction */
static const char def_font[] = "variable";
const char   *opt_font = def_font;
const char*colnams[COL_NO_OF] =
   {"black","black","","black","black",
    "black","black","black"};

const char*lock_command;

static void setup_display(void)
{
   XSetWindowAttributes attr;
   XModifierKeymap *modmap;

   dpy = XOpenDisplay(0);
   if (!dpy) { 
      LOG_ERROR("can't open display\n");
      exit(1);
   }
   XSetErrorHandler(handle_xerror);
   /* XSynchronize(dpy, True); */

   xa_wm_state = XInternAtom(dpy, "WM_STATE", False);
   xa_wm_protos = XInternAtom(dpy, "WM_PROTOCOLS", False);
   xa_wm_delete = XInternAtom(dpy, "WM_DELETE_WINDOW", False);

   font = XLoadQueryFont(dpy, opt_font);
   if (!font) {
      LOG_ERROR("%s:illegal font\n", opt_font);
      exit(1);
   }
   font_height = font->max_bounds.ascent + font->max_bounds.descent;

   /* find out which modifier is NumLock - we'll use this when grabbing
    * every combination of modifiers we can think of */
   modmap = XGetModifierMapping(dpy);
   for (int i = 0; i < 8; i++) {
      for (int j = 0; j < (unsigned int)modmap->max_keypermod; j++) {
	 if (modmap->modifiermap[i*modmap->max_keypermod+j] == XKeysymToKeycode(dpy, XK_Num_Lock)) {
	    numlockmask = (1<<i);
	    LOG_DEBUG("setup_display() : XK_Num_Lock is (1<<0x%02x)\n", i);
	 }
      }
   }
   XFreeModifiermap(modmap);

   /* set up GC parameters - same for each screen */
   glob_gcv.font = font->fid;

   /* set up root window attributes - same for each screen */
   attr.event_mask =  SubstructureNotifyMask | EnterWindowMask|KeyPressMask|ButtonPressMask  ;

   /* now set up each screen in turn */
   num_screens = ScreenCount(dpy);
   if (num_screens < 1)
      num_screens = 1;
   current_screen = screens = (ScreenInfo*)calloc(num_screens, sizeof(ScreenInfo));
   ScreenInfo*scr = current_screen;
   for (int i = 0; i < (unsigned int)num_screens; i++,scr++) {

      scr->root = RootWindow(dpy, i);
      scr->area.w = DisplayWidth(dpy, i);
      scr->last_pos.x = scr->area.w>>1;
      scr->area.h = DisplayHeight(dpy, i);
      scr->last_pos.y = scr->area.h>>1;
      LOG_DEBUG("main:root: 0x%lx %ix%i\n", scr->root, scr->area.w, scr->area.h);

      for (int iii = 0; iii<COL_NO_OF ; iii++) {
	 LOG_DEBUG("main:color: %c %s\n", COL_BASE+iii, colnams[iii]);
	 GC gc = 0;
	 for (int y = 0; y<iii; y++)
	    if (strcmp(colnams[y], colnams[iii]) == 0) {
	       gc = scr->gc[y];
	       scr->pixel[iii] = scr->pixel[y];
	    }
	 if (!gc) {
	    XColor zzz;
#ifndef STORMTROOPER
	    scr->cmap = DefaultColormap(dpy, i);
#endif	    
	    XAllocNamedColor(dpy, DefaultColormap(dpy, i), colnams[iii], &zzz, &zzz);
	    glob_gcv.foreground = scr->pixel[iii] = zzz.pixel;
	    glob_gcv.subwindow_mode = IncludeInferiors;
	    glob_gcv.background = scr->pixel[0];
	    glob_gcv.function = GXinvert;
	    glob_gcv.line_width = 3;
	    unsigned int mask = GCSubwindowMode|GCFont|GCForeground|GCBackground;
	    if (iii==('d'-COL_BASE) )
	       mask |= GCFunction|GCLineWidth;
	    gc = XCreateGC(dpy, scr->root, mask, &glob_gcv);
	 }
	 scr->gc[iii] = gc;
      }

      XChangeWindowAttributes(dpy, scr->root, CWEventMask, &attr);

      /* scan all the windows on this screen */
      unsigned int nwins;
      Window dw1, dw2, *wins;
      LOG_DEBUG("main:XQueryTree(); ");
      XQueryTree(dpy, scr->root, &dw1, &dw2, &wins, &nwins);
      LOG_DEBUG("%d windows\n", nwins);
      for (int j = 0; j < nwins; j++)
	 make_new_client(wins[j], scr, 1);
      XFree(wins);
#ifndef STORMTROOPER
      scr->infow = XCreateSimpleWindow(dpy, scr->root, 1, 1, 1, 1,
                                       1, scr->pixel['f'-COL_BASE], scr->pixel[0]);
      XSelectInput(dpy, scr->infow, EnterWindowMask|KeyPressMask|ButtonPressMask);
#endif
   }
}

int main(int argc, char **argv)
{
   (void)argc;
   for (char**aaa = argv;*(++aaa);) {
      if (aaa[0][0] == '-')
         switch (aaa[0][1]) {
         case 'm':
            modifiers[0].mask = parse_modifiers(*aaa+2);
            break;
         default:
            LOG_INFO("sithwm version " VERSION "\n"
                     "usage: sithwm [-mdefault_mask] [config file command]\n"
                     );
            exit(0);
         }
   }

   read_rcs();  // Read after argv '-m'

   for (char**aaa = argv;*(++aaa);) {
      if (aaa[0][0] != '-') {
	 strncpy(global_buffer, aaa[0], sizeof global_buffer);
         parse_rc_line();
      }
   }

   setup_display();

   event_main_loop();

   return 1;
}
