/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Path;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.GeometryParsers;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Polygons
extends SimpleProcProvider {
    public Polygons() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "poly_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Path.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Polygon;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            if (val == null) {
                return;
            }
            buffer.append(new Path((double[][])val, true));
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Polygon;
        }

        @Override
        public Class<?> getOutputType() {
            return double[][].class;
        }

        public double[][] decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            return GeometryParsers.INSTANCE.parsePolygon(buffer);
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return double[][].class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Polygon;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                double[][] points = (double[][])val;
                int size = 4 + points.length * 8 * 2;
                buffer.writeInt(size);
                buffer.writeInt(points.length);
                for (int i = 0; i < points.length; ++i) {
                    double[] point = points[i];
                    buffer.writeDouble(point[0]);
                    buffer.writeDouble(point[1]);
                }
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Polygon;
        }

        @Override
        public Class<?> getOutputType() {
            return double[][].class;
        }

        public double[][] decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length < 20) {
                throw new IOException("invalid length " + length);
            }
            int npts = buffer.readInt();
            if (npts <= 0 || npts >= Integer.MAX_VALUE) {
                throw new IOException("invalid number of points in external \"polygon\" value");
            }
            double[][] points = new double[npts][];
            for (int i = 0; i < npts; ++i) {
                double[] point = new double[]{buffer.readDouble(), buffer.readDouble()};
                points[i] = point;
            }
            return points;
        }
    }
}

