/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import org.fxmisc.flowless.TargetPosition;
import org.fxmisc.flowless.TargetPositionVisitor;

final class StartOffStart
implements TargetPosition {
    final int itemIndex;
    final double offsetFromStart;

    StartOffStart(int itemIndex, double offsetFromStart) {
        this.itemIndex = itemIndex;
        this.offsetFromStart = offsetFromStart;
    }

    @Override
    public TargetPosition transformByChange(int pos, int removedSize, int addedSize) {
        if (this.itemIndex >= pos + removedSize) {
            return new StartOffStart(this.itemIndex - removedSize + addedSize, this.offsetFromStart);
        }
        if (this.itemIndex >= pos) {
            if (addedSize == removedSize) {
                return this;
            }
            return new StartOffStart(pos, this.offsetFromStart);
        }
        return this;
    }

    @Override
    public TargetPosition scrollBy(double delta) {
        return new StartOffStart(this.itemIndex, this.offsetFromStart - delta);
    }

    @Override
    public void accept(TargetPositionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public TargetPosition clamp(int size) {
        return new StartOffStart(StartOffStart.clamp(this.itemIndex, size), this.offsetFromStart);
    }

    static int clamp(int idx, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be negative: " + size);
        }
        if (idx <= 0) {
            return 0;
        }
        if (idx >= size) {
            return size - 1;
        }
        return idx;
    }
}

