/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.SidePaneManager;
import org.jabref.gui.collab.ChangeScanner;
import org.jabref.gui.collab.FileUpdatePanel;
import org.jabref.logic.util.io.FileBasedLock;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.FileUpdateListener;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseChangeMonitor
implements FileUpdateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseChangeMonitor.class);
    private final BibDatabaseContext database;
    private final FileUpdateMonitor fileMonitor;
    private final BasePanel panel;
    private boolean updatedExternally;
    private Path tmpFile;
    private long timeStamp;
    private long fileSize;

    public DatabaseChangeMonitor(BibDatabaseContext database, FileUpdateMonitor fileMonitor, BasePanel panel) {
        this.database = database;
        this.fileMonitor = fileMonitor;
        this.panel = panel;
        this.database.getDatabasePath().ifPresent(path -> {
            try {
                fileMonitor.addListenerForFile((Path)path, this);
                this.timeStamp = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                this.fileSize = Files.size(path);
                this.tmpFile = Files.createTempFile("jabref", ".bib", new FileAttribute[0]);
                this.tmpFile.toFile().deleteOnExit();
                this.copyToTemp((Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Error while trying to monitor " + path, e);
            }
        });
    }

    @Override
    public void fileUpdated() {
        if (this.panel.isSaving()) {
            return;
        }
        this.updatedExternally = true;
        ChangeScanner scanner = new ChangeScanner(this.panel.frame(), this.panel, this.database.getDatabaseFile().orElse(null), this.tmpFile);
        if (this.database.getDatabasePath().isPresent() && !FileBasedLock.waitForFileLock(this.database.getDatabasePath().get())) {
            LOGGER.error("File updated externally, but change scan failed because the file is locked.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fileUpdated();
            return;
        }
        JabRefExecutorService.INSTANCE.executeInterruptableTaskAndWait(scanner);
        Runnable t = () -> {
            SidePaneManager sidePaneManager = this.panel.getSidePaneManager();
            boolean hasAlready = sidePaneManager.hasComponent(FileUpdatePanel.class);
            if (hasAlready) {
                sidePaneManager.hideComponent(FileUpdatePanel.class);
                sidePaneManager.unregisterComponent(FileUpdatePanel.class);
            }
            FileUpdatePanel pan = new FileUpdatePanel(this.panel, sidePaneManager, this.database.getDatabaseFile().orElse(null), scanner);
            sidePaneManager.register(pan);
            sidePaneManager.show(FileUpdatePanel.class);
        };
        if (scanner.changesFound()) {
            SwingUtilities.invokeLater(t);
        } else {
            this.updatedExternally = false;
        }
    }

    private boolean hasBeenModified() {
        Optional<Path> file = this.database.getDatabasePath();
        if (file.isPresent()) {
            try {
                long modified = Files.getLastModifiedTime(file.get(), new LinkOption[0]).toMillis();
                if (modified == 0L) {
                    return false;
                }
                long fileSizeNow = Files.size(file.get());
                return this.timeStamp != modified || this.fileSize != fileSizeNow;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return false;
    }

    public void unregister() {
        this.database.getDatabasePath().ifPresent(file -> this.fileMonitor.removeListener((Path)file, this));
    }

    public boolean hasBeenModifiedExternally() {
        return this.updatedExternally || this.hasBeenModified();
    }

    public void markExternalChangesAsResolved() {
        this.updatedExternally = false;
        this.markAsSaved();
    }

    public void markAsSaved() {
        this.database.getDatabasePath().ifPresent(file -> {
            try {
                this.timeStamp = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                this.fileSize = Files.size(file);
                this.copyToTemp((Path)file);
            }
            catch (IOException ex) {
                LOGGER.error("Error while getting file information", ex);
            }
        });
    }

    private void copyToTemp(Path file) {
        FileUtil.copyFile(file, this.tmpFile, true);
    }

    public Path getTempFile() {
        return this.tmpFile;
    }
}

