/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupEntryChanger;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.KeywordGroup;
import org.jabref.model.strings.StringUtil;

public class WordKeywordGroup
extends KeywordGroup
implements GroupEntryChanger {
    protected final Character keywordSeparator;
    private final Set<String> searchWords;
    private final boolean onlySplitWordsAtSeparator;

    public WordKeywordGroup(String name, GroupHierarchyType context, String searchField, String searchExpression, boolean caseSensitive, Character keywordSeparator, boolean onlySplitWordsAtSeparator) {
        super(name, context, searchField, searchExpression, caseSensitive);
        this.keywordSeparator = keywordSeparator;
        this.onlySplitWordsAtSeparator = onlySplitWordsAtSeparator;
        this.searchWords = this.getSearchWords(searchExpression);
    }

    private static boolean containsCaseInsensitive(Set<String> searchIn, Collection<String> searchFor) {
        for (String searchWord : searchFor) {
            if (WordKeywordGroup.containsCaseInsensitive(searchIn, searchWord)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsCaseInsensitive(Set<String> searchIn, String searchFor) {
        for (String word : searchIn) {
            if (!word.equalsIgnoreCase(searchFor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FieldChange> add(List<BibEntry> entriesToAdd) {
        Objects.requireNonNull(entriesToAdd);
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (BibEntry entry : entriesToAdd) {
            if (this.contains(entry)) continue;
            String oldContent = entry.getField(this.searchField).orElse("");
            KeywordList wordlist = KeywordList.parse(oldContent, this.keywordSeparator);
            wordlist.add(this.searchExpression);
            String newContent = wordlist.getAsString(this.keywordSeparator);
            entry.setField(this.searchField, newContent).ifPresent(changes::add);
        }
        return changes;
    }

    @Override
    public List<FieldChange> remove(List<BibEntry> entriesToRemove) {
        Objects.requireNonNull(entriesToRemove);
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (BibEntry entry : entriesToRemove) {
            if (!this.contains(entry)) continue;
            String oldContent = entry.getField(this.searchField).orElse("");
            KeywordList wordlist = KeywordList.parse(oldContent, this.keywordSeparator);
            wordlist.remove(this.searchExpression);
            String newContent = wordlist.getAsString(this.keywordSeparator);
            entry.setField(this.searchField, newContent).ifPresent(changes::add);
        }
        return changes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WordKeywordGroup)) {
            return false;
        }
        WordKeywordGroup other = (WordKeywordGroup)o;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals((Object)this.getHierarchicalContext(), (Object)other.getHierarchicalContext()) && Objects.equals(this.searchField, other.searchField) && Objects.equals(this.searchExpression, other.searchExpression) && Objects.equals(this.caseSensitive, other.caseSensitive) && Objects.equals(this.keywordSeparator, other.keywordSeparator) && Objects.equals(this.onlySplitWordsAtSeparator, other.onlySplitWordsAtSeparator);
    }

    @Override
    public boolean contains(BibEntry entry) {
        Set<String> content = this.getFieldContentAsWords(entry);
        if (this.caseSensitive) {
            return content.containsAll(this.searchWords);
        }
        return WordKeywordGroup.containsCaseInsensitive(content, this.searchWords);
    }

    private Set<String> getFieldContentAsWords(BibEntry entry) {
        if (this.onlySplitWordsAtSeparator) {
            return entry.getField(this.searchField).map(content -> KeywordList.parse(content, this.keywordSeparator).toStringList()).orElse(Collections.emptySet());
        }
        return entry.getFieldAsWords(this.searchField);
    }

    private Set<String> getSearchWords(String searchExpression) {
        if (this.onlySplitWordsAtSeparator) {
            return KeywordList.parse(searchExpression, this.keywordSeparator).toStringList();
        }
        return new HashSet<String>(StringUtil.getStringAsWords(searchExpression));
    }

    @Override
    public AbstractGroup deepCopy() {
        return new WordKeywordGroup(this.getName(), this.getHierarchicalContext(), this.searchField, this.searchExpression, this.caseSensitive, this.keywordSeparator, this.onlySplitWordsAtSeparator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getHierarchicalContext(), this.searchField, this.searchExpression, this.caseSensitive, this.keywordSeparator, this.onlySplitWordsAtSeparator});
    }
}

