/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.runtime.Immutable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\b\n\u0000\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J%\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Landroidx/compose/animation/core/StartDelayVectorizedAnimationSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "vectorizedAnimationSpec", "startDelayNanos", "", "(Landroidx/compose/animation/core/VectorizedAnimationSpec;J)V", "isInfinite", "", "()Z", "getStartDelayNanos", "()J", "getVectorizedAnimationSpec", "()Landroidx/compose/animation/core/VectorizedAnimationSpec;", "equals", "other", "", "getDurationNanos", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getValueFromNanos", "playTimeNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "hashCode", "", "animation-core"})
@Immutable
final class StartDelayVectorizedAnimationSpec<V extends AnimationVector>
implements VectorizedAnimationSpec<V> {
    @NotNull
    private final VectorizedAnimationSpec<V> vectorizedAnimationSpec;
    private final long startDelayNanos;

    public StartDelayVectorizedAnimationSpec(@NotNull VectorizedAnimationSpec<V> vectorizedAnimationSpec, long startDelayNanos) {
        Intrinsics.checkNotNullParameter(vectorizedAnimationSpec, (String)"vectorizedAnimationSpec");
        this.vectorizedAnimationSpec = vectorizedAnimationSpec;
        this.startDelayNanos = startDelayNanos;
    }

    @NotNull
    public final VectorizedAnimationSpec<V> getVectorizedAnimationSpec() {
        return this.vectorizedAnimationSpec;
    }

    public final long getStartDelayNanos() {
        return this.startDelayNanos;
    }

    @Override
    public boolean isInfinite() {
        return this.vectorizedAnimationSpec.isInfinite();
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.vectorizedAnimationSpec.getDurationNanos(initialValue, targetValue2, initialVelocity) + this.startDelayNanos;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return playTimeNanos < this.startDelayNanos ? initialVelocity : this.vectorizedAnimationSpec.getVelocityFromNanos(playTimeNanos - this.startDelayNanos, initialValue, targetValue2, initialVelocity);
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return playTimeNanos < this.startDelayNanos ? initialValue : this.vectorizedAnimationSpec.getValueFromNanos(playTimeNanos - this.startDelayNanos, initialValue, targetValue2, initialVelocity);
    }

    public int hashCode() {
        return 31 * this.vectorizedAnimationSpec.hashCode() + Long.hashCode(this.startDelayNanos);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof StartDelayVectorizedAnimationSpec)) {
            return false;
        }
        return ((StartDelayVectorizedAnimationSpec)other).startDelayNanos == this.startDelayNanos && Intrinsics.areEqual(((StartDelayVectorizedAnimationSpec)other).vectorizedAnimationSpec, this.vectorizedAnimationSpec);
    }
}

