/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.tools.ide.starter.bus.EventsBus;
import com.intellij.tools.ide.starter.bus.shared.events.SharedEvent;
import com.intellij.util.Alarm;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.CommandsRunner;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.ProjectLoaded;
import com.jetbrains.performancePlugin.ProjectLoadedService;
import com.jetbrains.performancePlugin.commands.CodeAnalysisStateListener;
import com.jetbrains.performancePlugin.commands.OpenProjectCommand;
import com.jetbrains.performancePlugin.commands.TakeScreenshotCommandKt;
import com.jetbrains.performancePlugin.events.StopProfilerEvent;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.utils.ReporterCommandAsTelemetrySpan;
import io.opentelemetry.context.Context;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a$\u0010\u0011\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0000\u001a\u0006\u0010\u0018\u001a\u00020\u0007\u001a\u001c\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001c\u0018\u00010\u001bH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0018\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002\u001a\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010(\u001a\u00020\u00072\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0012\u0010+\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getTestFile", "Ljava/nio/file/Path;", "subscribeToStopProfile", "", "runOnProjectInit", "project", "Lcom/intellij/openapi/project/Project;", "TIMEOUT", "", "runScriptWhenInitializedAndIndexed", "alarm", "Lcom/intellij/util/Alarm;", "runScriptDuringIndexing", "runPerformanceScript", "script", "", "mustExitOnFailure", "", "generifyErrorMessage", "originalMessage", "reportErrorsFromMessagePool", "INDEXING_PROFILER_PREFIX", "initializeProfilerSettingsForIndexing", "Lcom/intellij/openapi/util/Pair;", "", "reportScriptError", "errorMessage", "Lcom/intellij/diagnostic/AbstractMessage;", "writeAttachmentToErrorDir", "attachment", "Lcom/intellij/openapi/diagnostic/Attachment;", "path", "getNonEmptyThrowableMessage", "throwable", "", "runScriptFromFile", "registerOnFinishRunnables", "future", "Ljava/util/concurrent/CompletableFuture;", "storeFailureToFile", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nProjectLoaded.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLoaded.kt\ncom/jetbrains/performancePlugin/ProjectLoadedKt\n+ 2 EventsBus.kt\ncom/intellij/tools/ide/starter/bus/EventsBus\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,451:1\n45#2,15:452\n739#3,9:467\n31#4,2:476\n*S KotlinDebug\n*F\n+ 1 ProjectLoaded.kt\ncom/jetbrains/performancePlugin/ProjectLoadedKt\n*L\n99#1:452,15\n306#1:467,9\n149#1:476,2\n*E\n"})
public final class ProjectLoadedKt {
    private static final int TIMEOUT = 500;
    @NotNull
    private static final String INDEXING_PROFILER_PREFIX = "%%profileIndexing";

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"PerformancePlugin");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final Path getTestFile() {
        String string = ProjectLoaded.TEST_SCRIPT_FILE_PATH;
        Intrinsics.checkNotNull((Object)string);
        Path file = Path.of(string, new String[0]);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            Object[] objectArray = new Object[]{((Object)file.toAbsolutePath()).toString()};
            System.err.println(PerformanceTestingBundle.message("startup.noscript", objectArray));
            ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
        }
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private static final void subscribeToStopProfile() {
        if (ApplicationManagerEx.isInIntegrationTest()) {
            try {
                void subscriber$iv;
                void $this$iv;
                EventsBus eventsBus = EventsBus.INSTANCE;
                String string = "ProfileStopSubscriber";
                Function2 callback$iv = (Function2)new Function2<StopProfilerEvent, Continuation<? super Unit>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                StopProfilerEvent event = (StopProfilerEvent)this.L$0;
                                try {
                                    Profiler.Companion.getCurrentProfilerHandler().stopProfiling(event.getData());
                                }
                                catch (Throwable t) {
                                    ProjectLoadedKt.access$getLOG().info("Error stop profiling", t);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(StopProfilerEvent p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                };
                long timeout$iv = DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES);
                boolean ignoreExceptions$iv = true;
                boolean bl = false;
                $this$iv.executeWithExceptionHandling(ignoreExceptions$iv, (Function0<Unit>)((Function0)new Function0<Unit>((Object)subscriber$iv, timeout$iv, callback$iv){
                    final /* synthetic */ Object $subscriber;
                    final /* synthetic */ long $timeout;
                    final /* synthetic */ Function2 $callback;
                    {
                        this.$subscriber = $subscriber;
                        this.$timeout = $timeout;
                        this.$callback = $callback;
                    }

                    public final void invoke() {
                        if (SharedEvent.class.isAssignableFrom(StopProfilerEvent.class)) {
                            EventsBus.INSTANCE.getSHARED_EVENTS_FLOW().subscribe-exY8QGI(StopProfilerEvent.class, this.$subscriber, this.$timeout, this.$callback);
                            EventsBus.INSTANCE.getSHARED_EVENTS_FLOW().startServerPolling();
                        } else {
                            EventsBus.INSTANCE.getEVENTS_FLOW().subscribe-exY8QGI(StopProfilerEvent.class, this.$subscriber, this.$timeout, this.$callback);
                        }
                    }
                }));
            }
            catch (ConnectException connectException) {
                ProjectLoadedKt.getLOG().info("Subscription to stop profiling failed", (Throwable)connectException);
            }
        }
    }

    private static final void runOnProjectInit(Project project) {
        if (System.getProperty("ide.performance.screenshot") != null) {
            String string = System.getProperty("ide.performance.screenshot");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            ProjectLoadedService.INSTANCE.registerScreenshotTaking(string, ((ComponentManagerEx)project).getCoroutineScope());
            ProjectLoadedKt.getLOG().info("Option ide.performance.screenshot is initialized, screenshots will be captured");
        }
        if (ProjectLoaded.TEST_SCRIPT_FILE_PATH == null || ProjectLoadedService.scriptStarted) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ProjectLoadedKt.getLOG().info(PerformanceTestingBundle.message("startup.silent", new Object[0]));
            }
            return;
        }
        ProjectLoadedService.scriptStarted = true;
        ProjectLoadedKt.getLOG().info("Start Execution");
        PerformanceTestSpan.startSpan();
        ApplicationManager.getApplication().executeOnPooledThread(ProjectLoadedKt::runOnProjectInit$lambda$0);
        Pair<String, List<String>> profilerSettings = ProjectLoadedKt.initializeProfilerSettingsForIndexing();
        if (profilerSettings != null) {
            try {
                Profiler profiler = ProfilersController.getInstance().getCurrentProfilerHandler();
                Object object = profilerSettings.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                String string = (String)object;
                Object object2 = profilerSettings.second;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
                profiler.startProfiling(string, (List)object2);
            }
            catch (Exception e) {
                System.err.println("Start profile failed: " + e.getMessage());
                ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
            }
        }
        if (OpenProjectCommand.Companion.shouldOpenInSmartMode(project)) {
            ProjectLoadedKt.runScriptWhenInitializedAndIndexed(project, ProjectLoadedKt.runOnProjectInit$createAlarm(project));
        } else if (SystemProperties.getBooleanProperty((String)"performance.execute.script.after.scanning", (boolean)false)) {
            ProjectLoadedKt.runScriptDuringIndexing(project, ProjectLoadedKt.runOnProjectInit$createAlarm(project));
        } else {
            ProjectLoadedKt.runScriptFromFile(project);
        }
    }

    private static final void runScriptWhenInitializedAndIndexed(Project project, Alarm alarm) {
        DumbService dumbService = DumbService.Companion.getInstance(project);
        Runnable runnable = Context.current().wrap(() -> ProjectLoadedKt.runScriptWhenInitializedAndIndexed$lambda$2(alarm, project));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"wrap(...)");
        dumbService.smartInvokeLater(runnable);
    }

    private static final void runScriptDuringIndexing(Project project, Alarm alarm) {
        ApplicationManager.getApplication().executeOnPooledThread(Context.current().wrap(() -> ProjectLoadedKt.runScriptDuringIndexing$lambda$4(alarm, project)));
    }

    public static final void runPerformanceScript(@Nullable Project project, @Nullable String script, boolean mustExitOnFailure) {
        PlaybackRunner.StatusCallback statusCallback = new CommandLogger();
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        PlaybackRunnerExtended playback = new PlaybackRunnerExtended(script, statusCallback, project2);
        CompletableFuture<?> scriptCallback = playback.run();
        CommandsRunner.setActionCallback(scriptCallback);
        Intrinsics.checkNotNull(scriptCallback);
        ProjectLoadedKt.registerOnFinishRunnables(scriptCallback, mustExitOnFailure);
    }

    @NotNull
    public static final String generifyErrorMessage(@NotNull String originalMessage) {
        Intrinsics.checkNotNullParameter((Object)originalMessage, (String)"originalMessage");
        CharSequence charSequence = originalMessage;
        Regex regex = new Regex("[$@#][A-Za-z0-9-_]+");
        String string = "<ID>";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("[.]([A-Za-z]+[0-9]|[0-9]+[A-Za-z])[A-Za-z0-9]*");
        string = ".<HASH>";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("0x[0-9a-fA-F]+");
        string = "<HEX>";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("[0-9]+");
        string = "<NUM>";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reportErrorsFromMessagePool() {
        MessagePool messagePool = MessagePool.getInstance();
        List ideErrors = messagePool.getFatalErrors(false, true);
        for (AbstractMessage message : ideErrors) {
            try {
                Intrinsics.checkNotNull((Object)message);
                ProjectLoadedKt.reportScriptError(message);
            }
            catch (IOException e) {
                ProjectLoadedKt.getLOG().error((Throwable)e);
            }
            finally {
                message.setRead(true);
            }
        }
    }

    private static final Pair<String, List<String>> initializeProfilerSettingsForIndexing() {
        try {
            List<String> lines = Files.readAllLines(ProjectLoadedKt.getTestFile());
            for (String line : lines) {
                List list;
                Intrinsics.checkNotNull((Object)line);
                if (!StringsKt.startsWith$default((String)line, (String)INDEXING_PROFILER_PREFIX, (boolean)false, (int)2, null)) continue;
                String string = line.substring(17);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
                Regex regex = new Regex("\\s+");
                int n = 2;
                List command = regex.split(charSequence, n);
                String indexingActivity = (String)command.get(0);
                if (command.size() > 1) {
                    char[] cArray = new char[]{','};
                    List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((String)command.get(1)))).toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                } else {
                    list = new ArrayList();
                }
                List profilingParameters = list;
                return new Pair((Object)indexingActivity, (Object)profilingParameters);
            }
        }
        catch (IOException iOException) {
            System.err.println(PerformanceTestingBundle.message("startup.script.read.error", new Object[0]));
            ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void reportScriptError(AbstractMessage errorMessage) throws IOException {
        Throwable throwable;
        Throwable throwable2 = errorMessage.getThrowable();
        Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"getThrowable(...)");
        Throwable cause = throwable = throwable2;
        String causeMessage = null;
        causeMessage = "";
        while (cause.getCause() != null) {
            Throwable throwable3 = cause = cause.getCause();
            Intrinsics.checkNotNull((Object)throwable3);
            causeMessage = throwable3.getMessage();
        }
        CharSequence charSequence = causeMessage;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)(causeMessage = errorMessage.getMessage())) == null || charSequence.length() == 0)) {
            String string;
            String throwableMessage = ProjectLoadedKt.getNonEmptyThrowableMessage(throwable);
            int index = StringsKt.indexOf$default((CharSequence)throwableMessage, (String)"\tat ", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                string = throwableMessage;
            } else {
                String string2 = throwableMessage.substring(0, index);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            causeMessage = string;
        }
        Object index = new String[]{"errors"};
        Path scriptErrorsDir = Path.of(PathManager.getLogPath(), index);
        Files.createDirectories(scriptErrorsDir, new FileAttribute[0]);
        index = Files.walk(scriptErrorsDir, new FileVisitOption[0]);
        Throwable throwable4 = null;
        try {
            Stream stream = (Stream)index;
            boolean bl = false;
            String finalCauseMessage = causeMessage;
            boolean isDuplicated = stream.filter(arg_0 -> ProjectLoadedKt.reportScriptError$lambda$10$lambda$7(ProjectLoadedKt::reportScriptError$lambda$10$lambda$6, arg_0)).anyMatch(arg_0 -> ProjectLoadedKt.reportScriptError$lambda$10$lambda$9(arg_0 -> ProjectLoadedKt.reportScriptError$lambda$10$lambda$8(finalCauseMessage, arg_0), arg_0));
            if (isDuplicated) {
                return;
            }
            stream = Unit.INSTANCE;
        }
        catch (Throwable stream) {
            throwable4 = stream;
            throw stream;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)index, (Throwable)throwable4);
        }
        for (int i = 1; i < 1000; ++i) {
            Path errorDir = scriptErrorsDir.resolve("error-" + i);
            if (Files.exists(errorDir, new LinkOption[0])) continue;
            Files.createDirectories(errorDir, new FileAttribute[0]);
            Files.writeString(errorDir.resolve("message.txt"), (CharSequence)causeMessage, new OpenOption[0]);
            Files.writeString(errorDir.resolve("stacktrace.txt"), (CharSequence)errorMessage.getThrowableText(), new OpenOption[0]);
            List list = errorMessage.getAllAttachments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAttachments(...)");
            List attachments = list;
            int n = ((Collection)attachments).size();
            for (int j = 0; j < n; ++j) {
                Attachment attachment = (Attachment)attachments.get(j);
                Intrinsics.checkNotNull((Object)attachment);
                Path path = errorDir.resolve(j + "-" + attachment.getName());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                ProjectLoadedKt.writeAttachmentToErrorDir(attachment, path);
            }
            return;
        }
        ProjectLoadedKt.getLOG().error("Too many errors have been reported during script execution. See " + scriptErrorsDir);
    }

    private static final void writeAttachmentToErrorDir(Attachment attachment, Path path) {
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            Files.writeString(path, (CharSequence)attachment.getDisplayText(), openOptionArray);
            openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            Files.writeString(path, (CharSequence)System.lineSeparator(), openOptionArray);
        }
        catch (Exception e) {
            ProjectLoadedKt.getLOG().warn("Failed to write attachment `display text`", (Throwable)e);
        }
    }

    private static final String getNonEmptyThrowableMessage(Throwable throwable) {
        if (throwable.getMessage() != null) {
            String string = throwable.getMessage();
            Intrinsics.checkNotNull((Object)string);
            if (!(((CharSequence)string).length() == 0)) {
                String string2 = throwable.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                return string2;
            }
        }
        String string = throwable.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final void runScriptFromFile(Project project) {
        PlaybackRunnerExtended playback = new PlaybackRunnerExtended("%include " + ProjectLoadedKt.getTestFile(), new CommandLogger(), project);
        playback.setScriptDir(ProjectLoadedKt.getTestFile().getParent().toFile());
        if (SystemProperties.getBooleanProperty((String)"performance.execute.script.reportEachCommandAsTelemetrySpan", (boolean)false)) {
            playback.setCommandStartStopProcessor(new ReporterCommandAsTelemetrySpan());
        }
        CompletableFuture<?> scriptCallback = playback.run();
        CommandsRunner.setActionCallback(scriptCallback);
        Intrinsics.checkNotNull(scriptCallback);
        ProjectLoadedKt.registerOnFinishRunnables(scriptCallback, true);
    }

    private static final void registerOnFinishRunnables(CompletableFuture<?> future, boolean mustExitOnFailure) {
        ((CompletableFuture)future.thenRun(ProjectLoadedKt::registerOnFinishRunnables$lambda$11)).exceptionally(arg_0 -> ProjectLoadedKt.registerOnFinishRunnables$lambda$13(mustExitOnFailure, arg_0));
    }

    private static final void storeFailureToFile(String errorMessage) {
        try {
            String string;
            Path logDir = Path.of(PathManager.getLogPath(), new String[0]);
            String ideaLogContent = Files.readString(logDir.resolve("idea.log"));
            Intrinsics.checkNotNull((Object)ideaLogContent);
            CharSequence charSequence = ideaLogContent;
            String string2 = errorMessage;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = ideaLogContent.substring(StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String substringBegin = string3;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String string4 = timestamp.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            String string5 = string4;
            int n = 0;
            int n2 = 10;
            String string6 = string5.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            String date = string6;
            int endIndex = StringsKt.indexOf$default((CharSequence)substringBegin, (String)date, (int)0, (boolean)false, (int)6, null);
            if (endIndex == -1) {
                string = substringBegin;
            } else {
                String string7 = substringBegin.substring(0, endIndex);
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            }
            String errorMessageFromLog = string;
            Path failureCause = logDir.resolve("failure_cause.txt");
            Files.writeString(failureCause, (CharSequence)errorMessageFromLog, new OpenOption[0]);
        }
        catch (Exception e) {
            ProjectLoadedKt.getLOG().error(e.getMessage());
        }
    }

    private static final void runOnProjectInit$lambda$0() {
        ProjectLoadedKt.subscribeToStopProfile();
    }

    private static final Alarm runOnProjectInit$createAlarm(Project $project) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<CodeAnalysisStateListener> serviceClass$iv = CodeAnalysisStateListener.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return new Alarm(((CodeAnalysisStateListener)object).getCs(), Alarm.ThreadToUse.SWING_THREAD);
    }

    /*
     * Unable to fully structure code
     */
    private static final void runScriptWhenInitializedAndIndexed$lambda$2$lambda$1(Project $project, Alarm $alarm) {
        v0 = WindowManager.getInstance().getIdeFrame($project);
        var3_2 = v0 != null ? v0.getStatusBar() : null;
        v1 = statusBar = var3_2 instanceof StatusBarEx != false ? (StatusBarEx)var3_2 : null;
        if (statusBar == null) ** GOTO lbl-1000
        v2 = statusBar.getBackgroundProcesses();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getBackgroundProcesses(...)");
        if (((Collection)v2).isEmpty() == false) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = hasUserVisibleIndicators = false;
        }
        if (DumbService.Companion.isDumb($project) || hasUserVisibleIndicators || !ProjectInitializationDiagnosticService.getInstance((Project)$project).isProjectInitializationAndIndexingFinished()) {
            ProjectLoadedKt.runScriptWhenInitializedAndIndexed($project, $alarm);
        } else {
            ProjectLoadedKt.runScriptFromFile($project);
        }
    }

    private static final void runScriptWhenInitializedAndIndexed$lambda$2(Alarm $alarm, Project $project) {
        Runnable runnable = Context.current().wrap(() -> ProjectLoadedKt.runScriptWhenInitializedAndIndexed$lambda$2$lambda$1($project, $alarm));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"wrap(...)");
        $alarm.addRequest(runnable, 500);
    }

    private static final void runScriptDuringIndexing$lambda$4$lambda$3(Project $project, Alarm $alarm) {
        List list = CoreProgressManager.getCurrentIndicators();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCurrentIndicators(...)");
        List indicators = list;
        boolean indexingInProgress = false;
        for (ProgressIndicator indicator : indicators) {
            String indicatorText = indicator.getText();
            if (indicatorText == null || !StringsKt.contains$default((CharSequence)indicatorText, (CharSequence)"Indexing", (boolean)false, (int)2, null)) continue;
            indexingInProgress = true;
            break;
        }
        if (indexingInProgress) {
            ProjectLoadedKt.runScriptFromFile($project);
        } else {
            ProjectLoadedKt.runScriptDuringIndexing($project, $alarm);
        }
    }

    private static final void runScriptDuringIndexing$lambda$4(Alarm $alarm, Project $project) {
        Runnable runnable = Context.current().wrap(() -> ProjectLoadedKt.runScriptDuringIndexing$lambda$4$lambda$3($project, $alarm));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"wrap(...)");
        $alarm.addRequest(runnable, 500);
    }

    private static final boolean reportScriptError$lambda$10$lambda$6(Path path) {
        return Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)"message.txt");
    }

    private static final boolean reportScriptError$lambda$10$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reportScriptError$lambda$10$lambda$8(String $finalCauseMessage, Path path) {
        try {
            return Intrinsics.areEqual((Object)Files.readString(path), (Object)$finalCauseMessage);
        }
        catch (IOException e) {
            ProjectLoadedKt.getLOG().error(e.getMessage());
            return false;
        }
    }

    private static final boolean reportScriptError$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void registerOnFinishRunnables$lambda$11() {
        ProjectLoadedKt.getLOG().info("Execution of the script has been finished successfully");
    }

    private static final void registerOnFinishRunnables$lambda$13$lambda$12(Throwable $e, boolean $mustExitOnFailure) {
        if (ApplicationManagerEx.isInIntegrationTest()) {
            ProjectLoadedKt.storeFailureToFile($e.getMessage());
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TakeScreenshotCommandKt.takeScreenshotOfAllWindows("onFailure", (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String threadDump = StringsKt.trimIndent((String)("\n            Thread dump before IDE termination:\n            " + ThreadDumper.dumpThreadsToString() + "\n            "));
        ProjectLoadedKt.getLOG().info(threadDump);
        if ($mustExitOnFailure) {
            ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
        }
    }

    private static final Void registerOnFinishRunnables$lambda$13(boolean $mustExitOnFailure, Throwable e) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProjectLoadedKt.registerOnFinishRunnables$lambda$13$lambda$12(e, $mustExitOnFailure));
        return null;
    }

    public static final /* synthetic */ void access$runOnProjectInit(Project project) {
        ProjectLoadedKt.runOnProjectInit(project);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return ProjectLoadedKt.getLOG();
    }
}

