/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.dataextractor;

import com.intellij.driver.model.TextData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.CellReaderGraphics2d;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.DataExtractorGraphics2d;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.ExtractorGraphics2d;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.TextExtractorExtension;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.TextToKeyCache;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/TextParser;", "", "<init>", "()V", "graphics", "Ljava/awt/Graphics2D;", "kotlin.jvm.PlatformType", "Ljava/awt/Graphics2D;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "parseComponent", "", "Lcom/intellij/driver/model/TextData;", "component", "Ljava/awt/Component;", "gatherExtraText", "gatherExtraTextRec", "baseComponent", "currentComponent", "parseCellRenderer", "", "parseData", "", "g", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/ExtractorGraphics2d;", "findContainerComponent", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nTextParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextParser.kt\ncom/jetbrains/performancePlugin/remotedriver/dataextractor/TextParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n1368#2:76\n1454#2,5:77\n1863#2,2:82\n10072#3:84\n10494#3,5:85\n24#4:90\n*S KotlinDebug\n*F\n+ 1 TextParser.kt\ncom/jetbrains/performancePlugin/remotedriver/dataextractor/TextParser\n*L\n37#1:76\n37#1:77,5\n38#1:82,2\n42#1:84\n42#1:85,5\n19#1:90\n*E\n"})
public final class TextParser {
    @NotNull
    public static final TextParser INSTANCE = new TextParser();
    private static final Graphics2D graphics = new BufferedImage(1, 1, 2).createGraphics();
    @NotNull
    private static final Logger logger;

    private TextParser() {
    }

    @NotNull
    public final List<TextData> parseComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Component component2 = this.findContainerComponent(component);
        if (component2 == null) {
            return CollectionsKt.emptyList();
        }
        Component containerComponent = component2;
        int x = containerComponent.getLocationOnScreen().x - component.getLocationOnScreen().x;
        int y = containerComponent.getLocationOnScreen().y - component.getLocationOnScreen().y;
        List data = new ArrayList();
        Graphics2D graphics2D = graphics;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"graphics");
        DataExtractorGraphics2d g = new DataExtractorGraphics2d(graphics2D, data, new Point(x, y), TextToKeyCache.INSTANCE);
        this.parseData(g, containerComponent);
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)data, (Iterable)this.gatherExtraText(component)));
    }

    private final List<TextData> gatherExtraText(Component component) {
        return this.gatherExtraTextRec(component, component);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextData> gatherExtraTextRec(Component baseComponent, Component currentComponent) {
        Iterable iterable;
        List list;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = TextExtractorExtension.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            it = (TextExtractorExtension)t;
            boolean bl = false;
            Iterable list$iv$iv = it.extractTextFromComponent(currentComponent);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List $this$gatherExtraTextRec_u24lambda_u242 = list = (List)destination$iv$iv;
        boolean bl = false;
        Component[] $this$forEach$iv = (Component[])$this$gatherExtraTextRec_u24lambda_u242;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            it = (TextData)t;
            boolean bl2 = false;
            ((TextData)it).setPoint(SwingUtilities.convertPoint(currentComponent, ((TextData)it).getPoint(), baseComponent));
        }
        List thisText = list;
        Collection collection = thisText;
        Component[] componentArray = currentComponent instanceof Container ? (Component[])currentComponent : null;
        if (componentArray != null && (componentArray = componentArray.getComponents()) != null) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            $this$forEach$iv = componentArray;
            Collection collection2 = collection;
            boolean $i$f$flatMap2 = false;
            Iterator iterator2 = $this$flatMap$iv2;
            Collection collection3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            int n = ((void)$this$flatMapTo$iv$iv2).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it2 = element$iv$iv = $this$flatMapTo$iv$iv2[i];
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it2);
                Iterable list$iv$iv = INSTANCE.gatherExtraTextRec(baseComponent, (Component)it2);
                CollectionsKt.addAll((Collection)collection3, (Iterable)list$iv$iv);
            }
            collection = collection2;
            iterable = (List)collection3;
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)iterable);
    }

    @NotNull
    public final List<String> parseCellRenderer(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        List data = new ArrayList();
        Graphics2D graphics2D = graphics;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"graphics");
        CellReaderGraphics2d g = new CellReaderGraphics2d(graphics2D, data);
        this.parseData(g, component);
        return data;
    }

    private final void parseData(ExtractorGraphics2d g, Component component) {
        GuiActionRunner.execute(new GuiTask(component, g){
            final /* synthetic */ Component $component;
            final /* synthetic */ ExtractorGraphics2d $g;
            {
                this.$component = $component;
                this.$g = $g;
            }

            protected void executeInEDT() {
                try {
                    this.$component.paint(this.$g);
                }
                catch (ProcessCanceledException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    TextParser.access$getLogger$p().error("Text parsing error. Can't do paint on " + this.$component.getClass().getSimpleName(), (Throwable)e);
                }
            }
        });
    }

    private final Component findContainerComponent(Component component) {
        if (component.getParent() instanceof JViewport) {
            return component.getParent();
        }
        return component;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        TextParser $this$thisLogger$iv = INSTANCE;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TextParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TextParser.logger = logger;
    }
}

