/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.actions.diff.PresentableGoToChangePopupAction;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0002/0B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u000e\u001a\u00020\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010!\u001a\u00020\u001cH\u0014J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001eH\u0014J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001eH\u0014J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001eH\u0014J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001eH\u0014J\b\u0010*\u001a\u00020\u001eH\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020\u001cH\u0002J\u0012\u0010.\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0015\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016\u00a2\u0006\u0002\b\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/MutableDiffRequestChainProcessor;", "Lcom/intellij/diff/impl/CacheDiffRequestProcessor$Simple;", "project", "Lcom/intellij/openapi/project/Project;", "chain", "Lcom/intellij/diff/chains/DiffRequestChain;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diff/chains/DiffRequestChain;)V", "_chain", "asyncChangeListener", "Lcom/intellij/diff/chains/AsyncDiffRequestChain$Listener;", "newChain", "getChain", "()Lcom/intellij/diff/chains/DiffRequestChain;", "setChain", "(Lcom/intellij/diff/chains/DiffRequestChain;)V", "value", "", "currentIndex", "getCurrentIndex", "()I", "selectionEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/changes/ui/MutableDiffRequestChainProcessor$SelectionListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSelectionEventDispatcher", "()Lcom/intellij/util/EventDispatcher;", "", "clearCache", "", "scrollToChangePolicy", "Lcom/intellij/diff/util/DiffUserDataKeysEx$ScrollToPolicy;", "onDispose", "getCurrentRequestProvider", "Lcom/intellij/diff/chains/DiffRequestProducer;", "hasNextChange", "fromUpdate", "hasPrevChange", "goToNextChange", "fromDifferences", "goToPrevChange", "isNavigationEnabled", "createGoToChangeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "selectCurrentChange", "updateChain", "MyGoToChangePopupAction", "SelectionListener", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class MutableDiffRequestChainProcessor
extends CacheDiffRequestProcessor.Simple {
    @Nullable
    private DiffRequestChain _chain;
    @NotNull
    private final AsyncDiffRequestChain.Listener asyncChangeListener;
    private int currentIndex;
    @NotNull
    private final EventDispatcher<SelectionListener> selectionEventDispatcher;

    public MutableDiffRequestChainProcessor(@NotNull Project project, @Nullable DiffRequestChain chain) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.asyncChangeListener = () -> MutableDiffRequestChainProcessor.asyncChangeListener$lambda$0(this);
        EventDispatcher eventDispatcher = EventDispatcher.create(SelectionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.selectionEventDispatcher = eventDispatcher;
        this.setChain(chain);
    }

    @Nullable
    public final DiffRequestChain getChain() {
        return this._chain;
    }

    public final void setChain(@Nullable DiffRequestChain newChain) {
        this.updateChain(newChain);
        this.dropCaches();
        this.updateRequest();
    }

    public final int getCurrentIndex() {
        return this.currentIndex;
    }

    @NotNull
    public final EventDispatcher<SelectionListener> getSelectionEventDispatcher() {
        return this.selectionEventDispatcher;
    }

    public final void setChain(@Nullable DiffRequestChain chain, boolean clearCache, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.updateChain(chain);
        if (clearCache) {
            this.dropCaches();
        }
        this.updateRequest(false, !clearCache, scrollToChangePolicy);
    }

    public static /* synthetic */ void setChain$default(MutableDiffRequestChainProcessor mutableDiffRequestChainProcessor, DiffRequestChain diffRequestChain, boolean bl, DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            scrollToPolicy = null;
        }
        mutableDiffRequestChainProcessor.setChain(diffRequestChain, bl, scrollToPolicy);
    }

    protected void onDispose() {
        DiffRequestChain chain = this.getChain();
        if (chain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)chain).onAssigned(false);
        }
        super.onDispose();
    }

    @Nullable
    protected DiffRequestProducer getCurrentRequestProvider() {
        Object object = this.getChain();
        if (object == null || (object = object.getRequests()) == null) {
            return null;
        }
        Object requests = object;
        return this.currentIndex < 0 || this.currentIndex >= requests.size() ? null : (DiffRequestProducer)requests.get(this.currentIndex);
    }

    protected boolean hasNextChange(boolean fromUpdate) {
        DiffRequestChain diffRequestChain = this.getChain();
        if (diffRequestChain == null) {
            return false;
        }
        DiffRequestChain chain = diffRequestChain;
        List list = chain.getRequests();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRequests(...)");
        return this.currentIndex < CollectionsKt.getLastIndex((List)list);
    }

    protected boolean hasPrevChange(boolean fromUpdate) {
        DiffRequestChain diffRequestChain = this.getChain();
        if (diffRequestChain == null) {
            return false;
        }
        DiffRequestChain chain = diffRequestChain;
        return this.currentIndex > 0 && chain.getRequests().size() > 1;
    }

    protected void goToNextChange(boolean fromDifferences) {
        this.goToNextChangeImpl(fromDifferences, () -> MutableDiffRequestChainProcessor.goToNextChange$lambda$1(this));
    }

    protected void goToPrevChange(boolean fromDifferences) {
        this.goToPrevChangeImpl(fromDifferences, () -> MutableDiffRequestChainProcessor.goToPrevChange$lambda$2(this));
    }

    protected boolean isNavigationEnabled() {
        DiffRequestChain diffRequestChain = this.getChain();
        if (diffRequestChain == null) {
            return false;
        }
        DiffRequestChain chain = diffRequestChain;
        return chain.getRequests().size() > 1;
    }

    @NotNull
    protected AnAction createGoToChangeAction() {
        return (AnAction)new MyGoToChangePopupAction();
    }

    private final void selectCurrentChange() {
        DiffRequestProducer diffRequestProducer = this.getCurrentRequestProvider();
        ChangeDiffRequestChain.Producer producer = diffRequestProducer instanceof ChangeDiffRequestChain.Producer ? (ChangeDiffRequestChain.Producer)diffRequestProducer : null;
        if (producer == null) {
            return;
        }
        ChangeDiffRequestChain.Producer producer2 = producer;
        ((SelectionListener)this.selectionEventDispatcher.getMulticaster()).onSelected(producer2);
    }

    private final void updateChain(DiffRequestChain newChain) {
        AsyncDiffRequestChain it;
        DiffRequestChain diffRequestChain = this._chain;
        AsyncDiffRequestChain asyncDiffRequestChain = diffRequestChain instanceof AsyncDiffRequestChain ? (AsyncDiffRequestChain)diffRequestChain : null;
        if (asyncDiffRequestChain != null) {
            it = asyncDiffRequestChain;
            boolean bl = false;
            it.onAssigned(false);
            it.removeListener(this.asyncChangeListener);
        }
        this._chain = newChain;
        AsyncDiffRequestChain asyncDiffRequestChain2 = newChain instanceof AsyncDiffRequestChain ? (AsyncDiffRequestChain)newChain : null;
        if (asyncDiffRequestChain2 != null) {
            it = asyncDiffRequestChain2;
            boolean bl = false;
            it.onAssigned(true);
            it.addListener(this.asyncChangeListener, (Disposable)this);
        }
        DiffRequestChain diffRequestChain2 = newChain;
        this.currentIndex = diffRequestChain2 != null ? diffRequestChain2.getIndex() : 0;
    }

    private static final void asyncChangeListener$lambda$0(MutableDiffRequestChainProcessor this$0) {
        this$0.dropCaches();
        DiffRequestChain diffRequestChain = this$0.getChain();
        this$0.currentIndex = diffRequestChain != null ? diffRequestChain.getIndex() : 0;
        this$0.updateRequest(true);
    }

    private static final void goToNextChange$lambda$1(MutableDiffRequestChainProcessor this$0) {
        ++this$0.currentIndex;
        this$0.selectCurrentChange();
    }

    private static final void goToPrevChange$lambda$2(MutableDiffRequestChainProcessor this$0) {
        --this$0.currentIndex;
        this$0.selectCurrentChange();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/MutableDiffRequestChainProcessor$MyGoToChangePopupAction;", "Lcom/intellij/openapi/vcs/changes/actions/diff/PresentableGoToChangePopupAction$Default;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/MutableDiffRequestChainProcessor;)V", "getChanges", "Lcom/intellij/openapi/ListSelection;", "onSelected", "", "change", "intellij.platform.vcs.impl"})
    private final class MyGoToChangePopupAction
    extends PresentableGoToChangePopupAction.Default<ChangeDiffRequestChain.Producer> {
        @Override
        @NotNull
        protected ListSelection<? extends ChangeDiffRequestChain.Producer> getChanges() {
            Object object = MutableDiffRequestChainProcessor.this.getChain();
            if (object == null || (object = object.getRequests()) == null) {
                ListSelection listSelection = ListSelection.empty();
                Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"empty(...)");
                return listSelection;
            }
            Object requests = object;
            ListSelection listSelection = ListSelection.createAt((List)requests, (int)MutableDiffRequestChainProcessor.this.getCurrentIndex());
            Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"createAt(...)");
            ListSelection list = listSelection;
            ListSelection listSelection2 = list.map(arg_0 -> MyGoToChangePopupAction.getChanges$lambda$1(MyGoToChangePopupAction::getChanges$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)listSelection2, (String)"map(...)");
            return listSelection2;
        }

        @Override
        protected void onSelected(@NotNull ChangeDiffRequestChain.Producer change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Object object = MutableDiffRequestChainProcessor.this.getChain();
            if (object == null || (object = object.getRequests()) == null) {
                return;
            }
            int newIndex = CollectionsKt.indexOf((List)object, (Object)change);
            MutableDiffRequestChainProcessor.this.currentIndex = newIndex;
            MutableDiffRequestChainProcessor.this.selectCurrentChange();
            MutableDiffRequestChainProcessor.this.updateRequest();
        }

        private static final ChangeDiffRequestChain.Producer getChanges$lambda$0(DiffRequestProducer it) {
            return it instanceof ChangeDiffRequestChain.Producer ? (ChangeDiffRequestChain.Producer)it : null;
        }

        private static final ChangeDiffRequestChain.Producer getChanges$lambda$1(Function1 $tmp0, Object p0) {
            return (ChangeDiffRequestChain.Producer)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/MutableDiffRequestChainProcessor$SelectionListener;", "Ljava/util/EventListener;", "onSelected", "", "producer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "intellij.platform.vcs.impl"})
    public static interface SelectionListener
    extends EventListener {
        public void onSelected(@NotNull ChangeDiffRequestChain.Producer var1);
    }
}

