/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.ex;

import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementContainer;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementParameterizedCreator;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementContainerEx;

@ApiStatus.Internal
public class JpsElementContainerImpl
extends JpsElementContainerEx
implements JpsElementContainer {
    private final Object myDataLock;
    private final Map<JpsElementChildRole<?>, JpsElement> myElements;
    @NotNull
    private final JpsCompositeElementBase<?> myParent;

    public JpsElementContainerImpl(@NotNull JpsCompositeElementBase<?> parent) {
        if (parent == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(0);
        }
        this.myDataLock = new Object();
        this.myElements = CollectionFactory.createSmallMemoryFootprintMap((int)1);
        this.myParent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpsElementContainerImpl(@NotNull JpsElementContainerEx original, @NotNull JpsCompositeElementBase<?> parent) {
        if (original == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(2);
        }
        this.myDataLock = new Object();
        this.myElements = CollectionFactory.createSmallMemoryFootprintMap((int)1);
        this.myParent = parent;
        Object object = original.getDataLock();
        synchronized (object) {
            for (Map.Entry<JpsElementChildRole<?>, JpsElement> entry : original.getElementsMap().entrySet()) {
                JpsElementChildRole<?> role = entry.getKey();
                Object copy = entry.getValue().getBulkModificationSupport().createCopy();
                JpsElementBase.setParent(copy, this.myParent);
                this.myElements.put(role, (JpsElement)copy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JpsElement> T getChild(@NotNull JpsElementChildRole<T> role) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(3);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return (T)this.myElements.get(role);
        }
    }

    @Override
    @NotNull
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T setChild(@NotNull K role, @NotNull P param) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(4);
        }
        if (param == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(5);
        }
        Object child = ((JpsElementParameterizedCreator)((Object)role)).create(param);
        Object e = this.setChild((JpsElementChildRole<T>)role, (T)child);
        if (e == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(6);
        }
        return (T)e;
    }

    @Override
    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T setChild(@NotNull K role) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(7);
        }
        Object child = ((JpsElementCreator)((Object)role)).create();
        Object e = this.setChild((JpsElementChildRole<T>)role, (T)child);
        if (e == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(8);
        }
        return (T)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public <T extends JpsElement, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(9);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        JpsElement cached = this.myElements.get(role);
        if (cached != null) {
            JpsElement jpsElement = cached;
            // MONITOREXIT : object
            if (jpsElement != null) return (T)jpsElement;
            JpsElementContainerImpl.$$$reportNull$$$0(10);
            return (T)jpsElement;
        }
        Object e = this.putChild(role, (T)((JpsElementCreator)((Object)role)).create());
        // MONITOREXIT : object
        if (e != null) return (T)e;
        JpsElementContainerImpl.$$$reportNull$$$0(11);
        return (T)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JpsElement, P, K extends JpsElementChildRole<T>> T getOrSetChild(@NotNull K role, @NotNull Supplier<P> param) {
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(12);
        }
        if (param == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(13);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            JpsElement cached = this.myElements.get(role);
            if (cached != null) {
                return (T)cached;
            }
            return (T)this.putChild(role, (T)((JpsElementParameterizedCreator)((Object)role)).create(param.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JpsElement> T setChild(JpsElementChildRole<T> role, T child) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.putChild(role, child);
        }
    }

    @NotNull
    private <T extends JpsElement> T putChild(JpsElementChildRole<T> role, T child) {
        JpsElementBase.setParent(child, this.myParent);
        this.myElements.put(role, child);
        T t = child;
        if (t == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(14);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends JpsElement> void removeChild(@NotNull JpsElementChildRole<T> role) {
        JpsElement removed;
        if (role == null) {
            JpsElementContainerImpl.$$$reportNull$$$0(15);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            removed = this.myElements.remove(role);
        }
        if (removed == null) {
            return;
        }
        JpsElementBase.setParent(removed, null);
    }

    @Override
    protected final Object getDataLock() {
        return this.myDataLock;
    }

    @Override
    protected final Map<JpsElementChildRole<?>, JpsElement> getElementsMap() {
        return this.myElements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/ex/JpsElementContainerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/ex/JpsElementContainerImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setChild";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrSetChild";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "putChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setChild";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrSetChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

