/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run.terminal;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sh.run.ShRunner;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

public class ShTerminalRunner
implements ShRunner {
    @Override
    public void run(@NotNull Project project, @NotNull String command, @NotNull String workingDirectory, @NotNull @NlsContexts.TabTitle String title, boolean activateToolWindow) {
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ShTerminalRunner.$$$reportNull$$$0(1);
        }
        if (workingDirectory == null) {
            ShTerminalRunner.$$$reportNull$$$0(2);
        }
        if (title == null) {
            ShTerminalRunner.$$$reportNull$$$0(3);
        }
        TerminalToolWindowManager terminalToolWindowManager = TerminalToolWindowManager.getInstance((Project)project);
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        if (window == null) {
            return;
        }
        ContentManager contentManager = window.getContentManager();
        Pair<Content, TerminalWidget> pair = this.getSuitableProcess(project, contentManager, workingDirectory);
        if (pair == null) {
            terminalToolWindowManager.createShellWidget(workingDirectory, title, activateToolWindow, activateToolWindow).sendCommandToExecute(command);
            return;
        }
        if (activateToolWindow) {
            window.activate(null);
        }
        ((Content)pair.first).setDisplayName(title);
        contentManager.setSelectedContent((Content)pair.first);
        ((TerminalWidget)pair.second).sendCommandToExecute(command);
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        ToolWindow window;
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(4);
        }
        return (window = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal")) != null && window.isAvailable();
    }

    @Nullable
    private Pair<Content, TerminalWidget> getSuitableProcess(@NotNull Project project, @NotNull ContentManager contentManager, @NotNull String workingDirectory) {
        Pair<Content, TerminalWidget> pair;
        Content selectedContent;
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(5);
        }
        if (contentManager == null) {
            ShTerminalRunner.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            ShTerminalRunner.$$$reportNull$$$0(7);
        }
        if ((selectedContent = contentManager.getSelectedContent()) != null && (pair = this.getSuitableProcess(project, selectedContent, workingDirectory)) != null) {
            return pair;
        }
        return Arrays.stream(contentManager.getContents()).map(content -> this.getSuitableProcess(project, (Content)content, workingDirectory)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    protected Pair<Content, TerminalWidget> getSuitableProcess(@NotNull Project project, @NotNull Content content, @NotNull String workingDirectory) {
        ShellTerminalWidget shellTerminalWidget;
        TerminalWidget widget;
        if (project == null) {
            ShTerminalRunner.$$$reportNull$$$0(8);
        }
        if (content == null) {
            ShTerminalRunner.$$$reportNull$$$0(9);
        }
        if (workingDirectory == null) {
            ShTerminalRunner.$$$reportNull$$$0(10);
        }
        if ((widget = TerminalToolWindowManager.findWidgetByContent((Content)content)) == null || widget instanceof JBTerminalWidget && !(widget instanceof ShellTerminalWidget)) {
            return null;
        }
        if (widget instanceof ShellTerminalWidget && !(shellTerminalWidget = (ShellTerminalWidget)widget).getTypedShellCommand().isEmpty()) {
            return null;
        }
        ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector((TtyConnector)widget.getTtyConnector());
        if (processTtyConnector == null || TerminalUtil.hasRunningCommands((ProcessTtyConnector)processTtyConnector)) {
            return null;
        }
        String currentWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory((TerminalWidget)widget);
        if (!FileUtil.pathsEqual((String)workingDirectory, (String)currentWorkingDirectory)) {
            return null;
        }
        return new Pair((Object)content, (Object)widget);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/run/terminal/ShTerminalRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

