/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.spelling.morfologik.WeightedSuggestion;
import org.languagetool.tools.StringTools;

public class MorfologikSpeller {
    private static final LoadingCache<String, Dictionary> dictCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Dictionary>(){

        public Dictionary load(@NotNull String fileInClassPath) throws IOException {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            if (dataBroker.resourceExists(fileInClassPath)) {
                return Dictionary.read(dataBroker.getFromResourceDirAsUrl(fileInClassPath));
            }
            return Dictionary.read(Paths.get(fileInClassPath, new String[0]));
        }
    });
    private final Dictionary dictionary;
    private final Speller speller;
    private final int maxEditDistance;

    public MorfologikSpeller(String fileInClassPath, int maxEditDistance) {
        this(MorfologikSpeller.getDictionaryWithCaching(fileInClassPath), maxEditDistance);
    }

    public MorfologikSpeller(String fileInClassPath) throws IOException {
        this(fileInClassPath, 1);
    }

    MorfologikSpeller(Dictionary dictionary, int maxEditDistance) {
        if (maxEditDistance <= 0) {
            throw new RuntimeException("maxEditDistance must be > 0: " + maxEditDistance);
        }
        this.dictionary = dictionary;
        this.maxEditDistance = maxEditDistance;
        this.speller = new Speller(dictionary, maxEditDistance);
    }

    public static Dictionary getDictionaryWithCaching(@NotNull String fileInClassPath) {
        return (Dictionary)dictCache.getUnchecked((Object)fileInClassPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMisspelled(String word) {
        if (word.isEmpty() || "LanguageTool".equals(word) || "LanguageTooler".equals(word)) {
            return false;
        }
        MorfologikSpeller morfologikSpeller = this;
        synchronized (morfologikSpeller) {
            return this.speller.isMisspelled(word);
        }
    }

    public synchronized List<String> findReplacements(String word) {
        return this.speller.findReplacements(word);
    }

    public synchronized List<String> findSimilarWords(String word) {
        return this.speller.findSimilarWords(word);
    }

    @Deprecated
    public Speller getSpeller() {
        return this.speller;
    }

    /*
     * WARNING - void declaration
     */
    public List<WeightedSuggestion> getSuggestions(String word) {
        ArrayList<WeightedSuggestion> suggestions;
        block15: {
            void var6_11;
            WeightedSuggestion sugg;
            block14: {
                void var6_9;
                suggestions = new ArrayList<WeightedSuggestion>();
                if (word.length() > 250) {
                    return suggestions;
                }
                Speller speller = new Speller(this.dictionary, this.maxEditDistance);
                if (word.length() < 50) {
                    ArrayList<Speller.CandidateData> replacementCandidates = speller.findReplacementCandidates(word);
                    for (Speller.CandidateData candidateData : replacementCandidates) {
                        suggestions.add(new WeightedSuggestion(candidateData.getWord(), candidateData.getDistance()));
                    }
                }
                List<Speller.CandidateData> runOnCandidates = speller.replaceRunOnWordCandidates(word);
                for (Speller.CandidateData runOnCandidate : runOnCandidates) {
                    suggestions.add(new WeightedSuggestion(runOnCandidate.getWord(), runOnCandidate.getDistance()));
                }
                if (!this.dictionary.metadata.isConvertingCase() || !StringTools.isAllUppercase(word)) break block14;
                boolean bl = false;
                while (var6_9 < suggestions.size()) {
                    int auxIndex;
                    sugg = (WeightedSuggestion)suggestions.get((int)var6_9);
                    String allUppercase = sugg.getWord().toUpperCase();
                    if (allUppercase.equals(word) || StringTools.isMixedCase(((WeightedSuggestion)suggestions.get((int)var6_9)).getWord())) {
                        allUppercase = sugg.getWord();
                    }
                    if ((auxIndex = this.getSuggestionIndex(suggestions, allUppercase)) > var6_9) {
                        suggestions.remove(auxIndex);
                    }
                    if (auxIndex > -1 && auxIndex < var6_9) {
                        suggestions.remove((int)var6_9);
                        --var6_9;
                    } else {
                        suggestions.set((int)var6_9, new WeightedSuggestion(allUppercase, sugg.getWeight()));
                    }
                    ++var6_9;
                }
                break block15;
            }
            if (!this.dictionary.metadata.isConvertingCase() || !StringTools.startsWithUppercase(word)) break block15;
            boolean bl = false;
            while (var6_11 < suggestions.size()) {
                int auxIndex;
                sugg = (WeightedSuggestion)suggestions.get((int)var6_11);
                String uppercaseFirst = StringTools.uppercaseFirstChar(sugg.getWord());
                if (uppercaseFirst.equals(word) || StringTools.isMixedCase(((WeightedSuggestion)suggestions.get((int)var6_11)).getWord())) {
                    uppercaseFirst = sugg.getWord();
                }
                if ((auxIndex = this.getSuggestionIndex(suggestions, uppercaseFirst)) > var6_11) {
                    suggestions.remove(auxIndex);
                }
                if (auxIndex > -1 && auxIndex < var6_11) {
                    suggestions.remove((int)var6_11);
                    --var6_11;
                } else {
                    suggestions.set((int)var6_11, new WeightedSuggestion(uppercaseFirst, sugg.getWeight()));
                }
                ++var6_11;
            }
        }
        return suggestions;
    }

    private int getSuggestionIndex(List<WeightedSuggestion> suggestions, String uppercaseFirst) {
        int i = 0;
        for (WeightedSuggestion suggestion : suggestions) {
            if (suggestion.getWord().equals(uppercaseFirst)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean convertsCase() {
        return this.speller.convertsCase();
    }

    public String toString() {
        return "dist=" + this.maxEditDistance;
    }

    public synchronized int getFrequency(String word) {
        int freq = this.speller.getFrequency(word);
        if (freq == 0 && !word.equals(word.toLowerCase())) {
            freq = this.speller.getFrequency(word.toLowerCase());
        }
        return freq;
    }
}

