/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.values;

import com.intellij.util.SmartFMap;
import com.intellij.xdebugger.frame.XValueNode;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.ValuesPolicy;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.values.DataFrameDebugValueUtilKt;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataFrameDebugValue
extends PyDebugValue {
    private final ColumnNode treeColumns;

    public DataFrameDebugValue(@NotNull String name2, @Nullable String type2, @Nullable String typeQualifier, @Nullable String value, boolean container, @Nullable String shape, boolean isReturnedVal, boolean isIPythonHidden, boolean errorOnEval, @Nullable String typeRendererId, @NotNull PyFrameAccessor frameAccessor) {
        if (name2 == null) {
            DataFrameDebugValue.$$$reportNull$$$0(0);
        }
        if (frameAccessor == null) {
            DataFrameDebugValue.$$$reportNull$$$0(1);
        }
        super(name2, type2, typeQualifier, value, container, shape, isReturnedVal, isIPythonHidden, errorOnEval, typeRendererId, frameAccessor);
        this.treeColumns = new ColumnNode();
    }

    public DataFrameDebugValue(@NotNull String name2, @Nullable String type2, @Nullable String typeQualifier, @Nullable String value, boolean container, @Nullable String shape, boolean isReturnedVal, boolean isIPythonHidden, boolean errorOnEval, @Nullable String typeRendererId, @Nullable PyDebugValue parent, @NotNull PyFrameAccessor frameAccessor) {
        if (name2 == null) {
            DataFrameDebugValue.$$$reportNull$$$0(2);
        }
        if (frameAccessor == null) {
            DataFrameDebugValue.$$$reportNull$$$0(3);
        }
        super(name2, type2, typeQualifier, value, container, shape, isReturnedVal, isIPythonHidden, errorOnEval, typeRendererId, parent, frameAccessor);
        this.treeColumns = new ColumnNode();
    }

    public DataFrameDebugValue(@NotNull PyDebugValue value, @NotNull String newName) {
        if (value == null) {
            DataFrameDebugValue.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            DataFrameDebugValue.$$$reportNull$$$0(5);
        }
        super(value, newName);
        this.treeColumns = new ColumnNode();
    }

    public DataFrameDebugValue(@NotNull PyDebugValue value) {
        if (value == null) {
            DataFrameDebugValue.$$$reportNull$$$0(6);
        }
        super(value);
        this.treeColumns = new ColumnNode();
    }

    @Override
    @NotNull
    public PyDebugCallback<String> createDebugValueCallback() {
        return new PyDebugCallback<String>(){

            @Override
            public void ok(String value) {
                DataFrameDebugValue.this.myLoadValuePolicy = ValuesPolicy.SYNC;
                DataFrameDebugValue.this.myValue = value;
                InformationColumns columns = DataFrameDebugValueUtilKt.getColumnData(value);
                if (columns != null) {
                    DataFrameDebugValue.this.setColumns(columns);
                }
                for (XValueNode node : DataFrameDebugValue.this.myValueNodes) {
                    if (node == null || node.isObsolete()) continue;
                    DataFrameDebugValue.this.updateNodeValueAfterLoading(node, value, "", null);
                }
            }

            @Override
            public void error(PyDebuggerException exception) {
                LOG.error(exception.getMessage());
            }
        };
    }

    public ColumnNode getTreeColumns() {
        return this.treeColumns;
    }

    public void setColumns(@NotNull InformationColumns informationColumns) {
        if (informationColumns == null) {
            DataFrameDebugValue.$$$reportNull$$$0(7);
        }
        for (List<String> columns : informationColumns.columns) {
            ColumnNode node = this.treeColumns.addChildIfNotExist(columns.get(0));
            if (!informationColumns.isMultiIndex) continue;
            for (int j = 1; j < columns.size(); ++j) {
                node = node.addChildIfNotExist(columns.get(j));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "informationColumns";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/values/DataFrameDebugValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setColumns";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ColumnNode {
        SmartFMap<String, ColumnNode> children = SmartFMap.emptyMap();

        private ColumnNode() {
        }

        public ColumnNode addChildIfNotExist(@NotNull String name2) {
            if (name2 == null) {
                ColumnNode.$$$reportNull$$$0(0);
            }
            if (this.children.containsKey((Object)name2)) {
                return (ColumnNode)this.children.get((Object)name2);
            }
            ColumnNode newNode = new ColumnNode();
            this.children = this.children.plus((Object)name2, (Object)newNode);
            return newNode;
        }

        public ColumnNode getChildIfExist(@NotNull String name2) {
            if (name2 == null) {
                ColumnNode.$$$reportNull$$$0(1);
            }
            return (ColumnNode)this.children.get((Object)name2);
        }

        public Set<String> getChildrenName() {
            return this.children.keySet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/jetbrains/python/debugger/values/DataFrameDebugValue$ColumnNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChildIfNotExist";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChildIfExist";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class InformationColumns {
        public boolean isMultiIndex;
        public List<List<String>> columns;
    }
}

