//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4PolyhedraHistorical
//
// Class description:
//
// Data structure for G4Polyhedra.

// Author: David C. Williams (UCSC), 1998 - Created
// --------------------------------------------------------------------
#ifndef G4POLYHEDRAHISTORICAL_HH
#define G4POLYHEDRAHISTORICAL_HH

#include "G4Types.hh"

/**
 * @brief G4PolyhedraHistorical is a data structure for use in G4Polyhedra.
 */

class G4PolyhedraHistorical
{
  public:

    G4PolyhedraHistorical() = default;
    G4PolyhedraHistorical( G4int z_planes );
    ~G4PolyhedraHistorical();
    G4PolyhedraHistorical( const G4PolyhedraHistorical &source );
    G4PolyhedraHistorical& operator=( const G4PolyhedraHistorical& right );

    G4double Start_angle = 0.0;
    G4double Opening_angle = 0.0;
    G4int numSide = 0;
    G4int Num_z_planes = 0;
    G4double* Z_values = nullptr;
    G4double* Rmin = nullptr;
    G4double* Rmax = nullptr;
};

#endif
