/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.printer.configuration.imports;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.ImportDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithName;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.configuration.ImportOrderingStrategy;

public class EclipseImportOrderingStrategy
implements ImportOrderingStrategy {
    private boolean sortImportsAlphabetically = false;

    @Override
    public List<NodeList<ImportDeclaration>> sortImports(NodeList<ImportDeclaration> nodes) {
        NodeList<ImportDeclaration> staticImports = new NodeList<ImportDeclaration>();
        NodeList<ImportDeclaration> javaImports = new NodeList<ImportDeclaration>();
        NodeList<ImportDeclaration> javaXImports = new NodeList<ImportDeclaration>();
        NodeList<ImportDeclaration> orgImports = new NodeList<ImportDeclaration>();
        NodeList<ImportDeclaration> comImports = new NodeList<ImportDeclaration>();
        NodeList<ImportDeclaration> otherImports = new NodeList<ImportDeclaration>();
        for (ImportDeclaration importDeclaration : nodes) {
            if (importDeclaration.isStatic()) {
                staticImports.add(importDeclaration);
                continue;
            }
            String importName = importDeclaration.getNameAsString();
            if (importName.startsWith("java.")) {
                javaImports.add(importDeclaration);
                continue;
            }
            if (importName.startsWith("javax.")) {
                javaXImports.add(importDeclaration);
                continue;
            }
            if (importName.startsWith("org.")) {
                orgImports.add(importDeclaration);
                continue;
            }
            if (importName.startsWith("com.")) {
                comImports.add(importDeclaration);
                continue;
            }
            otherImports.add(importDeclaration);
        }
        if (this.sortImportsAlphabetically) {
            Comparator sortLogic = Comparator.comparing(NodeWithName::getNameAsString);
            staticImports.sort(sortLogic);
            javaImports.sort(sortLogic);
            javaXImports.sort(sortLogic);
            orgImports.sort(sortLogic);
            comImports.sort(sortLogic);
            otherImports.sort(sortLogic);
        }
        return Arrays.asList(staticImports, javaImports, javaXImports, orgImports, comImports, otherImports);
    }

    @Override
    public void setSortImportsAlphabetically(boolean sortAlphabetically) {
        this.sortImportsAlphabetically = sortAlphabetically;
    }

    @Override
    public boolean isSortImportsAlphabetically() {
        return this.sortImportsAlphabetically;
    }
}

