/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.JavaProjectHelper;
import org.javamodularity.moduleplugin.tasks.RunTaskMutator;
import org.joor.Reflect;

public class ModularJavaExec
extends JavaExec {
    private static final Logger LOGGER = Logging.getLogger(ModularJavaExec.class);
    @Internal
    private final List<String> ownJvmArgs = new ArrayList<String>();

    public ModularJavaExec() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            this.getModularity().getInferModulePath().set((Object)true);
        }
    }

    List<String> getOwnJvmArgs() {
        return this.ownJvmArgs;
    }

    public JavaExec jvmArgs(Object ... arguments) {
        for (Object arg : arguments) {
            this.ownJvmArgs.add(String.valueOf(arg));
        }
        return super.jvmArgs(arguments);
    }

    public JavaExec jvmArgs(Iterable<?> arguments) {
        arguments.forEach(arg -> this.ownJvmArgs.add(String.valueOf(arg)));
        return super.jvmArgs(arguments);
    }

    public void setJvmArgs(List<String> arguments) {
        this.ownJvmArgs.clear();
        this.ownJvmArgs.addAll(arguments);
        super.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.ownJvmArgs.clear();
        arguments.forEach(arg -> this.ownJvmArgs.add(String.valueOf(arg)));
        super.setJvmArgs(arguments);
    }

    @Input
    public String getMain() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            return ModularJavaExec.stripModule((String)this.getMainClass().getOrNull());
        }
        return super.getMain();
    }

    public JavaExec setMain(String mainClassName) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            this.getMainClass().set((Object)ModularJavaExec.stripModule(mainClassName));
        } else {
            super.setMain(mainClassName);
        }
        return this;
    }

    private static String stripModule(String main) {
        if (main == null) {
            return main;
        }
        int idx = main.indexOf(47);
        return idx < 0 ? main : main.substring(idx + 1);
    }

    @TaskAction
    public void exec() {
        if (new JavaProjectHelper(this.getProject()).shouldFixEffectiveArguments()) {
            this.execFixEffectiveArguments();
        } else {
            super.exec();
        }
    }

    private void execFixEffectiveArguments() {
        this.setJvmArgs(this.getJvmArgs());
        Object hb = Reflect.on((Object)((Object)this)).field("javaExecHandleBuilder").get();
        Reflect handleBuilder = Reflect.on((Object)hb);
        String executable = (String)handleBuilder.call("getExecutable").get();
        if (executable == null || executable.isEmpty()) {
            throw new IllegalStateException("execCommand == null!");
        }
        Object arguments = (List)handleBuilder.field("javaOptions").call("getAllJvmArgs").get();
        LOGGER.info("run: raw jvmArgs = " + (List)arguments);
        int idx = arguments.lastIndexOf("--module");
        if (idx < 0) {
            idx = arguments.lastIndexOf("-m");
        }
        if (idx >= 0 && idx < arguments.size() - 2) {
            ArrayList fixedArgs = new ArrayList(arguments.subList(0, idx));
            fixedArgs.addAll(arguments.subList(idx + 2, arguments.size()));
            fixedArgs.addAll(arguments.subList(idx, idx + 2));
            arguments = fixedArgs;
        }
        LOGGER.info("run: adjusted jvmArgs = " + (List)arguments);
        if (idx < 0) {
            arguments.add(this.getMain());
        }
        arguments.addAll(this.getArgs());
        for (CommandLineArgumentProvider provider : this.getArgumentProviders()) {
            provider.asArguments().forEach(((List)arguments)::add);
        }
        LOGGER.info("run: effectiveArgs = " + (List)arguments);
        Reflect execHandle = Reflect.onClass((String)"org.gradle.process.internal.DefaultExecHandle").create(new Object[]{handleBuilder.call("getDisplayName").get(), handleBuilder.call("getWorkingDir").get(), executable, arguments, handleBuilder.call("getActualEnvironment").get(), handleBuilder.call("getEffectiveStreamsHandler").get(), handleBuilder.field("inputHandler").get(), handleBuilder.field("listeners").get(), handleBuilder.field("redirectErrorStream").get(), handleBuilder.field("timeoutMillis").get(), handleBuilder.field("daemon").get(), handleBuilder.field("executor").get(), handleBuilder.field("buildCancellationToken").get()});
        execHandle.call("start");
        ExecResult execResult = (ExecResult)execHandle.call("waitForFinish").get();
        if (!this.isIgnoreExitValue()) {
            execResult.assertNormalExitValue();
        }
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) >= 0) {
            ((Property)this.getExecutionResult()).set((Object)execResult);
        }
    }

    public static void configure(Project project) {
        project.afterEvaluate(ModularJavaExec::configureAfterEvaluate);
    }

    private static void configureAfterEvaluate(Project project) {
        project.getTasks().withType(ModularJavaExec.class).forEach(execTask -> {
            if (!execTask.getName().equals("run")) {
                ModularJavaExec.configure(execTask, project);
            }
        });
    }

    private static void configure(ModularJavaExec execTask, Project project) {
        if (execTask.getClasspath().isEmpty()) {
            SourceSet mainSourceSet = new JavaProjectHelper(project).mainSourceSet();
            execTask.classpath(new Object[]{mainSourceSet.getRuntimeClasspath()});
        }
        RunTaskMutator mutator = new RunTaskMutator(execTask, project);
        mutator.configureRun();
    }
}

