/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.jeuclid.parser.Parser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@ThreadSafe
public final class MathMLParserSupport {
    private MathMLParserSupport() {
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = Parser.getInstance().getDocumentBuilder();
        return documentBuilder;
    }

    public static Document parseInputStreamXML(InputStream inputStream) throws SAXException, IOException {
        return Parser.getInstance().parseStreamSourceAsXml(new StreamSource(inputStream));
    }

    public static Document parseInputStreamODF(InputStream inputStream) throws SAXException, IOException {
        return Parser.getInstance().parseStreamSourceAsOdf(new StreamSource(inputStream));
    }

    public static Document parseFile(File file) throws SAXException, IOException {
        return Parser.getInstance().parseStreamSource(new StreamSource(new FileInputStream(file)));
    }

    public static Document parseString(String string) throws SAXException, ParserConfigurationException, IOException {
        return Parser.getInstance().parseStreamSourceAsXml(new StreamSource(new StringReader(string)));
    }
}

