/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.parser.Parser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Processor {
    private static final Log LOGGER = LogFactory.getLog(Processor.class);
    private final Transformer transformer;

    protected Processor() {
        Transformer transformer;
        block2: {
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerException transformerException) {
                transformer = null;
                LOGGER.warn((Object)transformerException.getMessage());
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.transformer = transformer;
    }

    public static Processor getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Deprecated
    public static Processor getProcessor() throws TransformerException {
        return Processor.getInstance();
    }

    public void process(Source source, Result result, LayoutContext layoutContext) throws TransformerException {
        LOGGER.info((Object)("Processing " + source.getSystemId() + " to " + result.getSystemId()));
        try {
            Node node = Parser.getInstance().parse(source);
            this.processSubtree(node, layoutContext);
            DOMSource dOMSource = new DOMSource(node);
            this.transformer.transform(dOMSource, result);
        }
        catch (IOException iOException) {
            throw new TransformerException("IOException", iOException);
        }
        catch (SAXException sAXException) {
            throw new TransformerException("SAXException", sAXException);
        }
    }

    public void process(Source source, Result result) throws TransformerException {
        this.process(source, result, LayoutContextImpl.getDefaultLayoutContext());
    }

    private void processSubtree(Node node, LayoutContext layoutContext) {
        if ("http://www.w3.org/1998/Math/MathML".equals(node.getNamespaceURI()) && "math".equals(node.getLocalName())) {
            ConverterPlugin.DocumentWithDimension documentWithDimension = Converter.getInstance().convert(node, "image/svg+xml", layoutContext);
            float f = -(documentWithDimension.getBaseline() / (float)documentWithDimension.getDimension().getHeight()) * 100.0f;
            Node node2 = node.getParentNode();
            if ("http://www.w3.org/1999/XSL/Format".equals(node2.getNamespaceURI()) && "instream-foreign-object".equals(node2.getLocalName())) {
                Element element = (Element)node2;
                element.setAttribute("alignment-adjust", f + "%");
            }
            this.safeReplaceChild(node2, node, documentWithDimension.getDocument().getFirstChild());
        } else {
            this.processChildren(node, layoutContext);
        }
    }

    private void safeReplaceChild(Node node, Node node2, Node node3) {
        try {
            DOMSource dOMSource = new DOMSource(node3);
            DOMResult dOMResult = new DOMResult(node);
            this.transformer.transform(dOMSource, dOMResult);
        }
        catch (TransformerException transformerException) {
            LOGGER.warn((Object)("TranformerException: " + transformerException.getMessage()));
        }
        node.removeChild(node2);
    }

    private void processChildren(Node node, LayoutContext layoutContext) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                this.processSubtree(node2, layoutContext);
            }
        }
    }

    private static final class SingletonHolder {
        private static final Processor INSTANCE = new Processor();

        private SingletonHolder() {
        }
    }
}

