/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.unitfx;

import com.dlsc.unitfx.CustomTextField;
import com.dlsc.unitfx.util.ControlsUtil;
import java.lang.reflect.ParameterizedType;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;

public abstract class NumberInputField<T extends Number>
extends CustomTextField {
    private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value");
    private final BooleanProperty allowNegatives = new SimpleBooleanProperty((Object)this, "allowNegatives", true);
    private final ObjectProperty<Predicate<T>> validator = new SimpleObjectProperty((Object)this, "validator");
    private final ReadOnlyBooleanWrapper invalid = new ReadOnlyBooleanWrapper((Object)this, "invalid");
    private final IntegerProperty numberOfIntegers = new SimpleIntegerProperty((Object)this, "numberOfIntegers", 40);
    private final IntegerProperty numberOfDecimals = new SimpleIntegerProperty((Object)this, "numberOfDecimals", 3);
    private final ObjectProperty<T> minimumValue = new SimpleObjectProperty((Object)this, "minimumValue");
    private final ObjectProperty<T> maximumValue = new SimpleObjectProperty((Object)this, "maximumValue");
    private boolean updatingValue;

    public NumberInputField() {
        NumberStringFilteredConverter converter = new NumberStringFilteredConverter();
        this.setTextFormatter(new TextFormatter((StringConverter)converter, null, converter.getFilter()));
        this.listenForValueChanges();
        this.listenForTextOrValidationChanges();
        this.listenForAllowNegativeChanges();
        this.getStyleClass().add((Object)"number-input-field");
        ControlsUtil.bindBooleanToPseudoclass((Node)this, (ObservableValue<Boolean>)this.invalidProperty(), PseudoClass.getPseudoClass((String)"invalid"));
    }

    protected abstract T convertTextToNumber(String var1);

    protected abstract String convertNumberToText(T var1);

    public final ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final T getValue() {
        return (T)((Number)this.valueProperty().get());
    }

    public final void setValue(T value) {
        this.valueProperty().set(value);
    }

    public final BooleanProperty allowNegativesProperty() {
        return this.allowNegatives;
    }

    public final boolean isAllowNegatives() {
        return this.allowNegativesProperty().get();
    }

    public final void setAllowNegatives(boolean allowNegatives) {
        this.allowNegativesProperty().set(allowNegatives);
    }

    public final ObjectProperty<Predicate<T>> validatorProperty() {
        return this.validator;
    }

    public final Predicate<T> getValidator() {
        return (Predicate)this.validatorProperty().get();
    }

    public final void setValidator(Predicate<T> validator) {
        this.validatorProperty().set(validator);
    }

    public final ReadOnlyBooleanProperty invalidProperty() {
        return this.invalid.getReadOnlyProperty();
    }

    public final boolean isInvalid() {
        return this.invalid.get();
    }

    private final void setInvalid(boolean invalid) {
        this.invalid.set(invalid);
    }

    public final IntegerProperty numberOfIntegersProperty() {
        return this.numberOfIntegers;
    }

    public final int getNumberOfIntegers() {
        return this.numberOfIntegersProperty().get();
    }

    public final void setNumberOfIntegers(int numberOfIntegers) {
        this.numberOfIntegersProperty().set(numberOfIntegers);
    }

    public final IntegerProperty numberOfDecimalsProperty() {
        return this.numberOfDecimals;
    }

    public final int getNumberOfDecimals() {
        return this.numberOfDecimalsProperty().get();
    }

    public final void setNumberOfDecimals(int numberOfDecimals) {
        this.numberOfDecimalsProperty().set(numberOfDecimals);
    }

    public final ObjectProperty<T> minimumValueProperty() {
        return this.minimumValue;
    }

    public final T getMinimumValue() {
        return (T)((Number)this.minimumValueProperty().get());
    }

    public final void setMinimumValue(T minimumValue) {
        this.minimumValueProperty().set(minimumValue);
    }

    public final ObjectProperty<T> maximumValueProperty() {
        return this.maximumValue;
    }

    public final T getMaximumValue() {
        return (T)((Number)this.maximumValueProperty().get());
    }

    public final void setMaximumValue(T maximumValue) {
        this.maximumValueProperty().set(maximumValue);
    }

    private void listenForValueChanges() {
        this.valueProperty().addListener((obs, oldV, newV) -> {
            if (!this.updatingValue) {
                this.setText(this.convertNumberToText(newV));
            }
        });
    }

    private void listenForTextOrValidationChanges() {
        InvalidationListener textListener = obs -> {
            try {
                this.updatingValue = true;
                T number = this.convertTextToNumber(this.getText());
                this.setInvalid(this.isInvalidNumber(number));
                this.setValue(!this.isInvalid() ? number : null);
            }
            finally {
                this.updatingValue = false;
            }
        };
        this.textProperty().addListener(textListener);
        this.minimumValueProperty().addListener(textListener);
        this.maximumValueProperty().addListener(textListener);
        this.validatorProperty().addListener(textListener);
    }

    private void listenForAllowNegativeChanges() {
        this.allowNegativesProperty().addListener((obs, oldV, newV) -> {
            if (!newV.booleanValue() && this.getValue() != null && ((Number)this.getValue()).doubleValue() < 0.0) {
                this.setValue(null);
            }
        });
    }

    private boolean isInvalidNumber(T number) {
        boolean invalid = false;
        if (this.getValidator() != null) {
            boolean bl = invalid = !this.getValidator().test(number);
        }
        if (this.getMinimumValue() != null && number != null) {
            invalid |= ((Number)this.getMinimumValue()).doubleValue() > ((Number)number).doubleValue();
        }
        if (this.getMaximumValue() != null && number != null) {
            invalid |= ((Number)this.getMaximumValue()).doubleValue() < ((Number)number).doubleValue();
        }
        return invalid;
    }

    private boolean isIntegerTypedField() {
        Class typeClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return Integer.class.equals((Object)typeClass) || Long.class.equals((Object)typeClass) || Short.class.equals((Object)typeClass) || Byte.class.equals((Object)typeClass);
    }

    class NumberStringFilteredConverter
    extends NumberStringConverter {
        NumberStringFilteredConverter() {
            super(NumberInputField.this.isIntegerTypedField() ? NumberFormat.getIntegerInstance() : NumberFormat.getNumberInstance());
            NumberFormat nFormat = this.getNumberFormat();
            nFormat.setGroupingUsed(false);
            NumberInputField.this.numberOfIntegersProperty().addListener(obs -> nFormat.setMaximumIntegerDigits(NumberInputField.this.getNumberOfIntegers()));
            NumberInputField.this.numberOfDecimalsProperty().addListener(obs -> nFormat.setMaximumFractionDigits(NumberInputField.this.getNumberOfDecimals()));
        }

        UnaryOperator<TextFormatter.Change> getFilter() {
            return change -> {
                String newText = change.getControlNewText();
                if (newText.isEmpty()) {
                    return change;
                }
                if (NumberInputField.this.isAllowNegatives()) {
                    if (newText.equals("-")) {
                        return change;
                    }
                    if (newText.startsWith("-") && (newText = newText.substring(1)).startsWith("-")) {
                        return null;
                    }
                } else if (newText.startsWith("-")) {
                    return null;
                }
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = this.getNumberFormat().parse(newText, parsePosition);
                if (number == null || parsePosition.getIndex() < newText.length()) {
                    return null;
                }
                return change;
            };
        }
    }
}

