/* Copyright (C) 2010 to 2014 Chris Vine

The library comprised in this file or of which this file is part is
distributed by Chris Vine under the GNU Lesser General Public
License as follows:

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License, version 2.1, for more details.

   You should have received a copy of the GNU Lesser General Public
   License, version 2.1, along with this library (see the file LGPL.TXT
   which came with this source code package in the c++-gtk-utils
   sub-directory); if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

However, it is not intended that the object code of a program whose
source code instantiates a template from this file or uses macros or
inline functions (of any length) should by reason only of that
instantiation or use be subject to the restrictions of use in the GNU
Lesser General Public License.  With that in mind, the words "and
macros, inline functions and instantiations of templates (of any
length)" shall be treated as substituted for the words "and small
macros and small inline functions (ten lines or less in length)" in
the fourth paragraph of section 5 of that licence.  This does not
affect any other reason why object code may be subject to the
restrictions in that licence (nor for the avoidance of doubt does it
affect the application of section 2 of that licence to modifications
of the source code in this file).

*/

#ifndef CGU_CONFIG_H
#define CGU_CONFIG_H

/* 
 * This file is produced from cgu_config.h.in by the ./configure
 * script.
 */

#undef CGU_USE_GLIB_MEMORY_SLICES_COMPAT
#undef CGU_USE_GLIB_MEMORY_SLICES_NO_COMPAT

/* 
 * None of these new operators throw std::bad_alloc as glib terminates
 * the whole application if it cannot allocate memory.
 *
 * These functions are only suitable as class member functions,
 * because they do not check whether the passed size request value is
 * 0, and g_slice_alloc() will not allocate any memory if passed a
 * size of 0.  (A class allocator will not be passed a size value less
 * than 1 as an empty class/struct object has sizeof 1 in C++, so
 * these will always be safe as member functions.)
 *
 * For anyone porting this library to windows, operator new[]() and
 * operator delete[]() for arrays should not be included, because
 * Visual Studio does not correctly comply with the C++ standard with
 * respect to the two argument version of operator delete[]().
 */
#if defined(CGU_USE_GLIB_MEMORY_SLICES_COMPAT) || defined(CGU_USE_GLIB_MEMORY_SLICES_NO_COMPAT)
#include <new>
#include <cstdlib>
#include <glib.h>
#define CGU_GLIB_MEMORY_SLICES_FUNCS \
static void* operator new(std::size_t s) {return g_slice_alloc(s);} \
static void* operator new(std::size_t s, const std::nothrow_t&) {return g_slice_alloc(s);} \
static void* operator new(std::size_t s, void* p) {return ::operator new(s, p);} \
static void operator delete(void* p, std::size_t s) {if (p) g_slice_free1(s, p);} \
static void operator delete(void* p, std::size_t s, const std::nothrow_t&) {if (p) g_slice_free1(s, p);} \
static void operator delete(void* p, void* q) {::operator delete(p, q);} \
static void* operator new[](std::size_t s) {return g_slice_alloc(s);} \
static void* operator new[](std::size_t s, const std::nothrow_t&) {return g_slice_alloc(s);} \
static void* operator new[](std::size_t s, void* p) {return ::operator new[](s, p);} \
static void operator delete[](void* p, std::size_t s) {if (p) g_slice_free1(s, p);} \
static void operator delete[](void* p, std::size_t s, const std::nothrow_t&) {if (p) g_slice_free1(s, p);} \
static void operator delete[](void* p, void* q) {return ::operator delete[](p, q);}
#else
#define CGU_GLIB_MEMORY_SLICES_FUNCS // Using global operator new, new[], delete and delete[]
#endif

/* This determines whether each of the library headers will contain a
   'using namespace Cgu' directive. It will include such a using
   directive if configure is passed the --with-cgu-using-directive
   option.  (It can also be edited by hand.)
*/
namespace Cgu {}
// do not include using directive

/* whether the system provides sched_yield */
#define CGU_USE_SCHED_YIELD 1

/* whether the system was found to provide working recursive mutexes
   when the library was compiled
*/
#define CGU_HAVE_RECURSIVE_MUTEX 1

/* whether to use std::auto_ptr instead of std::unique_ptr in relevant
   public interfaces to maintain source compatibility with earlier
   versions
*/
#undef CGU_USE_AUTO_PTR

/* whether ==, != and < operators to be available for smart pointers */
#define CGU_USE_SMART_PTR_COMPARISON 1

/* whether the std::queue implementation is standard conforming and
   inheritable */
#define CGU_USE_INHERITABLE_QUEUE 1

/* whether the library is to be compiled with GTK+ support */
#define CGU_USE_GTK 1

/* whether the library is to be compiled with support for guile
   extensions */
#define CGU_USE_GUILE 1

/* whether guile correctly links scm_dynwind_block_asyncs() */
#undef CGU_GUILE_HAS_BROKEN_LINKING

/* whether gcc diagnostic pragmas are available */
#define CGU_USE_DIAGNOSTIC_PRAGMAS 1

/* indicates that the series of the library being compiled against
   is series 2.0
*/
#define CGU_API_VERSION 20

#endif // CGU_CONFIG_H
