/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.semantics.LtrBoundsComparator;
import androidx.compose.ui.semantics.RtlBoundsComparator;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsSortKt;
import androidx.compose.ui.semantics.TopBottomBoundsComparator;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aL\u0010\t\u001a\u00020\n2:\u0010\u000b\u001a6\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\r0\fj\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\r`\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a`\u0010\u0012\u001a\u00020\u0013*\u00020\u00022\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00020\fj\b\u0012\u0004\u0012\u00020\u0002`\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u00162\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001a0\u0019H\u0002\u001aL\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a*\u00020\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u00162\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001a0\u001eH\u0000\u001aH\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a*\u00020\u00022\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0000\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"&\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006!"}, d2={"UnmergedConfigComparator", "Lkotlin/Function2;", "Landroidx/compose/ui/semantics/SemanticsNode;", "", "semanticComparators", "", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "[Ljava/util/Comparator;", "placedEntryRowOverlaps", "", "rowGroupings", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Rect;", "", "Lkotlin/collections/ArrayList;", "node", "geometryDepthFirstSearch", "", "geometryList", "isVisible", "Lkotlin/Function1;", "isFocusableContainer", "containerMapToChildren", "Landroidx/collection/MutableIntObjectMap;", "", "sortByGeometryGroupings", "parentListToSort", "containerChildrenMapping", "Landroidx/collection/IntObjectMap;", "subtreeSortedByGeometryGrouping", "listToSort", "ui"})
@SourceDebugExtension(value={"SMAP\nSemanticsSort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsSort.kt\nandroidx/compose/ui/semantics/SemanticsSortKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,270:1\n34#2,6:271\n34#2,6:277\n34#2,6:283\n*S KotlinDebug\n*F\n+ 1 SemanticsSort.kt\nandroidx/compose/ui/semantics/SemanticsSortKt\n*L\n47#1:271,6\n78#1:277,6\n125#1:283,6\n*E\n"})
public final class SemanticsSortKt {
    @NotNull
    private static final Comparator<SemanticsNode>[] semanticComparators;
    @NotNull
    private static final Function2<SemanticsNode, SemanticsNode, Integer> UnmergedConfigComparator;

    @NotNull
    public static final List<SemanticsNode> subtreeSortedByGeometryGrouping(@NotNull SemanticsNode $this$subtreeSortedByGeometryGrouping, @NotNull Function1<? super SemanticsNode, Boolean> isVisible, @NotNull Function1<? super SemanticsNode, Boolean> isFocusableContainer, @NotNull List<SemanticsNode> listToSort) {
        Intrinsics.checkNotNullParameter((Object)$this$subtreeSortedByGeometryGrouping, (String)"<this>");
        Intrinsics.checkNotNullParameter(isVisible, (String)"isVisible");
        Intrinsics.checkNotNullParameter(isFocusableContainer, (String)"isFocusableContainer");
        Intrinsics.checkNotNullParameter(listToSort, (String)"listToSort");
        MutableIntObjectMap<List<SemanticsNode>> containerMapToChildren = IntObjectMapKt.mutableIntObjectMapOf();
        ArrayList<SemanticsNode> geometryList = new ArrayList<SemanticsNode>();
        List<SemanticsNode> $this$fastForEach$iv = listToSort;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            SemanticsNode item$iv;
            SemanticsNode node2 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            SemanticsSortKt.geometryDepthFirstSearch(node2, geometryList, isVisible, isFocusableContainer, containerMapToChildren);
        }
        return SemanticsSortKt.sortByGeometryGroupings($this$subtreeSortedByGeometryGrouping, (List<SemanticsNode>)geometryList, isFocusableContainer, (IntObjectMap<List<SemanticsNode>>)containerMapToChildren);
    }

    private static final void geometryDepthFirstSearch(SemanticsNode $this$geometryDepthFirstSearch, ArrayList<SemanticsNode> geometryList, Function1<? super SemanticsNode, Boolean> isVisible, Function1<? super SemanticsNode, Boolean> isFocusableContainer, MutableIntObjectMap<List<SemanticsNode>> containerMapToChildren) {
        boolean isTraversalGroup2 = $this$geometryDepthFirstSearch.getUnmergedConfig$ui().getOrElse(SemanticsProperties.INSTANCE.getIsTraversalGroup(), geometryDepthFirstSearch.isTraversalGroup.1.INSTANCE);
        if ((isTraversalGroup2 || ((Boolean)isFocusableContainer.invoke((Object)$this$geometryDepthFirstSearch)).booleanValue()) && ((Boolean)isVisible.invoke((Object)$this$geometryDepthFirstSearch)).booleanValue()) {
            geometryList.add($this$geometryDepthFirstSearch);
        }
        if (isTraversalGroup2) {
            containerMapToChildren.set($this$geometryDepthFirstSearch.getId(), SemanticsSortKt.subtreeSortedByGeometryGrouping($this$geometryDepthFirstSearch, isVisible, isFocusableContainer, $this$geometryDepthFirstSearch.getChildren()));
        } else {
            List<SemanticsNode> $this$fastForEach$iv = $this$geometryDepthFirstSearch.getChildren();
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                SemanticsNode item$iv;
                SemanticsNode child = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                SemanticsSortKt.geometryDepthFirstSearch(child, geometryList, isVisible, isFocusableContainer, containerMapToChildren);
            }
        }
    }

    @NotNull
    public static final List<SemanticsNode> sortByGeometryGroupings(@NotNull SemanticsNode $this$sortByGeometryGroupings, @NotNull List<SemanticsNode> parentListToSort, @NotNull Function1<? super SemanticsNode, Boolean> isFocusableContainer, @NotNull IntObjectMap<List<SemanticsNode>> containerChildrenMapping) {
        Intrinsics.checkNotNullParameter((Object)$this$sortByGeometryGroupings, (String)"<this>");
        Intrinsics.checkNotNullParameter(parentListToSort, (String)"parentListToSort");
        Intrinsics.checkNotNullParameter(isFocusableContainer, (String)"isFocusableContainer");
        Intrinsics.checkNotNullParameter(containerChildrenMapping, (String)"containerChildrenMapping");
        boolean layoutIsRtl = $this$sortByGeometryGroupings.getLayoutInfo().getLayoutDirection() == LayoutDirection.Rtl;
        ArrayList<Pair<Rect, List<SemanticsNode>>> rowGroupings = new ArrayList<Pair<Rect, List<SemanticsNode>>>(parentListToSort.size() / 2);
        int entryIndex = 0;
        int n = CollectionsKt.getLastIndex(parentListToSort);
        if (entryIndex <= n) {
            while (true) {
                SemanticsNode currEntry = parentListToSort.get(entryIndex);
                if (entryIndex == 0 || !SemanticsSortKt.placedEntryRowOverlaps(rowGroupings, currEntry)) {
                    Rect newRect = currEntry.getBoundsInWindow();
                    Object[] objectArray = new SemanticsNode[]{currEntry};
                    rowGroupings.add((Pair<Rect, List<SemanticsNode>>)new Pair((Object)newRect, (Object)CollectionsKt.mutableListOf((Object[])objectArray)));
                }
                if (entryIndex == n) break;
                ++entryIndex;
            }
        }
        CollectionsKt.sortWith((List)rowGroupings, (Comparator)TopBottomBoundsComparator.INSTANCE);
        ArrayList returnList = new ArrayList();
        Comparator<SemanticsNode> comparator = semanticComparators[layoutIsRtl ? 0 : 1];
        List $this$fastForEach$iv = rowGroupings;
        boolean $i$f$fastForEach = false;
        int n2 = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n2; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            Pair row = (Pair)item$iv;
            boolean bl = false;
            CollectionsKt.sortWith((List)((List)row.getSecond()), comparator);
            returnList.addAll((Collection)row.getSecond());
        }
        CollectionsKt.sortWith((List)returnList, (arg_0, arg_1) -> SemanticsSortKt.sortByGeometryGroupings$lambda$3(UnmergedConfigComparator, arg_0, arg_1));
        int i = 0;
        while (i <= CollectionsKt.getLastIndex((List)returnList)) {
            int currNodeId = ((SemanticsNode)returnList.get(i)).getId();
            List<SemanticsNode> containersChildrenList = containerChildrenMapping.get(currNodeId);
            if (containersChildrenList != null) {
                Object e = returnList.get(i);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                boolean containerIsScreenReaderFocusable = (Boolean)isFocusableContainer.invoke(e);
                if (!containerIsScreenReaderFocusable) {
                    returnList.remove(i);
                } else {
                    ++i;
                }
                returnList.addAll(i, containersChildrenList);
                i += containersChildrenList.size();
                continue;
            }
            ++i;
        }
        return returnList;
    }

    public static /* synthetic */ List sortByGeometryGroupings$default(SemanticsNode semanticsNode, List list2, Function1 function1, IntObjectMap intObjectMap, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = sortByGeometryGroupings.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            intObjectMap = IntObjectMapKt.intObjectMapOf();
        }
        return SemanticsSortKt.sortByGeometryGroupings(semanticsNode, list2, (Function1<? super SemanticsNode, Boolean>)function1, intObjectMap);
    }

    private static final boolean placedEntryRowOverlaps(ArrayList<Pair<Rect, List<SemanticsNode>>> rowGroupings, SemanticsNode node2) {
        float entryBottomCoord;
        float entryTopCoord = node2.getBoundsInWindow().getTop();
        boolean entryIsEmpty = entryTopCoord >= (entryBottomCoord = node2.getBoundsInWindow().getBottom());
        int currIndex = 0;
        int n = CollectionsKt.getLastIndex((List)rowGroupings);
        if (currIndex <= n) {
            while (true) {
                boolean groupOverlapsEntry;
                Rect currRect;
                boolean groupIsEmpty = (currRect = (Rect)rowGroupings.get(currIndex).getFirst()).getTop() >= currRect.getBottom();
                boolean bl = groupOverlapsEntry = !entryIsEmpty && !groupIsEmpty && Math.max(entryTopCoord, currRect.getTop()) < Math.min(entryBottomCoord, currRect.getBottom());
                if (groupOverlapsEntry) {
                    Rect newRect = currRect.intersect(0.0f, entryTopCoord, Float.POSITIVE_INFINITY, entryBottomCoord);
                    rowGroupings.set(currIndex, (Pair<Rect, List<SemanticsNode>>)new Pair((Object)newRect, rowGroupings.get(currIndex).getSecond()));
                    ((List)rowGroupings.get(currIndex).getSecond()).add(node2);
                    return true;
                }
                if (currIndex == n) break;
                ++currIndex;
            }
        }
        return false;
    }

    private static final int sortByGeometryGroupings$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        Comparator[] comparatorArray = new Comparator[2];
        for (int i = 0; i < 2; ++i) {
            Comparator comparator;
            int n = i;
            Comparator comparator2 = comparator = n == 0 ? (Comparator)RtlBoundsComparator.INSTANCE : (Comparator)LtrBoundsComparator.INSTANCE;
            Comparator<LayoutNode> comparator3 = LayoutNode.Companion.getZComparator$ui();
            comparator2 = new Comparator(comparator2, comparator3){
                final /* synthetic */ Comparator $this_thenBy;
                final /* synthetic */ Comparator $comparator;
                {
                    this.$this_thenBy = $receiver;
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        SemanticsNode semanticsNode = (SemanticsNode)a;
                        Comparator comparator = this.$comparator;
                        boolean bl = false;
                        SemanticsNode it = (SemanticsNode)b;
                        LayoutNode layoutNode2 = it.getLayoutNode$ui();
                        bl = false;
                        LayoutNode layoutNode3 = it.getLayoutNode$ui();
                        n = comparator.compare(layoutNode2, layoutNode3);
                    }
                    return n;
                }
            };
            comparatorArray[n] = new Comparator(comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        SemanticsNode it = (SemanticsNode)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getId());
                        it = (SemanticsNode)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getId()));
                    }
                    return n;
                }
            };
        }
        semanticComparators = comparatorArray;
        UnmergedConfigComparator = UnmergedConfigComparator.1.INSTANCE;
    }
}

