/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.impl.facet;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.python.community.plugin.impl.facet.PythonSdkTableListener;
import com.jetbrains.python.facet.PythonFacetSettings;

public final class PythonFacetUtil {
    public static String getFacetLibraryName(String sdkName2) {
        return sdkName2 + " interpreter library";
    }

    public static void updateLibrary(Module module, PythonFacetSettings facetSettings) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model2 = rootManager.getModifiableModel();
            boolean modelChanged = false;
            try {
                Sdk sdk2 = facetSettings.getSdk();
                String name2 = sdk2 != null ? PythonFacetUtil.getFacetLibraryName(sdk2.getName()) : null;
                boolean librarySeen = false;
                for (OrderEntry entry : model2.getOrderEntries()) {
                    if (!(entry instanceof LibraryOrderEntry)) continue;
                    String libraryName = ((LibraryOrderEntry)entry).getLibraryName();
                    if (name2 != null && name2.equals(libraryName)) {
                        librarySeen = true;
                        continue;
                    }
                    if (libraryName == null || !libraryName.endsWith(" interpreter library")) continue;
                    model2.removeOrderEntry(entry);
                    modelChanged = true;
                }
                if (name2 != null) {
                    ModifiableModelsProvider provider = ModifiableModelsProvider.getInstance();
                    LibraryTable.ModifiableModel libraryTableModifiableModel = provider.getLibraryTableModifiableModel();
                    Library library = libraryTableModifiableModel.getLibraryByName(name2);
                    provider.disposeLibraryTableModifiableModel(libraryTableModifiableModel);
                    if (library == null) {
                        library = PythonSdkTableListener.addLibrary(sdk2);
                    } else {
                        PythonSdkTableListener.updateLibrary(sdk2);
                    }
                    if (!librarySeen) {
                        model2.addLibraryEntry(library);
                        modelChanged = true;
                    }
                }
            }
            finally {
                if (modelChanged) {
                    model2.commit();
                } else {
                    model2.dispose();
                }
            }
        });
    }

    public static void removeLibrary(Module module) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model2 = rootManager.getModifiableModel();
            for (OrderEntry entry : model2.getOrderEntries()) {
                String libraryName;
                Library library;
                if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || (libraryName = library.getName()) == null || !libraryName.endsWith(" interpreter library")) continue;
                model2.removeOrderEntry(entry);
            }
            model2.commit();
        });
    }
}

