/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.userSkeletons;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyUserSkeletonsUtil {
    public static final String USER_SKELETONS_DIR = "python-skeletons";
    private static final Logger LOG = Logger.getInstance(PyUserSkeletonsUtil.class);
    public static final Key<Boolean> HAS_SKELETON = Key.create((String)"PyUserSkeleton.hasSkeleton");
    private static final ImmutableSet<String> STDLIB_SKELETONS = ImmutableSet.of((Object)"asyncio", (Object)"multiprocessing", (Object)"os", (Object)"_csv.py", (Object)"copy.py", (Object)"cStringIO.py", (Object[])new String[]{"decimal.py", "io.py", "itertools.py", "logging.py", "pathlib.py", "pickle.py", "StringIO.py", "struct.py", "sys.py"});
    @Nullable
    private static VirtualFile ourUserSkeletonsDirectory;
    private static boolean ourNoSkeletonsErrorReported;

    @NotNull
    private static List<String> getPossibleUserSkeletonsPaths() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(PathManager.getConfigPath() + File.separator + USER_SKELETONS_DIR);
        result2.add(PythonHelpersLocator.findPathStringInHelpers(USER_SKELETONS_DIR));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile getUserSkeletonsDirectory() {
        if (ourUserSkeletonsDirectory == null) {
            for (String path2 : PyUserSkeletonsUtil.getPossibleUserSkeletonsPaths()) {
                ourUserSkeletonsDirectory = StandardFileSystems.local().findFileByPath(path2);
                if (ourUserSkeletonsDirectory == null) continue;
                break;
            }
        }
        if (!ourNoSkeletonsErrorReported && ourUserSkeletonsDirectory == null) {
            ourNoSkeletonsErrorReported = true;
            LOG.warn("python-skeletons directory not found in paths: " + String.valueOf(PyUserSkeletonsUtil.getPossibleUserSkeletonsPaths()));
        }
        return ourUserSkeletonsDirectory;
    }

    public static boolean isUnderUserSkeletonsDirectory(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return false;
        }
        return PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(virtualFile);
    }

    public static boolean isUnderUserSkeletonsDirectory(@NotNull VirtualFile virtualFile) {
        VirtualFile skeletonsDir;
        if (virtualFile == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(2);
        }
        return (skeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)virtualFile, (boolean)false);
    }

    @NotNull
    public static GlobalSearchScope getUserSkeletonsDirectoryScope(@NotNull Project project) {
        VirtualFile userSkeletonsDirectory;
        if (project == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(3);
        }
        if ((userSkeletonsDirectory = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
            return new GlobalSearchScopesCore.DirectoryScope(project, userSkeletonsDirectory, true);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    public static boolean isStandardLibrarySkeleton(@NotNull VirtualFile virtualFile) {
        VirtualFile skeletonsDir;
        if (virtualFile == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(5);
        }
        if ((skeletonsDir = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) == null) {
            return false;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)skeletonsDir, (char)'/');
        if (relativePath == null) {
            return false;
        }
        String firstComponent = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)relativePath, (String)"/"));
        return STDLIB_SKELETONS.contains((Object)firstComponent);
    }

    @Nullable
    public static <T extends PyElement> T getUserSkeleton(@NotNull T element) {
        if (element == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(6);
        }
        return PyUserSkeletonsUtil.getUserSkeletonWithContext(element, null);
    }

    @Nullable
    public static <T extends PyElement> T getUserSkeletonWithContext(@NotNull T element, @Nullable TypeEvalContext context) {
        PyFile skeletonFile;
        PsiFile file;
        if (element == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(7);
        }
        if ((file = element.getContainingFile()) instanceof PyFile && (skeletonFile = PyUserSkeletonsUtil.getUserSkeletonForFile((PyFile)file)) != null && skeletonFile != file) {
            PsiElement skeletonElement = PyUserSkeletonsUtil.getUserSkeleton(element, skeletonFile, context);
            if (element.getClass().isInstance(skeletonElement) && skeletonElement != element) {
                return (T)((PyElement)skeletonElement);
            }
        }
        return null;
    }

    @Nullable
    public static PyFile getUserSkeletonForModuleQName(@NotNull String qName, @NotNull PsiElement foothold) {
        Sdk sdk2;
        if (qName == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(8);
        }
        if (foothold == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(9);
        }
        if ((sdk2 = PythonSdkUtil.findPythonSdk(foothold)) != null) {
            VirtualFile directory;
            QualifiedName cacheQName;
            Project project = foothold.getProject();
            PythonSdkPathCache cache = PythonSdkPathCache.getInstance(project, sdk2);
            List<PsiElement> results = cache.get(cacheQName = QualifiedName.fromDottedString((String)("python-skeletons." + qName)));
            if (results != null) {
                PsiElement element;
                PsiElement psiElement = element = results.isEmpty() ? null : results.get(0);
                if (element instanceof PyFile) {
                    return (PyFile)element;
                }
            }
            if ((directory = PyUserSkeletonsUtil.getUserSkeletonsDirectory()) != null) {
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)project).findDirectory(directory);
                PsiElement fileSkeleton = PyResolveImportUtil.resolveModuleAt(QualifiedName.fromDottedString((String)qName), (PsiFileSystemItem)psiDirectory, PyResolveImportUtil.fromFoothold(foothold)).stream().findFirst().orElse(null);
                if (fileSkeleton instanceof PsiDirectory) {
                    fileSkeleton = PyUtil.getPackageElement((PsiDirectory)fileSkeleton, foothold);
                }
                if (fileSkeleton instanceof PyFile) {
                    cache.put(cacheQName, Collections.singletonList(fileSkeleton));
                    return (PyFile)fileSkeleton;
                }
            }
            cache.put(cacheQName, Collections.emptyList());
        }
        return null;
    }

    @Nullable
    private static PsiElement getUserSkeleton(@NotNull PyElement element, @NotNull PyFile skeletonFile, @Nullable TypeEvalContext context) {
        if (element == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(10);
        }
        if (skeletonFile == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(11);
        }
        if (element instanceof PyFile) {
            return skeletonFile;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
        String name2 = element.getName();
        if (owner != null && name2 != null) {
            assert (owner != element);
            PsiElement originalOwner = PyUserSkeletonsUtil.getUserSkeleton(owner, skeletonFile, context);
            if (originalOwner instanceof PyClass) {
                PyResolveContext resolveContext;
                PyClassLikeType classType;
                PyClassLikeType instanceType;
                List<? extends RatedResolveResult> resolveResults;
                PyClass classOwner = (PyClass)originalOwner;
                TypeEvalContext fallbackContext = TypeEvalContext.codeInsightFallback(classOwner.getProject());
                PyType type2 = fallbackContext.getType(classOwner);
                if (type2 instanceof PyClassLikeType && (resolveResults = (instanceType = (PyClassLikeType)(classType = (PyClassLikeType)type2).toInstance()).resolveMember(name2, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext((TypeEvalContext)ObjectUtils.notNull((Object)context, (Object)fallbackContext)), false)) != null && !resolveResults.isEmpty()) {
                    return resolveResults.get(0).getElement();
                }
            } else if (originalOwner instanceof PyFile) {
                return ((PyFile)originalOwner).getElementNamed(name2);
            }
        }
        return null;
    }

    @Nullable
    private static PyFile getUserSkeletonForFile(@NotNull PyFile file) {
        String moduleName;
        Boolean hasSkeleton;
        if (file == null) {
            PyUserSkeletonsUtil.$$$reportNull$$$0(12);
        }
        if ((hasSkeleton = (Boolean)file.getUserData(HAS_SKELETON)) != null && !hasSkeleton.booleanValue()) {
            return null;
        }
        VirtualFile moduleVirtualFile = file.getVirtualFile();
        if (moduleVirtualFile != null && (moduleName = QualifiedNameFinder.findShortestImportableName((PsiElement)file, moduleVirtualFile)) != null) {
            PyFile skeletonFile;
            QualifiedName qName = QualifiedName.fromDottedString((String)moduleName);
            QualifiedName restored = QualifiedNameFinder.canonizeQualifiedName((PsiElement)file, qName, null);
            if (restored != null) {
                moduleName = restored.toString();
            }
            file.putUserData(HAS_SKELETON, (skeletonFile = PyUserSkeletonsUtil.getUserSkeletonForModuleQName(moduleName, (PsiElement)file)) != null);
            return skeletonFile;
        }
        return null;
    }

    static {
        ourNoSkeletonsErrorReported = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleUserSkeletonsPaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/userSkeletons/PyUserSkeletonsUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSkeletonsDirectoryScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderUserSkeletonsDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeletonsDirectoryScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStandardLibrarySkeleton";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeleton";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeletonWithContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeletonForModuleQName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUserSkeletonForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

