/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.intellij.images.ImagesBundle;
import org.intellij.images.scientific.utils.BinarizationThresholdConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\f"}, d2={"Lorg/intellij/images/scientific/action/ConfigureActions;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "openConfigurationDialog", "project", "Lcom/intellij/openapi/project/Project;", "ThresholdDialogWrapper", "intellij.platform.images"})
public final class ConfigureActions
extends AnAction {
    public ConfigureActions() {
        super(ImagesBundle.message("image.color.mode.configure.actions", new Object[0]), null, AllIcons.General.Settings);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.openConfigurationDialog(e.getProject());
    }

    private final void openConfigurationDialog(Project project) {
        Integer newThreshold;
        BinarizationThresholdConfig thresholdConfig = BinarizationThresholdConfig.Companion.getInstance();
        int currentThreshold = thresholdConfig.getThreshold();
        ThresholdDialogWrapper dialog = new ThresholdDialogWrapper(project, currentThreshold);
        if (dialog.showAndGet() && (newThreshold = dialog.getThresholdValue()) != null) {
            thresholdConfig.setThreshold(newThreshold);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/intellij/images/scientific/action/ConfigureActions$ThresholdDialogWrapper;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "initialValue", "", "<init>", "(Lcom/intellij/openapi/project/Project;I)V", "sliderValue", "thresholdValue", "getThresholdValue", "()Ljava/lang/Integer;", "setThresholdValue", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "doOKAction", "", "getInitialSize", "Ljava/awt/Dimension;", "intellij.platform.images"})
    private static final class ThresholdDialogWrapper
    extends DialogWrapper {
        private int sliderValue;
        @Nullable
        private Integer thresholdValue;

        public ThresholdDialogWrapper(@Nullable Project project, int initialValue) {
            super(project);
            this.sliderValue = RangesKt.coerceIn((int)initialValue, (int)0, (int)255);
            this.setTitle(ImagesBundle.message("image.binarize.dialog.title", new Object[0]));
            this.init();
        }

        @Nullable
        public final Integer getThresholdValue() {
            return this.thresholdValue;
        }

        public final void setThresholdValue(@Nullable Integer n) {
            this.thresholdValue = n;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JSlider jSlider;
            JSlider $this$createCenterPanel_u24lambda_u241 = jSlider = new JSlider(0, 255, this.sliderValue);
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u241.setMajorTickSpacing(50);
            $this$createCenterPanel_u24lambda_u241.setMinorTickSpacing(5);
            $this$createCenterPanel_u24lambda_u241.setPaintTicks(true);
            $this$createCenterPanel_u24lambda_u241.setPaintLabels(true);
            $this$createCenterPanel_u24lambda_u241.setValue(this.sliderValue);
            $this$createCenterPanel_u24lambda_u241.addChangeListener(arg_0 -> ThresholdDialogWrapper.createCenterPanel$lambda$1$lambda$0(this, $this$createCenterPanel_u24lambda_u241, arg_0));
            JSlider slider = jSlider;
            JComponent jComponent = new JLabel(String.valueOf(this.sliderValue));
            JLabel $this$createCenterPanel_u24lambda_u243 = jComponent;
            boolean bl2 = false;
            slider.addChangeListener(arg_0 -> ThresholdDialogWrapper.createCenterPanel$lambda$3$lambda$2($this$createCenterPanel_u24lambda_u243, slider, arg_0));
            JLabel valueLabel = jComponent;
            JComponent $this$createCenterPanel_u24lambda_u244 = jComponent = new JPanel(new BorderLayout());
            boolean bl3 = false;
            $this$createCenterPanel_u24lambda_u244.add((Component)slider, "Center");
            $this$createCenterPanel_u24lambda_u244.add((Component)valueLabel, "South");
            $this$createCenterPanel_u24lambda_u244.setPreferredSize(new Dimension(300, 120));
            return jComponent;
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            return this.createCenterPanel();
        }

        protected void doOKAction() {
            this.thresholdValue = this.sliderValue;
            super.doOKAction();
        }

        @NotNull
        public Dimension getInitialSize() {
            return new Dimension(300, 120);
        }

        private static final void createCenterPanel$lambda$1$lambda$0(ThresholdDialogWrapper this$0, JSlider $this_apply, ChangeEvent it) {
            this$0.sliderValue = $this_apply.getValue();
        }

        private static final void createCenterPanel$lambda$3$lambda$2(JLabel $this_apply, JSlider $slider, ChangeEvent it) {
            $this_apply.setText(String.valueOf($slider.getValue()));
        }
    }
}

