/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.script;

import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J+\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/script/UnvalidatedParameters;", "", "scriptName", "", "parameters", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "fail", "", "message", "remaining", "", "require", "T", "name", "clazz", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "optional", "done", "", "intellij.qodana"})
public final class UnvalidatedParameters {
    @NotNull
    private final String scriptName;
    @NotNull
    private final Map<String, Object> remaining;

    public UnvalidatedParameters(@NotNull String scriptName, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.scriptName = scriptName;
        this.remaining = MapsKt.toMutableMap(parameters);
    }

    private final Void fail(String message) {
        throw new QodanaException("Script '" + this.scriptName + "' " + message);
    }

    @NotNull
    public final <T> T require(@NotNull String name, @NotNull KClass<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object value2 = this.remaining.remove(name);
        if (value2 == null) {
            this.fail("requires parameter '" + name + "'");
            throw new KotlinNothingValueException();
        }
        if (!clazz.isInstance(value2)) {
            this.fail("expects " + JvmClassMappingKt.getJavaClass(clazz).getCanonicalName() + " but found " + value2.getClass().getCanonicalName());
            throw new KotlinNothingValueException();
        }
        return (T)KClasses.cast(clazz, (Object)value2);
    }

    @Nullable
    public final <T> T optional(@NotNull String name, @NotNull KClass<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object value2 = this.remaining.remove(name);
        if (value2 == null) {
            object = null;
        } else {
            if (!clazz.isInstance(value2)) {
                this.fail("expects " + JvmClassMappingKt.getJavaClass(clazz).getCanonicalName() + " but found " + value2.getClass().getCanonicalName());
                throw new KotlinNothingValueException();
            }
            object = KClasses.cast(clazz, (Object)value2);
        }
        return (T)object;
    }

    public final void done() {
        if (this.remaining.isEmpty()) {
            return;
        }
        String parameters = this.remaining.size() == 1 ? "parameter" : "parameters";
        String unknown = CollectionsKt.joinToString$default((Iterable)this.remaining.keySet(), null, null, null, (int)0, null, null, (int)63, null);
        throw new QodanaException("Script '" + this.scriptName + "' cannot handle " + parameters + " '" + unknown + "'");
    }
}

