/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.cache;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0002%&B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003JE\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey;", "", "offset", "", "hashBeforeOffset", "postfixHash", "postfixHashRelaxed", "lineSuffix", "", "filePath", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;", "<init>", "(IIIILjava/lang/String;Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;)V", "getOffset", "()I", "getHashBeforeOffset", "getPostfixHash", "getPostfixHashRelaxed", "getLineSuffix", "()Ljava/lang/String;", "getFilePath", "()Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;", "matches", "", "otherKey", "otherValue", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "FileId", "Companion", "intellij.fullLine.core.completion"})
public final class LightweightCacheKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    private final int hashBeforeOffset;
    private final int postfixHash;
    private final int postfixHashRelaxed;
    @NotNull
    private final String lineSuffix;
    @NotNull
    private final FileId filePath;

    public LightweightCacheKey(int offset, int hashBeforeOffset, int postfixHash, int postfixHashRelaxed, @NotNull String lineSuffix, @NotNull FileId filePath) {
        Intrinsics.checkNotNullParameter((Object)lineSuffix, (String)"lineSuffix");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.offset = offset;
        this.hashBeforeOffset = hashBeforeOffset;
        this.postfixHash = postfixHash;
        this.postfixHashRelaxed = postfixHashRelaxed;
        this.lineSuffix = lineSuffix;
        this.filePath = filePath;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getHashBeforeOffset() {
        return this.hashBeforeOffset;
    }

    public final int getPostfixHash() {
        return this.postfixHash;
    }

    public final int getPostfixHashRelaxed() {
        return this.postfixHashRelaxed;
    }

    @NotNull
    public final String getLineSuffix() {
        return this.lineSuffix;
    }

    @NotNull
    public final FileId getFilePath() {
        return this.filePath;
    }

    public final boolean matches(@NotNull LightweightCacheKey otherKey, @NotNull String otherValue) {
        Intrinsics.checkNotNullParameter((Object)otherKey, (String)"otherKey");
        Intrinsics.checkNotNullParameter((Object)otherValue, (String)"otherValue");
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)otherKey.filePath)) {
            return false;
        }
        if (this.postfixHashRelaxed != otherKey.postfixHashRelaxed) {
            return false;
        }
        int delta = this.offset - otherKey.offset;
        if (!(0 <= delta ? delta < otherValue.length() : false)) {
            return false;
        }
        if (!StringsKt.endsWith$default((String)this.lineSuffix, (String)otherKey.lineSuffix, (boolean)false, (int)2, null)) {
            return false;
        }
        int concatHash = Strings.stringHashCode((CharSequence)otherValue, (int)0, (int)delta, (int)otherKey.hashBeforeOffset);
        return concatHash == this.hashBeforeOffset;
    }

    public final int component1() {
        return this.offset;
    }

    public final int component2() {
        return this.hashBeforeOffset;
    }

    public final int component3() {
        return this.postfixHash;
    }

    public final int component4() {
        return this.postfixHashRelaxed;
    }

    @NotNull
    public final String component5() {
        return this.lineSuffix;
    }

    @NotNull
    public final FileId component6() {
        return this.filePath;
    }

    @NotNull
    public final LightweightCacheKey copy(int offset, int hashBeforeOffset, int postfixHash, int postfixHashRelaxed, @NotNull String lineSuffix, @NotNull FileId filePath) {
        Intrinsics.checkNotNullParameter((Object)lineSuffix, (String)"lineSuffix");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new LightweightCacheKey(offset, hashBeforeOffset, postfixHash, postfixHashRelaxed, lineSuffix, filePath);
    }

    public static /* synthetic */ LightweightCacheKey copy$default(LightweightCacheKey lightweightCacheKey, int n, int n2, int n3, int n4, String string, FileId fileId, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = lightweightCacheKey.offset;
        }
        if ((n5 & 2) != 0) {
            n2 = lightweightCacheKey.hashBeforeOffset;
        }
        if ((n5 & 4) != 0) {
            n3 = lightweightCacheKey.postfixHash;
        }
        if ((n5 & 8) != 0) {
            n4 = lightweightCacheKey.postfixHashRelaxed;
        }
        if ((n5 & 0x10) != 0) {
            string = lightweightCacheKey.lineSuffix;
        }
        if ((n5 & 0x20) != 0) {
            fileId = lightweightCacheKey.filePath;
        }
        return lightweightCacheKey.copy(n, n2, n3, n4, string, fileId);
    }

    @NotNull
    public String toString() {
        return "LightweightCacheKey(offset=" + this.offset + ", hashBeforeOffset=" + this.hashBeforeOffset + ", postfixHash=" + this.postfixHash + ", postfixHashRelaxed=" + this.postfixHashRelaxed + ", lineSuffix=" + this.lineSuffix + ", filePath=" + this.filePath + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.offset);
        result2 = result2 * 31 + Integer.hashCode(this.hashBeforeOffset);
        result2 = result2 * 31 + Integer.hashCode(this.postfixHash);
        result2 = result2 * 31 + Integer.hashCode(this.postfixHashRelaxed);
        result2 = result2 * 31 + this.lineSuffix.hashCode();
        result2 = result2 * 31 + this.filePath.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LightweightCacheKey)) {
            return false;
        }
        LightweightCacheKey lightweightCacheKey = (LightweightCacheKey)other;
        if (this.offset != lightweightCacheKey.offset) {
            return false;
        }
        if (this.hashBeforeOffset != lightweightCacheKey.hashBeforeOffset) {
            return false;
        }
        if (this.postfixHash != lightweightCacheKey.postfixHash) {
            return false;
        }
        if (this.postfixHashRelaxed != lightweightCacheKey.postfixHashRelaxed) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lineSuffix, (Object)lightweightCacheKey.lineSuffix)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filePath, (Object)lightweightCacheKey.filePath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$Companion;", "", "<init>", "()V", "build", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "of", "intellij.fullLine.core.completion"})
    @SourceDebugExtension(value={"SMAP\nLightweightCacheKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightweightCacheKey.kt\ncom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,87:1\n434#2:88\n507#2,5:89\n*S KotlinDebug\n*F\n+ 1 LightweightCacheKey.kt\ncom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$Companion\n*L\n73#1:88\n73#1:89,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final LightweightCacheKey build(Editor editor2, int offset) {
            void $this$filterTo$iv$iv;
            String postfix;
            ThreadingAssertions.assertReadAccess();
            ProgressManager.checkCanceled();
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            TextRange textRange = DocumentUtil.getLineTextRange((Document)document2, (int)document2.getLineNumber(offset));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getLineTextRange(...)");
            TextRange lineRange = textRange;
            TextRange suffixRange = lineRange.intersection(new TextRange(offset, document2.getTextLength()));
            String string = document2.getText(new TextRange(lineRange.getEndOffset(), document2.getTextLength()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String $this$filter$iv = postfix = string;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it) && !StringsKt.contains$default((CharSequence)"(){}[]<>", (char)it, (boolean)false, (int)2, null))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String filteredPostfix = ((StringBuilder)destination$iv$iv).toString();
            int n2 = Strings.stringHashCode((CharSequence)document2.getCharsSequence(), (int)0, (int)offset);
            int n3 = Strings.stringHashCode((CharSequence)postfix);
            int n4 = Strings.stringHashCode((CharSequence)filteredPostfix);
            String string2 = document2.getText(suffixRange);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return new LightweightCacheKey(offset, n2, n3, n4, string2, FileId.Companion.of(editor2));
        }

        @RequiresReadLock
        @NotNull
        public final LightweightCacheKey of(@NotNull Editor editor2, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.build(editor2, offset);
        }

        public static /* synthetic */ LightweightCacheKey of$default(Companion companion, Editor editor2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = editor2.getCaretModel().getOffset();
            }
            return companion.of(editor2, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00052\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0003\u0006\u0007\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;", "", "FilePath", "NoFileEditor", "Unknown", "Companion", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$FilePath;", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$NoFileEditor;", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$Unknown;", "intellij.fullLine.core.completion"})
    public static interface FileId {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.fullLine.core.completion"})
        @SourceDebugExtension(value={"SMAP\nLightweightCacheKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightweightCacheKey.kt\ncom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final FileId of(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Object object = editor2.getVirtualFile();
                if (object != null && (object = object.getPath()) != null) {
                    Object it = object;
                    boolean bl = false;
                    return new FilePath((String)it);
                }
                EditorId editorId = EditorIdKt.editorIdOrNull((Editor)editor2);
                if (editorId != null) {
                    EditorId it = editorId;
                    boolean bl = false;
                    return new NoFileEditor(it);
                }
                return new Unknown();
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$FilePath;", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;", "path", "", "<init>", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.fullLine.core.completion"})
        public static final class FilePath
        implements FileId {
            @NotNull
            private final String path;

            public FilePath(@NotNull String path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                this.path = path2;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final FilePath copy(@NotNull String path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                return new FilePath(path2);
            }

            public static /* synthetic */ FilePath copy$default(FilePath filePath, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = filePath.path;
                }
                return filePath.copy(string);
            }

            @NotNull
            public String toString() {
                return "FilePath(path=" + this.path + ")";
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FilePath)) {
                    return false;
                }
                FilePath filePath = (FilePath)other;
                return Intrinsics.areEqual((Object)this.path, (Object)filePath.path);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$NoFileEditor;", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;", "id", "Lcom/intellij/openapi/editor/impl/EditorId;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorId;)V", "getId", "()Lcom/intellij/openapi/editor/impl/EditorId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine.core.completion"})
        public static final class NoFileEditor
        implements FileId {
            @NotNull
            private final EditorId id;

            public NoFileEditor(@NotNull EditorId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                this.id = id;
            }

            @NotNull
            public final EditorId getId() {
                return this.id;
            }

            @NotNull
            public final EditorId component1() {
                return this.id;
            }

            @NotNull
            public final NoFileEditor copy(@NotNull EditorId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return new NoFileEditor(id);
            }

            public static /* synthetic */ NoFileEditor copy$default(NoFileEditor noFileEditor, EditorId editorId, int n, Object object) {
                if ((n & 1) != 0) {
                    editorId = noFileEditor.id;
                }
                return noFileEditor.copy(editorId);
            }

            @NotNull
            public String toString() {
                return "NoFileEditor(id=" + this.id + ")";
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoFileEditor)) {
                    return false;
                }
                NoFileEditor noFileEditor = (NoFileEditor)other;
                return Intrinsics.areEqual((Object)this.id, (Object)noFileEditor.id);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId$Unknown;", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey$FileId;", "<init>", "()V", "intellij.fullLine.core.completion"})
        public static final class Unknown
        implements FileId {
        }
    }
}

