/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.client.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterKernelId;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSessionId;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.model.JupyterFileInfo;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.model.JupyterFsFileFormat;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.model.JupyterFsFileType;
import com.intellij.jupyter.core.jupyter.connections.session.JupyterSessionData;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/client/rest/JupyterRestModelParser;", "", "<init>", "()V", "parseFsMode", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/model/JupyterFileInfo;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "parseKernelSpec", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "Lcom/fasterxml/jackson/databind/JsonNode;", "parseJupyterSessionData", "Lcom/intellij/jupyter/core/jupyter/connections/session/JupyterSessionData;", "nodes", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRestModelParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRestModelParser.kt\ncom/intellij/jupyter/core/jupyter/connections/client/rest/JupyterRestModelParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1#2:73\n295#3,2:74\n295#3,2:76\n1557#3:78\n1628#3,3:79\n1557#3:82\n1628#3,3:83\n*S KotlinDebug\n*F\n+ 1 JupyterRestModelParser.kt\ncom/intellij/jupyter/core/jupyter/connections/client/rest/JupyterRestModelParser\n*L\n21#1:74,2\n24#1:76,2\n30#1:78\n30#1:79,3\n36#1:82\n36#1:83,3\n*E\n"})
public final class JupyterRestModelParser {
    @NotNull
    public static final JupyterRestModelParser INSTANCE = new JupyterRestModelParser();

    private JupyterRestModelParser() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JupyterFileInfo parseFsMode(@NotNull ObjectNode json) {
        Object object;
        Object object2;
        Object object3;
        Long size;
        Object v9;
        String path;
        String name;
        JupyterFsFileFormat format;
        Long lastModified;
        Long created;
        block28: {
            JupyterFsFileFormat jupyterFsFileFormat;
            Object object4;
            Long l;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string = json.get("created").asText();
            if (string != null) {
                String it = string;
                boolean bl = false;
                l = ZonedDateTime.parse(it).toInstant().toEpochMilli();
            } else {
                l = null;
            }
            created = l;
            String string2 = json.get("last_modified").asText();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                v3 = ZonedDateTime.parse(it).toInstant().toEpochMilli();
            } else {
                v3 = lastModified = null;
            }
            if ((object4 = json.get("format")) != null && (object4 = object4.asText()) != null) {
                Object object5;
                block27: {
                    Object format2 = object4;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = (Iterable)JupyterFsFileFormat.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        JupyterFsFileFormat it = (JupyterFsFileFormat)((Object)element$iv);
                        boolean bl2 = false;
                        String string3 = it.name().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        if (!Intrinsics.areEqual((Object)string3, (Object)format2)) continue;
                        object5 = element$iv;
                        break block27;
                    }
                    object5 = null;
                }
                jupyterFsFileFormat = (JupyterFsFileFormat)((Object)object5);
            } else {
                jupyterFsFileFormat = null;
            }
            format = jupyterFsFileFormat;
            name = json.get("name").asText();
            path = json.get("path").asText();
            String type = json.get("type").asText();
            boolean bl = false;
            Iterable $this$firstOrNull$iv = (Iterable)JupyterFsFileType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JupyterFsFileType it = (JupyterFsFileType)((Object)element$iv);
                boolean bl3 = false;
                String string4 = it.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string4, (Object)type)) continue;
                v9 = element$iv;
                break block28;
            }
            v9 = null;
        }
        JupyterFsFileType type = v9;
        JsonNode jsonNode = json.get("size");
        if (jsonNode != null) {
            Long l = jsonNode.asLong();
            long it = ((Number)l).longValue();
            boolean bl = false;
            v11 = type != JupyterFsFileType.DIRECTORY ? l : null;
        } else {
            v11 = size = null;
        }
        if ((object3 = json.get("mimetype")) != null && (object3 = object3.asText()) != null) {
            Object object6;
            Object it = object6 = object3;
            boolean bl = false;
            object2 = !Intrinsics.areEqual((Object)it, (Object)"null") ? object6 : null;
        } else {
            object2 = null;
        }
        Object mimetype = object2;
        JsonNode jsonNode2 = json.get("writable");
        boolean writable = !(jsonNode2 != null ? !jsonNode2.asBoolean() : false);
        JsonNode jsonNode3 = json.get("content");
        if (jsonNode3 != null) {
            JsonNode contentNode = jsonNode3;
            boolean bl = false;
            if (type == JupyterFsFileType.DIRECTORY) {
                ArrayNode arrayNode = contentNode instanceof ArrayNode ? (ArrayNode)contentNode : null;
                if (arrayNode != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)arrayNode;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JsonNode jsonNode4 = (JsonNode)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                        collection.add(INSTANCE.parseFsMode((ObjectNode)it));
                    }
                    object = (List)destination$iv$iv;
                } else {
                    object = null;
                }
            } else {
                JupyterFsFileFormat jupyterFsFileFormat = format;
                switch (jupyterFsFileFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jupyterFsFileFormat.ordinal()]) {
                    case 1: {
                        String string = contentNode.asText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
                        byte[] byArray = string.getBytes(Charsets.UTF_8);
                        object = byArray;
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        break;
                    }
                    case 2: {
                        object = contentNode;
                        break;
                    }
                    case 3: {
                        object = Base64.getMimeDecoder().decode(contentNode.asText());
                        break;
                    }
                    case -1: {
                        ArrayNode arrayNode = contentNode instanceof ArrayNode ? (ArrayNode)contentNode : null;
                        if (arrayNode != null) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = (Iterable)arrayNode;
                            boolean $i$f$map = false;
                            Iterable $i$f$mapTo = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                JsonNode jsonNode5 = (JsonNode)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl5 = false;
                                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                                collection.add(INSTANCE.parseFsMode((ObjectNode)it));
                            }
                            object = (List)destination$iv$iv;
                            break;
                        }
                        object = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        } else {
            object = null;
        }
        JsonNode content = object;
        Intrinsics.checkNotNull((Object)name);
        Intrinsics.checkNotNull((Object)path);
        return new JupyterFileInfo(content, name, path, lastModified, created, (String)mimetype, size, type, format, writable);
    }

    @Nullable
    public final JupyterKernelSpec parseKernelSpec(@Nullable JsonNode json) {
        if (json == null) {
            return null;
        }
        Object object = json.get("name");
        if (object == null || (object = object.asText()) == null) {
            return null;
        }
        Object name = object;
        JsonNode jsonNode = json.get("spec");
        if (jsonNode == null) {
            return null;
        }
        JsonNode spec = jsonNode;
        Object object2 = spec.get("display_name");
        if (object2 == null || (object2 = object2.asText()) == null) {
            return null;
        }
        Object displayName = object2;
        Object object3 = spec.get("language");
        if (object3 == null || (object3 = object3.asText()) == null) {
            return null;
        }
        Object language = object3;
        JsonNode jsonNode2 = spec.get("argv");
        List argv = jsonNode2 != null && (jsonNode2 = CollectionsKt.asSequence((Iterable)((Iterable)jsonNode2))) != null && (jsonNode2 = SequencesKt.filter((Sequence)jsonNode2, JupyterRestModelParser::parseKernelSpec$lambda$11)) != null && (jsonNode2 = SequencesKt.map((Sequence)jsonNode2, JupyterRestModelParser::parseKernelSpec$lambda$12)) != null ? SequencesKt.toList((Sequence)jsonNode2) : null;
        JsonNode jsonNode3 = spec.get("metadata");
        ObjectNode metadata = jsonNode3 instanceof ObjectNode ? (ObjectNode)jsonNode3 : null;
        return new JupyterKernelBase((String)displayName, (String)language, (String)name, argv, metadata);
    }

    @Nullable
    public final JupyterSessionData parseJupyterSessionData(@NotNull ObjectNode nodes2) {
        Object object;
        String kernelId;
        Object sessionId;
        block11: {
            block10: {
                JsonNode jsonNode;
                Object object2;
                block9: {
                    block8: {
                        JsonNode jsonNode2;
                        Object object3;
                        block7: {
                            block6: {
                                JsonNode jsonNode3;
                                Intrinsics.checkNotNullParameter((Object)nodes2, (String)"nodes");
                                object3 = nodes2.get("id");
                                if (object3 == null) break block6;
                                JsonNode it = jsonNode3 = object3;
                                boolean bl = false;
                                object3 = it.isTextual() ? jsonNode3 : null;
                                if (object3 != null && (object3 = object3.asText()) != null) break block7;
                            }
                            return null;
                        }
                        sessionId = object3;
                        object2 = nodes2.get("kernel");
                        if (object2 == null) break block8;
                        JsonNode it = jsonNode2 = object2;
                        boolean bl = false;
                        object2 = it.isObject() ? jsonNode2 : null;
                        if (object2 == null || (object2 = object2.get("id")) == null) break block8;
                        JsonNode it2 = bl = object2;
                        boolean bl2 = false;
                        object2 = it2.isTextual() ? bl : null;
                        if (object2 != null && (object2 = object2.asText()) != null) break block9;
                    }
                    return null;
                }
                Object p0 = object2;
                boolean bl = false;
                kernelId = JupyterKernelId.constructor-impl((String)p0);
                object = nodes2.get("path");
                if (object == null) break block10;
                JsonNode it = jsonNode = object;
                boolean bl3 = false;
                object = it.isTextual() ? jsonNode : null;
                if (object != null && (object = object.asText()) != null) break block11;
            }
            return null;
        }
        Object path = object;
        return new JupyterSessionData(JupyterNotebookSessionId.constructor-impl((String)sessionId), kernelId, (String)path, null);
    }

    private static final boolean parseKernelSpec$lambda$11(JsonNode arg) {
        return arg.isValueNode();
    }

    private static final String parseKernelSpec$lambda$12(JsonNode arg) {
        return arg.asText();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterFsFileFormat.values().length];
            try {
                nArray[JupyterFsFileFormat.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterFsFileFormat.JSON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterFsFileFormat.BASE64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

