/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellOutputUtils;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterKernelClientListener;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageId;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J'\u0010\u001f\u001a\u00020\u001d2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0004\b \u0010!J\u0006\u0010\"\u001a\u00020\u0010J\b\u0010#\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "codeMessages", "", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageId;", "nonCodeMessages", "", "asyncOutputs", "Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker$AsyncOutputState;", "codeMessageExecuted", "", "messageId", "codeMessageExecuted-3OLEHg0", "(Ljava/lang/String;)V", "nonCodeMessageExecuted", "nonCodeMessageExecuted-3OLEHg0", "asyncOutputArrived", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "requestAsyncOutput", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "shouldRequestNewAsyncComponent", "", "asyncOutputLoaded", "handleExecutionFinished", "handleExecutionFinished-_Pqzv0M", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)Z", "clearMessages", "dispose", "AsyncOutputState", "AsyncOutputStatus", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMessageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageTracker.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1#2:144\n1863#3,2:145\n*S KotlinDebug\n*F\n+ 1 MessageTracker.kt\ncom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker\n*L\n106#1:145,2\n*E\n"})
public final class MessageTracker
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<JupyterMessageId> codeMessages;
    @NotNull
    private final List<JupyterMessageId> nonCodeMessages;
    @NotNull
    private final List<AsyncOutputState> asyncOutputs;

    public MessageTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.codeMessages = new LinkedHashSet();
        this.nonCodeMessages = new ArrayList();
        this.asyncOutputs = new ArrayList();
        this.project.getMessageBus().connect((Disposable)this).subscribe(JupyterKernelClientListener.Companion.getTOPIC(), (Object)new JupyterKernelClientListener(){

            @Override
            public void onWebSocketClosed-LMWXRmQ(String sessionId) {
                Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
                this.clearMessages();
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final synchronized void codeMessageExecuted-3OLEHg0(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        this.nonCodeMessages.remove(JupyterMessageId.box-impl(messageId));
        this.codeMessages.add(JupyterMessageId.box-impl(messageId));
    }

    public final synchronized void nonCodeMessageExecuted-3OLEHg0(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        this.codeMessages.remove(JupyterMessageId.box-impl(messageId));
        this.nonCodeMessages.add(JupyterMessageId.box-impl(messageId));
    }

    public final synchronized void asyncOutputArrived(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        CollectionsKt.removeAll(this.asyncOutputs, arg_0 -> MessageTracker.asyncOutputArrived$lambda$0(cellPointer, arg_0));
        this.asyncOutputs.add(new AsyncOutputState(cellPointer, null, 0, 6, null));
    }

    private final void requestAsyncOutput(Project project, BackedNotebookVirtualFile notebookVirtualFile2) {
        ListIterator<AsyncOutputState> iterator = this.asyncOutputs.listIterator();
        while (iterator.hasNext()) {
            AsyncOutputState state = iterator.next();
            if (state.getStatus() != AsyncOutputStatus.DEFAULT_PREVIEW) continue;
            List<Editor> editors = JupyterCellOutputUtils.INSTANCE.getAllEditorsByJupyterVirtualFile$intellij_jupyter_core(project, notebookVirtualFile2);
            iterator.set(new AsyncOutputState(state.getCell(), AsyncOutputStatus.WAITING_FOR_ASYNC_RESULT, state.getWaitingForResult() + editors.size()));
            JupyterListenersKt.outputUpdated(notebookVirtualFile2.getNotebook(), state.getCell());
        }
    }

    public final synchronized boolean shouldRequestNewAsyncComponent(@NotNull NotebookIntervalPointer cellPointer) {
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            Iterable iterable = this.asyncOutputs;
            for (Object t : iterable) {
                AsyncOutputState it = (AsyncOutputState)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCell(), (Object)cellPointer)) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        AsyncOutputState asyncOutputState = v0;
        if (asyncOutputState == null) {
            return false;
        }
        AsyncOutputState cellStatus = asyncOutputState;
        return switch (WhenMappings.$EnumSwitchMapping$0[cellStatus.getStatus().ordinal()]) {
            case 1 -> false;
            case 2, 3 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final synchronized void asyncOutputLoaded(@NotNull NotebookIntervalPointer cellPointer) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            Iterable iterable = this.asyncOutputs;
            for (Object t : iterable) {
                AsyncOutputState it = (AsyncOutputState)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCell(), (Object)cellPointer)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        AsyncOutputState asyncOutputState = v0;
        if (asyncOutputState == null) {
            return;
        }
        AsyncOutputState cellStatus = asyncOutputState;
        if (cellStatus.getStatus() == AsyncOutputStatus.WAITING_FOR_ASYNC_RESULT) {
            CollectionsKt.removeAll(this.asyncOutputs, arg_0 -> MessageTracker.asyncOutputLoaded$lambda$3(cellPointer, arg_0));
            boolean bl = cellStatus.getWaitingForResult() == 1 ? this.asyncOutputs.add(new AsyncOutputState(cellStatus.getCell(), AsyncOutputStatus.ASYNC_LOADED, 0)) : this.asyncOutputs.add(new AsyncOutputState(cellStatus.getCell(), cellStatus.getStatus(), cellStatus.getWaitingForResult() - 1));
        }
    }

    public final synchronized boolean handleExecutionFinished-_Pqzv0M(@Nullable String messageId, @NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile2) {
        JupyterMessageId jupyterMessageId;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
        Collection collection = this.nonCodeMessages;
        String string = messageId;
        JupyterMessageId jupyterMessageId2 = jupyterMessageId = string != null ? JupyterMessageId.box-impl(string) : null;
        if (TypeIntrinsics.asMutableCollection((Object)collection).remove(jupyterMessageId)) {
            return false;
        }
        collection = this.codeMessages;
        String string2 = messageId;
        JupyterMessageId jupyterMessageId3 = jupyterMessageId = string2 != null ? JupyterMessageId.box-impl(string2) : null;
        if (TypeIntrinsics.asMutableCollection((Object)collection).remove(jupyterMessageId) && !((Collection)this.codeMessages).isEmpty()) {
            return false;
        }
        Iterable $this$forEach$iv = this.asyncOutputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncOutputState state = (AsyncOutputState)element$iv;
            boolean bl = false;
            if (state.getStatus() != AsyncOutputStatus.DEFAULT_PREVIEW) continue;
            this.requestAsyncOutput(project, notebookVirtualFile2);
        }
        return true;
    }

    public final synchronized void clearMessages() {
        this.codeMessages.clear();
        this.nonCodeMessages.clear();
    }

    public synchronized void dispose() {
        this.codeMessages.clear();
        this.nonCodeMessages.clear();
        this.asyncOutputs.clear();
    }

    private static final boolean asyncOutputArrived$lambda$0(NotebookIntervalPointer $cellPointer, AsyncOutputState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getCell(), (Object)$cellPointer);
    }

    private static final boolean asyncOutputLoaded$lambda$3(NotebookIntervalPointer $cellPointer, AsyncOutputState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getCell(), (Object)$cellPointer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker$AsyncOutputState;", "", "cell", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "status", "Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker$AsyncOutputStatus;", "waitingForResult", "", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker$AsyncOutputStatus;I)V", "getCell", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getStatus", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker$AsyncOutputStatus;", "getWaitingForResult", "()I", "setWaitingForResult", "(I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.jupyter.core"})
    private static final class AsyncOutputState {
        @NotNull
        private final NotebookIntervalPointer cell;
        @NotNull
        private final AsyncOutputStatus status;
        private int waitingForResult;

        public AsyncOutputState(@NotNull NotebookIntervalPointer cell, @NotNull AsyncOutputStatus status, int waitingForResult) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.cell = cell;
            this.status = status;
            this.waitingForResult = waitingForResult;
        }

        public /* synthetic */ AsyncOutputState(NotebookIntervalPointer notebookIntervalPointer, AsyncOutputStatus asyncOutputStatus, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                asyncOutputStatus = AsyncOutputStatus.DEFAULT_PREVIEW;
            }
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(notebookIntervalPointer, asyncOutputStatus, n);
        }

        @NotNull
        public final NotebookIntervalPointer getCell() {
            return this.cell;
        }

        @NotNull
        public final AsyncOutputStatus getStatus() {
            return this.status;
        }

        public final int getWaitingForResult() {
            return this.waitingForResult;
        }

        public final void setWaitingForResult(int n) {
            this.waitingForResult = n;
        }

        @NotNull
        public final NotebookIntervalPointer component1() {
            return this.cell;
        }

        @NotNull
        public final AsyncOutputStatus component2() {
            return this.status;
        }

        public final int component3() {
            return this.waitingForResult;
        }

        @NotNull
        public final AsyncOutputState copy(@NotNull NotebookIntervalPointer cell, @NotNull AsyncOutputStatus status, int waitingForResult) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new AsyncOutputState(cell, status, waitingForResult);
        }

        public static /* synthetic */ AsyncOutputState copy$default(AsyncOutputState asyncOutputState, NotebookIntervalPointer notebookIntervalPointer, AsyncOutputStatus asyncOutputStatus, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                notebookIntervalPointer = asyncOutputState.cell;
            }
            if ((n2 & 2) != 0) {
                asyncOutputStatus = asyncOutputState.status;
            }
            if ((n2 & 4) != 0) {
                n = asyncOutputState.waitingForResult;
            }
            return asyncOutputState.copy(notebookIntervalPointer, asyncOutputStatus, n);
        }

        @NotNull
        public String toString() {
            return "AsyncOutputState(cell=" + this.cell + ", status=" + this.status + ", waitingForResult=" + this.waitingForResult + ")";
        }

        public int hashCode() {
            int result = this.cell.hashCode();
            result = result * 31 + this.status.hashCode();
            result = result * 31 + Integer.hashCode(this.waitingForResult);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AsyncOutputState)) {
                return false;
            }
            AsyncOutputState asyncOutputState = (AsyncOutputState)other;
            if (!Intrinsics.areEqual((Object)this.cell, (Object)asyncOutputState.cell)) {
                return false;
            }
            if (this.status != asyncOutputState.status) {
                return false;
            }
            return this.waitingForResult == asyncOutputState.waitingForResult;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/MessageTracker$AsyncOutputStatus;", "", "<init>", "(Ljava/lang/String;I)V", "DEFAULT_PREVIEW", "WAITING_FOR_ASYNC_RESULT", "ASYNC_LOADED", "intellij.jupyter.core"})
    private static final class AsyncOutputStatus
    extends Enum<AsyncOutputStatus> {
        public static final /* enum */ AsyncOutputStatus DEFAULT_PREVIEW = new AsyncOutputStatus();
        public static final /* enum */ AsyncOutputStatus WAITING_FOR_ASYNC_RESULT = new AsyncOutputStatus();
        public static final /* enum */ AsyncOutputStatus ASYNC_LOADED = new AsyncOutputStatus();
        private static final /* synthetic */ AsyncOutputStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AsyncOutputStatus[] values() {
            return (AsyncOutputStatus[])$VALUES.clone();
        }

        public static AsyncOutputStatus valueOf(String value) {
            return Enum.valueOf(AsyncOutputStatus.class, value);
        }

        @NotNull
        public static EnumEntries<AsyncOutputStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = asyncOutputStatusArray = new AsyncOutputStatus[]{AsyncOutputStatus.DEFAULT_PREVIEW, AsyncOutputStatus.WAITING_FOR_ASYNC_RESULT, AsyncOutputStatus.ASYNC_LOADED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AsyncOutputStatus.values().length];
            try {
                nArray[AsyncOutputStatus.DEFAULT_PREVIEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AsyncOutputStatus.WAITING_FOR_ASYNC_RESULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AsyncOutputStatus.ASYNC_LOADED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

