/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.jupyter.editor.actions.CaretOffsetAndSelection;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.SmartList;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a+\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u0004\u0018\u00010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u001a&\u0010\u0019\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a@\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u001b\u0012\u0004\u0012\u00020\u00040\u001d0\u001b\"\u0004\b\u0000\u0010\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u00040\u001d0\u001bH\u0000\u001a\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002\u001a\u0018\u0010$\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002\u001a.\u0010%\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020!\u001a&\u0010+\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004\u001a\u0018\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u000202H\u0002\u001a \u00103\u001a\u00020\u00112\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006H\u0002\u001a\u0016\u00106\u001a\u0004\u0018\u00010\u0013*\u00020(2\u0006\u0010,\u001a\u00020\u0013H\u0002\u001a\u0016\u00107\u001a\u0004\u0018\u00010\u0013*\u00020(2\u0006\u0010,\u001a\u00020\u0013H\u0002\u001a\u0018\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u0013H\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006;"}, d2={"getLinesRangeWithoutLf", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/Document;", "lines", "Lkotlin/ranges/IntRange;", "getLineEndOffsetWithLF", "", "lineNumber", "getNotFoldedLines", "editor", "Lcom/intellij/openapi/editor/Editor;", "pos", "caret", "Lcom/intellij/openapi/editor/Caret;", "start", "end", "moveTo", "", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "runWithStickingCaretsToIntervals", "T", "handler", "Lkotlin/Function0;", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "removeLines", "carets", "", "mergeInterleaved", "Lkotlin/Pair;", "Data", "lst", "canMerge", "", "prev", "next", "mergeIntervals", "tryMoveLinesToAnotherCell", "sourceLines", "notebookLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "currentCell", "moveLineUp", "swapNeighbourLinesInOneCell", "cell", "firstLines", "secondLines", "isRelated", "rangeWithoutLF", "c", "Lcom/intellij/jupyter/core/jupyter/editor/actions/CaretOffsetAndSelection;", "shiftCaret", "shift", "maxOffset", "nextCellOfSameTypeAndLanguage", "previousCellOfSameTypeAndLanguage", "hasSameTypeAndLanguage", "first", "second", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCellModificationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCellModificationUtil.kt\ncom/intellij/jupyter/core/jupyter/editor/actions/JupyterCellModificationUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1557#2:260\n1628#2,3:261\n1863#2,2:264\n774#2:267\n865#2,2:268\n1557#2:270\n1628#2,3:271\n1557#2:274\n1628#2,3:275\n295#2,2:278\n543#2,6:280\n1#3:266\n*S KotlinDebug\n*F\n+ 1 JupyterCellModificationUtil.kt\ncom/intellij/jupyter/core/jupyter/editor/actions/JupyterCellModificationUtilKt\n*L\n54#1:260\n54#1:261,3\n85#1:264,2\n145#1:267\n145#1:268,2\n148#1:270\n148#1:271,3\n210#1:274\n210#1:275,3\n252#1:278,2\n255#1:280,6\n*E\n"})
public final class JupyterCellModificationUtilKt {
    @NotNull
    public static final TextRange getLinesRangeWithoutLf(@NotNull Document $this$getLinesRangeWithoutLf, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)$this$getLinesRangeWithoutLf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return new TextRange($this$getLinesRangeWithoutLf.getLineStartOffset(lines.getFirst()), $this$getLinesRangeWithoutLf.getLineEndOffset(lines.getLast()));
    }

    public static final int getLineEndOffsetWithLF(@NotNull Document $this$getLineEndOffsetWithLF, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineEndOffsetWithLF, (String)"<this>");
        return lineNumber + 1 < $this$getLineEndOffsetWithLF.getLineCount() ? $this$getLineEndOffsetWithLF.getLineStartOffset(lineNumber + 1) : $this$getLineEndOffsetWithLF.getTextLength();
    }

    @NotNull
    public static final IntRange getNotFoldedLines(@NotNull Editor editor, int pos) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return JupyterCellModificationUtilKt.getNotFoldedLines(editor, pos, pos);
    }

    @NotNull
    public static final IntRange getNotFoldedLines(@NotNull Editor editor, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return caret.hasSelection() ? JupyterCellModificationUtilKt.getNotFoldedLines(editor, caret.getSelectionStart(), caret.getSelectionEnd() - 1) : JupyterCellModificationUtilKt.getNotFoldedLines(editor, caret.getOffset(), caret.getOffset());
    }

    @NotNull
    public static final IntRange getNotFoldedLines(@NotNull Editor editor, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int startOffset = EditorUtil.getNotFoldedLineStartOffset((Editor)editor, (int)start2, (boolean)true);
        int endOffset = EditorUtil.getNotFoldedLineEndOffset((Editor)editor, (int)end, (boolean)true);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        return new IntRange(document2.getLineNumber(startOffset), document2.getLineNumber(endOffset));
    }

    public static final void moveTo(@NotNull Caret $this$moveTo, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        int n = $this$moveTo.getLogicalPosition().line;
        IntRange intRange = interval.getLines();
        int n2 = intRange.getFirst();
        if (!(n <= intRange.getLast() ? n2 <= n : false)) {
            boolean bl = 0 <= n ? n < interval.getLines().getFirst() : false;
            if (bl) {
                $this$moveTo.moveToOffset($this$moveTo.getEditor().getDocument().getLineStartOffset(interval.getFirstContentLine()));
            } else {
                $this$moveTo.moveToOffset($this$moveTo.getEditor().getDocument().getLineEndOffset(interval.getLastContentLine()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final <T> T runWithStickingCaretsToIntervals(@Nullable Editor $this$runWithStickingCaretsToIntervals, @NotNull Function0<? extends T> handler2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        boolean $i$f$runWithStickingCaretsToIntervals = false;
        if (!($this$runWithStickingCaretsToIntervals instanceof EditorImpl)) {
            return (T)handler2.invoke();
        }
        Object object = ((EditorImpl)$this$runWithStickingCaretsToIntervals).getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getAllCarets(...)");
        object = (Iterable)object;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Caret caret = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)NotebookIntervalPointerFactory.Companion.get($this$runWithStickingCaretsToIntervals).create(NotebookVisualizationUiUtilKt.getCell((Editor)$this$runWithStickingCaretsToIntervals, (int)it.getLogicalPosition().line))));
        }
        List oldCaretsAndIntervalPointers = (List)destination$iv$iv;
        try {
            object = handler2.invoke();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            ((EditorImpl)$this$runWithStickingCaretsToIntervals).getCaretModel().runBatchCaretOperation(new Runnable(oldCaretsAndIntervalPointers){
                final /* synthetic */ List<Pair<Caret, NotebookIntervalPointer>> $oldCaretsAndIntervalPointers;
                {
                    this.$oldCaretsAndIntervalPointers = $oldCaretsAndIntervalPointers;
                }

                public final void run() {
                    for (Pair<Caret, NotebookIntervalPointer> pair : this.$oldCaretsAndIntervalPointers) {
                        Caret caret = (Caret)pair.component1();
                        NotebookIntervalPointer intervalPointer = (NotebookIntervalPointer)pair.component2();
                        NotebookCellLines.Interval expectedCell = intervalPointer.get();
                        if (!caret.isValid() || expectedCell == null) continue;
                        JupyterCellModificationUtilKt.moveTo(caret, expectedCell);
                    }
                }
            });
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        ((EditorImpl)$this$runWithStickingCaretsToIntervals).getCaretModel().runBatchCaretOperation(new /* invalid duplicate definition of identical inner class */);
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }

    public static final void removeLines(@NotNull Editor editor, @NotNull List<? extends Caret> carets, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(carets, (String)"carets");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        List cells = NotebookVisualizationUiUtilKt.getCells((Editor)editor, (IntRange)lines);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        for (NotebookCellLines.Interval cell : CollectionsKt.asReversed((List)cells)) {
            int upperBound = cell.getType() == NotebookCellLines.CellType.RAW ? cell.getLines().getFirst() : cell.getLines().getFirst() + 1;
            int firstLine = Math.max(upperBound, lines.getFirst());
            int lastLine = Math.min(cell.getLines().getLast(), lines.getLast());
            if (upperBound > lastLine) continue;
            Iterable $this$forEach$iv = carets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Caret caret = (Caret)element$iv;
                boolean bl = false;
                if (!cell.getLines().contains(document2.getLineNumber(caret.getOffset())) || lastLine == cell.getLines().getLast()) continue;
                int visualLine = editor.offsetToVisualPosition((int)document2.getLineStartOffset((int)(lastLine + 1))).line;
                caret.moveToVisualPosition(new VisualPosition(visualLine, caret.getVisualPosition().column));
            }
            if (lastLine < cell.getLines().getLast() || cell.getType() == NotebookCellLines.CellType.RAW) {
                document2.deleteString(document2.getLineStartOffset(firstLine), JupyterCellModificationUtilKt.getLineEndOffsetWithLF(document2, lastLine));
                continue;
            }
            if (firstLine > upperBound) {
                document2.deleteString(document2.getLineStartOffset(firstLine) - 1, document2.getLineEndOffset(lastLine));
                continue;
            }
            document2.deleteString(document2.getLineStartOffset(firstLine), document2.getLineEndOffset(lastLine));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <Data> List<Pair<List<Data>, IntRange>> mergeInterleaved(@NotNull List<? extends Pair<? extends Data, IntRange>> lst) {
        Intrinsics.checkNotNullParameter(lst, (String)"lst");
        SmartList result = new SmartList();
        for (Pair<Data, IntRange> pair : lst) {
            boolean bl;
            Object data = pair.component1();
            IntRange lines = (IntRange)pair.component2();
            Pair previous = (Pair)CollectionsKt.removeLastOrNull((List)((List)result));
            if (previous == null) {
                bl = result.add((Object)new Pair((Object)new SmartList(data), (Object)lines));
                continue;
            }
            if (JupyterCellModificationUtilKt.canMerge((IntRange)previous.getSecond(), lines)) {
                void it;
                Object object = previous.getFirst();
                SmartList smartList = (SmartList)object;
                SmartList smartList2 = result;
                boolean bl2 = false;
                it.add(data);
                IntRange intRange = JupyterCellModificationUtilKt.mergeIntervals((IntRange)previous.getSecond(), lines);
                Object object2 = object;
                bl = smartList2.add((Object)new Pair(object2, (Object)intRange));
                continue;
            }
            result.add((Object)previous);
            bl = result.add((Object)new Pair((Object)new SmartList(data), (Object)lines));
        }
        return (List)result;
    }

    private static final boolean canMerge(IntRange prev, IntRange next) {
        return prev.getLast() + 1 >= next.getFirst();
    }

    private static final IntRange mergeIntervals(IntRange prev, IntRange next) {
        return new IntRange(prev.getFirst(), next.getLast());
    }

    /*
     * Unable to fully structure code
     */
    public static final void tryMoveLinesToAnotherCell(@NotNull Editor editor, @NotNull IntRange sourceLines, @NotNull NotebookCellLines notebookLines, @NotNull NotebookCellLines.Interval currentCell, boolean moveLineUp) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sourceLines, (String)"sourceLines");
        Intrinsics.checkNotNullParameter((Object)notebookLines, (String)"notebookLines");
        Intrinsics.checkNotNullParameter((Object)currentCell, (String)"currentCell");
        v0 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDocument(...)");
        document = v0;
        lineRange = JupyterCellModificationUtilKt.getLinesRangeWithoutLf(document, sourceLines);
        v1 = document.getText(lineRange);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getText(...)");
        lineText = v1;
        v2 = editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getAllCarets(...)");
        $this$filter$iv = v2;
        $i$f$filter = false;
        var11_11 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Caret)element$iv$iv;
            $i$a$-filter-JupyterCellModificationUtilKt$tryMoveLinesToAnotherCell$affectedCarets$1 = false;
            var18_22 = sourceLines.getFirst();
            var19_23 = sourceLines.getLast();
            var20_24 = it.getLogicalPosition().line;
            if (var18_22 <= var20_24 ? var20_24 <= var19_23 : false) ** GOTO lbl-1000
            if (it.getLogicalPosition().column == 0) {
                var18_22 = sourceLines.getFirst();
                var19_23 = sourceLines.getLast();
                var20_24 = it.getLogicalPosition().line - 1;
                v3 = var18_22 <= var20_24 ? var20_24 <= var19_23 : false;
                ** if (!v3) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v4 = true;
                ** GOTO lbl36
            }
lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
lbl36:
            // 2 sources

            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        affectedCarets = (List)destination$iv$iv;
        $this$map$iv = affectedCarets;
        $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-JupyterCellModificationUtilKt$tryMoveLinesToAnotherCell$affectedCarets$1 = (Caret)item$iv$iv;
            var21_26 = destination$iv$iv;
            $i$a$-map-JupyterCellModificationUtilKt$tryMoveLinesToAnotherCell$caretsWithOffsets$1 = false;
            var21_26.add(new CaretOffsetAndSelection((Caret)it, lineRange.getStartOffset()));
        }
        caretsWithOffsets = (List)destination$iv$iv;
        if (moveLineUp) {
            v5 = JupyterCellModificationUtilKt.previousCellOfSameTypeAndLanguage(notebookLines, currentCell);
            if (v5 == null) {
                return;
            }
            prevCell = v5;
            insertOffset = document.getLineEndOffset(prevCell.getLines().getLast());
            safeDeleteRange = currentCell.getLines().getLast() == sourceLines.getLast() || document.getTextLength() == lineRange.getEndOffset() ? lineRange : new TextRange(lineRange.getStartOffset(), lineRange.getEndOffset() + 1);
            editor.getCaretModel().runBatchCaretOperation((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, tryMoveLinesToAnotherCell$lambda$5(java.util.List int com.intellij.openapi.editor.Document com.intellij.openapi.util.TextRange java.lang.String ), ()V)((List)caretsWithOffsets, (int)insertOffset, (Document)document, (TextRange)safeDeleteRange, (String)lineText));
        } else {
            v6 = JupyterCellModificationUtilKt.nextCellOfSameTypeAndLanguage(notebookLines, currentCell);
            if (v6 == null) {
                return;
            }
            nextCell = v6;
            insertOffset = document.getLineStartOffset(nextCell.getLines().getFirst() + 1);
            safeDeleteRange = currentCell.getLines().getFirst() + 1 == sourceLines.getFirst() ? lineRange : new TextRange(lineRange.getStartOffset() - 1, lineRange.getEndOffset());
            editor.getCaretModel().runBatchCaretOperation((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, tryMoveLinesToAnotherCell$lambda$6(java.util.List com.intellij.openapi.util.TextRange com.intellij.openapi.editor.Document int java.lang.String com.intellij.openapi.util.TextRange ), ()V)((List)caretsWithOffsets, (TextRange)lineRange, (Document)document, (int)insertOffset, (String)lineText, (TextRange)safeDeleteRange));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void swapNeighbourLinesInOneCell(@NotNull Editor editor, @NotNull NotebookCellLines.Interval cell, @NotNull IntRange firstLines, @NotNull IntRange secondLines) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)firstLines, (String)"firstLines");
        Intrinsics.checkNotNullParameter((Object)secondLines, (String)"secondLines");
        if (secondLines.getFirst() < firstLines.getFirst()) {
            JupyterCellModificationUtilKt.swapNeighbourLinesInOneCell(editor, cell, secondLines, firstLines);
            return;
        }
        if (!(firstLines.getLast() + 1 == secondLines.getFirst())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        TextRange firstLineRange = JupyterCellModificationUtilKt.getLinesRangeWithoutLf(document2, firstLines);
        TextRange secondLineRange = JupyterCellModificationUtilKt.getLinesRangeWithoutLf(document2, secondLines);
        List list = editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Caret caret = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new CaretOffsetAndSelection((Caret)it, 0));
        }
        List carets = (List)destination$iv$iv;
        String string = document2.getText(firstLineRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String firstLineText = string;
        String string2 = document2.getText(secondLineRange);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String secondLineText = string2;
        document2.replaceString(firstLineRange.getStartOffset(), secondLineRange.getEndOffset(), (CharSequence)(secondLineText + "\n" + firstLineText));
        editor.getCaretModel().runBatchCaretOperation(() -> JupyterCellModificationUtilKt.swapNeighbourLinesInOneCell$lambda$8(carets, firstLineRange, secondLines, cell, secondLineText, secondLineRange, firstLineText));
    }

    private static final boolean isRelated(TextRange rangeWithoutLF, CaretOffsetAndSelection c) {
        int caretOffset = c.getCaret().getOffset();
        if (rangeWithoutLF.containsOffset(caretOffset)) {
            return true;
        }
        int selectionStart = caretOffset + c.getLocalSelectionStart();
        int selectionEnd = caretOffset + c.getLocalSelectionEnd();
        return rangeWithoutLF.containsOffset(selectionStart) && rangeWithoutLF.getEndOffset() + 1 == selectionEnd;
    }

    private static final void shiftCaret(CaretOffsetAndSelection c, int shift, int maxOffset) {
        int newCaretOffset = c.getCaret().getOffset() + shift;
        int newSelectionStart = newCaretOffset + c.getLocalSelectionStart();
        int newSelectionEnd = newCaretOffset + c.getLocalSelectionEnd();
        c.getCaret().moveToOffset(Math.min(newCaretOffset, maxOffset));
        c.getCaret().setSelection(newSelectionStart, Math.min(newSelectionEnd, maxOffset));
    }

    private static final NotebookCellLines.Interval nextCellOfSameTypeAndLanguage(NotebookCellLines $this$nextCellOfSameTypeAndLanguage, NotebookCellLines.Interval cell) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$nextCellOfSameTypeAndLanguage.getIntervals().subList(Math.min(cell.getOrdinal() + 1, $this$nextCellOfSameTypeAndLanguage.getIntervals().size()), $this$nextCellOfSameTypeAndLanguage.getIntervals().size());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                boolean bl = false;
                if (!JupyterCellModificationUtilKt.hasSameTypeAndLanguage(cell, it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final NotebookCellLines.Interval previousCellOfSameTypeAndLanguage(NotebookCellLines $this$previousCellOfSameTypeAndLanguage, NotebookCellLines.Interval cell) {
        Object v0;
        block1: {
            List $this$lastOrNull$iv = $this$previousCellOfSameTypeAndLanguage.getIntervals().subList(0, cell.getOrdinal());
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                boolean bl = false;
                if (!JupyterCellModificationUtilKt.hasSameTypeAndLanguage(cell, it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean hasSameTypeAndLanguage(NotebookCellLines.Interval first, NotebookCellLines.Interval second) {
        return first.getType() == second.getType() && Intrinsics.areEqual((Object)first.getLanguage(), (Object)second.getLanguage());
    }

    private static final void tryMoveLinesToAnotherCell$lambda$5(List $caretsWithOffsets, int $insertOffset, Document $document, TextRange $safeDeleteRange, String $lineText) {
        for (CaretOffsetAndSelection c : $caretsWithOffsets) {
            c.getCaret().moveToOffset($insertOffset);
        }
        $document.deleteString($safeDeleteRange.getStartOffset(), $safeDeleteRange.getEndOffset());
        $document.insertString($insertOffset, (CharSequence)("\n" + $lineText));
        for (CaretOffsetAndSelection c : $caretsWithOffsets) {
            int newCaretOffset = $insertOffset + 1 + c.getRelativeOffset();
            int maxCaretOffset = $insertOffset + 1 + $lineText.length();
            c.getCaret().moveToOffset(Math.min(maxCaretOffset, newCaretOffset));
            c.getCaret().setSelection(c.getLocalSelectionStart() + newCaretOffset, Math.min(maxCaretOffset, c.getLocalSelectionEnd() + newCaretOffset));
        }
    }

    private static final void tryMoveLinesToAnotherCell$lambda$6(List $caretsWithOffsets, TextRange $lineRange, Document $document, int $insertOffset, String $lineText, TextRange $safeDeleteRange) {
        for (CaretOffsetAndSelection c : $caretsWithOffsets) {
            c.getCaret().moveToOffset($lineRange.getStartOffset());
        }
        $document.insertString($insertOffset, (CharSequence)($lineText + "\n"));
        $document.deleteString($safeDeleteRange.getStartOffset(), $safeDeleteRange.getEndOffset());
        for (CaretOffsetAndSelection c : $caretsWithOffsets) {
            c.getCaret().moveToOffset($insertOffset - $safeDeleteRange.getLength() + c.getRelativeOffset());
            c.getCaret().setSelection(c.getLocalSelectionStart() + c.getCaret().getOffset(), c.getLocalSelectionEnd() + c.getCaret().getOffset());
        }
    }

    private static final void swapNeighbourLinesInOneCell$lambda$8(List $carets, TextRange $firstLineRange, IntRange $secondLines, NotebookCellLines.Interval $cell, String $secondLineText, TextRange $secondLineRange, String $firstLineText) {
        for (CaretOffsetAndSelection c : $carets) {
            if (JupyterCellModificationUtilKt.isRelated($firstLineRange, c)) {
                int dMax = $secondLines.getLast() < $cell.getLines().getLast() ? 1 : 0;
                JupyterCellModificationUtilKt.shiftCaret(c, $secondLineText.length() + 1, $secondLineRange.getEndOffset() + dMax);
                continue;
            }
            if (!JupyterCellModificationUtilKt.isRelated($secondLineRange, c)) continue;
            JupyterCellModificationUtilKt.shiftCaret(c, -$firstLineText.length() - 1, $firstLineRange.getStartOffset() + $secondLineText.length() + 1);
        }
    }
}

