/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.jupyter.core.jupyter.editor.actions.JupyterCellModificationUtilKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/JupyterMoveLineActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "defaultHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "moveLineUp", "", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Z)V", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "executeInJupyter", "intellij.jupyter.core"})
class JupyterMoveLineActionHandler
extends EditorWriteActionHandler {
    @NotNull
    private final EditorActionHandler defaultHandler;
    private final boolean moveLineUp;

    public JupyterMoveLineActionHandler(@NotNull EditorActionHandler defaultHandler, boolean moveLineUp) {
        Intrinsics.checkNotNullParameter((Object)defaultHandler, (String)"defaultHandler");
        super(false);
        this.defaultHandler = defaultHandler;
        this.moveLineUp = moveLineUp;
    }

    public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (JupyterEditorExtensionsKt.isJupyter(editor)) {
            this.executeInJupyter(editor);
        } else {
            this.defaultHandler.execute(editor, caret, dataContext);
        }
    }

    private final void executeInJupyter(Editor editor) {
        int dest;
        Document document = editor.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
        DocumentEx document2 = (DocumentEx)document;
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        IntRange sourceLines = JupyterCellModificationUtilKt.getNotFoldedLines(editor, caret);
        NotebookCellLines notebookLines = NotebookCellLines.Companion.get(editor);
        NotebookCellLines.Interval currentCell = (NotebookCellLines.Interval)notebookLines.intervalsIterator(sourceLines.getFirst()).next();
        if (!currentCell.getContentLines().contains(sourceLines.getLast())) {
            return;
        }
        int n = dest = this.moveLineUp ? sourceLines.getFirst() - 1 : sourceLines.getLast() + 1;
        if (currentCell.getContentLines().contains(dest)) {
            IntRange destLines = JupyterCellModificationUtilKt.getNotFoldedLines(editor, document2.getLineStartOffset(dest));
            JupyterCellModificationUtilKt.swapNeighbourLinesInOneCell(editor, currentCell, sourceLines, destLines);
        } else {
            JupyterCellModificationUtilKt.tryMoveLinesToAnotherCell(editor, sourceLines, notebookLines, currentCell, this.moveLineUp);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }
}

