/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.inlays.progress;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSessionId;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListeners;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerConcurrentMap;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J \u0010\u001f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterInlayProgressStatusManagerImpl;", "Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterInlayProgressStatusManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cellStatus", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "cellsWithOutput", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSessionId;", "dispose", "", "executionSubmitted", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "executionStarted", "startTime", "Ljava/time/ZonedDateTime;", "hasOutput", "", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "outputAdded", "executionStopped", "jupyterStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "endTime", "setExecutionEndTime", "clearStatusForEachRunningCell", "clearStatusForEachRunningCellAndCollectThem", "", "clearStatusForCell", "resetStatus", "pointer", "getProgressStatus", "disposeEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearData", "getDocumentForNotebook", "Lcom/intellij/openapi/editor/Document;", "intellij.jupyter.core"})
public final class JupyterInlayProgressStatusManagerImpl
implements JupyterInlayProgressStatusManager,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<ProgressStatus> cellStatus;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<JupyterNotebookSessionId> cellsWithOutput;

    public JupyterInlayProgressStatusManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        this.cellStatus = new NotebookIntervalPointerConcurrentMap(messageBus, (Disposable)this);
        MessageBus messageBus2 = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus2, (String)"getMessageBus(...)");
        this.cellsWithOutput = new NotebookIntervalPointerConcurrentMap(messageBus2, (Disposable)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(JupyterRuntimeService.Listener.TOPIC, (Object)new JupyterRuntimeService.Listener(){

            @Override
            public void sessionCreated(JupyterNotebookSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            }

            @Override
            public void sessionDeleted(JupyterNotebookSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                ApplicationManager.getApplication().invokeLater(() -> 1.sessionDeleted$lambda$1(session2, this));
            }

            private static final void sessionDeleted$lambda$1(JupyterNotebookSession $session, JupyterInlayProgressStatusManagerImpl this$0) {
                Editor editor;
                BackedNotebookVirtualFile backedNotebookVirtualFile = $session.getVirtualFile();
                if (backedNotebookVirtualFile != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getOriginFile()) != null) {
                    BackedNotebookVirtualFile it = backedNotebookVirtualFile;
                    boolean bl = false;
                    v1 = JupyterHelper.INSTANCE.getJupyterEditorByOriginalVirtualFile((VirtualFile)it);
                } else {
                    v1 = editor = null;
                }
                if (editor != null) {
                    this$0.clearData(editor);
                }
            }
        });
    }

    public void dispose() {
    }

    @Override
    public void executionSubmitted(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.cellsWithOutput.remove(cellPointer);
        this.cellStatus.set(cellPointer, (Object)ProgressStatus.QUEUED);
        ((CellExecutionListener)notebook.getNotebook().getListeners().getCellExecutionListeners().getMulticaster()).executionSubmitted(cellPointer, notebook);
    }

    @Override
    public void executionStarted(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook, @NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        ThreadingAssertions.assertEventDispatchThread();
        this.cellStatus.set(cellPointer, (Object)ProgressStatus.RUNNING);
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        JupyterCell cell = notebook.getNotebook().getCell(interval2.getOrdinal());
        cell.setExecutionStartTime(startTime);
        ((CellExecutionListener)notebook.getNotebook().getListeners().getCellExecutionListeners().getMulticaster()).executionStarted(cellPointer, notebook, startTime);
    }

    @Override
    public boolean hasOutput(@NotNull NotebookIntervalPointer cellPointer, @NotNull JupyterNotebookSession session2) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        JupyterNotebookSessionId jupyterNotebookSessionId = (JupyterNotebookSessionId)this.cellsWithOutput.get(cellPointer);
        String string = jupyterNotebookSessionId != null ? jupyterNotebookSessionId.unbox-impl() : null;
        String string2 = session2.getSessionId-PaPw8_s();
        String string3 = string;
        return string3 == null ? false : JupyterNotebookSessionId.equals-impl0(string3, string2);
    }

    @Override
    public void outputAdded(@NotNull NotebookIntervalPointer cellPointer, @NotNull JupyterNotebookSession session2) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.cellsWithOutput.set(cellPointer, (Object)JupyterNotebookSessionId.box-impl(session2.getSessionId-PaPw8_s()));
    }

    @Override
    public void executionStopped(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook, @NotNull JupyterExecutionStatus jupyterStatus, @NotNull ZonedDateTime endTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        ThreadingAssertions.assertEventDispatchThread();
        switch (WhenMappings.$EnumSwitchMapping$0[jupyterStatus.ordinal()]) {
            case 2: {
                this.cellStatus.set(cellPointer, (Object)ProgressStatus.STOPPED_OK);
                this.setExecutionEndTime(cellPointer, notebook, endTime);
                break;
            }
            case 1: 
            case 3: {
                Object[] objectArray = new ProgressStatus[]{ProgressStatus.RUNNING, ProgressStatus.QUEUED};
                if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)this.cellStatus.get(cellPointer))) {
                    return;
                }
                this.cellStatus.set(cellPointer, (Object)(WhenMappings.$EnumSwitchMapping$0[jupyterStatus.ordinal()] == 1 ? ProgressStatus.STOPPED_ERROR : ProgressStatus.CANCELLED));
                this.setExecutionEndTime(cellPointer, notebook, endTime);
                this.clearStatusForEachRunningCellAndCollectThem(notebook);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ((CellExecutionListener)notebook.getNotebook().getListeners().getCellExecutionListeners().getMulticaster()).executionStopped(cellPointer, notebook, jupyterStatus, endTime);
    }

    private final void setExecutionEndTime(NotebookIntervalPointer cellPointer, BackedNotebookVirtualFile notebook, ZonedDateTime endTime) {
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        JupyterCell cell = notebook.getNotebook().getCell(interval2.getOrdinal());
        cell.setExecutionEndTime(endTime);
    }

    @Override
    public void clearStatusForEachRunningCell(@NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.clearStatusForEachRunningCellAndCollectThem(notebook);
    }

    private final List<NotebookIntervalPointer> clearStatusForEachRunningCellAndCollectThem(BackedNotebookVirtualFile notebook) {
        Document document = this.getDocumentForNotebook(notebook);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document document2 = document;
        List result = new ArrayList();
        NotebookIntervalPointerFactory pointerFactory = NotebookIntervalPointerFactory.Companion.get(this.project, document2);
        for (NotebookCellLines.Interval interval : NotebookCellLines.Companion.get(document2).getIntervals()) {
            NotebookIntervalPointer pointer = pointerFactory.create(interval);
            if (this.cellStatus.get(pointer) != ProgressStatus.RUNNING) continue;
            this.resetStatus(pointer, notebook);
            result.add(pointer);
        }
        return result;
    }

    @Override
    public void clearStatusForCell(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.resetStatus(cellPointer, notebook);
    }

    private final void resetStatus(NotebookIntervalPointer pointer, BackedNotebookVirtualFile notebook) {
        block2: {
            Object object;
            boolean updated;
            if (this.cellStatus.get(pointer) != null) {
                this.cellStatus.remove(pointer);
                v0 = true;
            } else {
                v0 = updated = false;
            }
            if (!updated || (object = notebook.getNotebookOrNull()) == null || (object = object.getListeners()) == null || (object = ((JupyterListeners)object).getCellExecutionListeners()) == null || (object = (CellExecutionListener)object.getMulticaster()) == null) break block2;
            object.executionStatusReset(pointer, notebook);
        }
    }

    @Override
    @Nullable
    public ProgressStatus getProgressStatus(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        return (ProgressStatus)this.cellStatus.get(cellPointer);
    }

    @Override
    public void disposeEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.clearData(editor);
    }

    private final void clearData(Editor editor) {
        ThreadingAssertions.assertEventDispatchThread();
        Set cellPointers = CollectionsKt.toSet((Iterable)NotebookMarkdownEditorManagerKt.getAllIntervalPointers(editor));
        if (!((Collection)cellPointers).isEmpty()) {
            BackedNotebookVirtualFile notebook = JupyterEditorExtensionsKt.getNotebookFile(editor);
            for (NotebookIntervalPointer ptr : cellPointers) {
                this.resetStatus(ptr, notebook);
            }
        }
    }

    private final Document getDocumentForNotebook(BackedNotebookVirtualFile notebook) {
        return (Document)ReadAction.compute(() -> JupyterInlayProgressStatusManagerImpl.getDocumentForNotebook$lambda$0(notebook));
    }

    private static final Document getDocumentForNotebook$lambda$0(BackedNotebookVirtualFile $notebook) {
        return FileDocumentManager.getInstance().getDocument($notebook.getFile());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionStatus.values().length];
            try {
                nArray[JupyterExecutionStatus.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.ABORTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

