/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.server;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterManagedServerProcessHandler;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/server/JupyterExecutionProcessListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "mutableStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/jupyter/core/jupyter/connections/managed/state/JupyterServerState;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/flow/MutableStateFlow;Lkotlinx/coroutines/CoroutineScope;)V", "serverPath", "", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processWillTerminate", "willBeDestroyed", "", "processTerminated", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterExecutionProcessListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterExecutionProcessListener.kt\ncom/intellij/jupyter/core/jupyter/server/JupyterExecutionProcessListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n62#2,5:73\n62#2,5:78\n62#2,5:83\n15#2:88\n*S KotlinDebug\n*F\n+ 1 JupyterExecutionProcessListener.kt\ncom/intellij/jupyter/core/jupyter/server/JupyterExecutionProcessListener\n*L\n25#1:73,5\n39#1:78,5\n56#1:83,5\n62#1:88\n*E\n"})
public final class JupyterExecutionProcessListener
extends ProcessAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableStateFlow<JupyterServerState> mutableStateFlow;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private String serverPath;
    @NotNull
    private static final Logger LOG;

    public JupyterExecutionProcessListener(@NotNull MutableStateFlow<JupyterServerState> mutableStateFlow, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(mutableStateFlow, (String)"mutableStateFlow");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.mutableStateFlow = mutableStateFlow;
        this.coroutineScope = coroutineScope;
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        ProcessHandler processHandler = event.getProcessHandler();
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)processHandler);
            Long l = JupyterExecutionProcessListener.Companion.pid(processHandler);
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            char[] cArray = new char[]{'\r', '\n'};
            logger.debug("PID " + l + ": " + StringsKt.trimStart((String)((Object)StringsKt.trimEnd((CharSequence)string)).toString(), (char[])cArray), e$iv);
        }
        if (!Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
            return;
        }
        if (this.serverPath == null) {
            Regex regex = JupyterManagedServerProcessHandler.Companion.getSERVER_PATH_PATTERN();
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Object object = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
            this.serverPath = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
        }
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProcessHandler processHandler = event.getProcessHandler();
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)processHandler);
            logger.debug("PID " + JupyterExecutionProcessListener.Companion.pid(processHandler) + ": Process " + processHandler + " will terminate", e$iv);
        }
        this.mutableStateFlow.setValue((Object)new JupyterServerFinished(willBeDestroyed));
        if (processHandler instanceof KillableProcessHandler) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(processHandler, null){
                int label;
                final /* synthetic */ ProcessHandler $processHandler;
                {
                    this.$processHandler = $processHandler;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            if (!((KillableProcessHandler)this.$processHandler).isProcessTerminated()) {
                                JupyterExecutionProcessListener.access$getLOG$cp().info("PID " + com.intellij.jupyter.core.jupyter.server.JupyterExecutionProcessListener$Companion.access$pid(JupyterExecutionProcessListener.Companion, this.$processHandler) + ": Process " + this.$processHandler + " still hasn't terminated. Killing it.");
                                ((KillableProcessHandler)this.$processHandler).killProcess();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProcessHandler processHandler = event.getProcessHandler();
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)processHandler);
            logger.debug("PID " + JupyterExecutionProcessListener.Companion.pid(processHandler) + ": Process " + processHandler + " terminated with exit code " + event.getExitCode(), e$iv);
        }
        if (!(this.mutableStateFlow.getValue() instanceof JupyterServerFinished)) {
            this.mutableStateFlow.setValue((Object)new JupyterServerFinished(true));
        }
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JupyterExecutionProcessListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/server/JupyterExecutionProcessListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "pid", "", "Lcom/intellij/execution/process/ProcessHandler;", "(Lcom/intellij/execution/process/ProcessHandler;)Ljava/lang/Long;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Long pid(ProcessHandler $this$pid) {
            Long l;
            try {
                Object object = $this$pid instanceof BaseProcessHandler ? (BaseProcessHandler)$this$pid : null;
                l = object != null && (object = object.getProcess()) != null ? Long.valueOf(((Process)object).pid()) : null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                l = null;
            }
            return l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

