/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.services.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.language.psi.EditorConfigPsiFile;
import org.editorconfig.language.psi.reference.EditorConfigVirtualFileDescriptor;
import org.editorconfig.language.services.EditorConfigFileHierarchyService;
import org.editorconfig.language.services.EditorConfigServiceLoaded;
import org.editorconfig.language.services.EditorConfigServiceLoading;
import org.editorconfig.language.services.EditorConfigServiceResult;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001)B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0018\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0018\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0018\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00162\u0006\u0010'\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl;", "Lorg/editorconfig/language/services/EditorConfigFileHierarchyService;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "cacheDropsCount", "", "cacheLocker", "", "parentFilesCache", "Lcom/intellij/util/containers/FixedHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/lang/ref/Reference;", "", "Lorg/editorconfig/language/psi/EditorConfigPsiFile;", "dispose", "", "updateHandlers", "after", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "afterValueChanged", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getParentEditorConfigFiles", "Lorg/editorconfig/language/services/EditorConfigServiceResult;", "virtualFile", "startBackgroundTask", "findApplicableFiles", "findParentPsiFiles", "file", "findParentFiles", "Companion", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigFileHierarchyServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigFileHierarchyServiceImpl.kt\norg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,184:1\n607#2:185\n209#2,8:186\n15#3:194\n*S KotlinDebug\n*F\n+ 1 EditorConfigFileHierarchyServiceImpl.kt\norg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl\n*L\n138#1:185\n143#1:186,8\n180#1:194\n*E\n"})
public final class EditorConfigFileHierarchyServiceImpl
extends EditorConfigFileHierarchyService
implements BulkFileListener,
RegistryValueListener,
Disposable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService taskExecutor;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    private volatile int cacheDropsCount;
    @NotNull
    private final Object cacheLocker;
    @NotNull
    private final FixedHashMap<VirtualFile, Reference<List<EditorConfigPsiFile>>> parentFilesCache;
    @NotNull
    private static final Logger Log;
    private static final int CacheSize = 10;

    public EditorConfigFileHierarchyServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"EditorConfig.notification.vfs.update.executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.taskExecutor = executorService;
        this.updateQueue = new MergingUpdateQueue("EditorConfigFileHierarchy UpdateQueue", 500, true, null, (Disposable)this, null, false, 96, null);
        this.cacheLocker = new Object();
        this.parentFilesCache = new FixedHashMap(10);
        DumbService.Companion.getInstance(this.project).runWhenSmart(() -> EditorConfigFileHierarchyServiceImpl._init_$lambda$0(this));
        Registry.Companion.get("editor.config.stop.at.project.root").addListener((RegistryValueListener)this, (Disposable)this);
    }

    public void dispose() {
    }

    private final void updateHandlers(Project project) {
        this.updateQueue.queue(Update.Companion.create((Object)"editorconfig hierarchy update", () -> EditorConfigFileHierarchyServiceImpl.updateHandlers$lambda$1(project)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        List editorConfigs = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), EditorConfigFileHierarchyServiceImpl::after$lambda$2));
        if (!((Collection)editorConfigs).isEmpty()) {
            Object object = this.cacheLocker;
            synchronized (object) {
                boolean bl = false;
                ++this.cacheDropsCount;
                this.parentFilesCache.clear();
                Unit unit = Unit.INSTANCE;
            }
            this.updateHandlers(this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterValueChanged(@NotNull RegistryValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = this.cacheLocker;
        synchronized (object) {
            boolean bl = false;
            ++this.cacheDropsCount;
            this.parentFilesCache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public EditorConfigServiceResult getParentEditorConfigFiles(@NotNull VirtualFile virtualFile) {
        List cachedResult;
        Reference reference;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Object object = this.cacheLocker;
        synchronized (object) {
            boolean bl = false;
            reference = (Reference)this.parentFilesCache.get((Object)virtualFile);
        }
        Reference reference2 = reference;
        List list = cachedResult = reference2 != null ? (List)reference2.get() : null;
        if (cachedResult != null) {
            return new EditorConfigServiceLoaded(cachedResult);
        }
        this.startBackgroundTask(virtualFile);
        return EditorConfigServiceLoading.INSTANCE;
    }

    private final void startBackgroundTask(VirtualFile virtualFile) {
        int expectedCacheDropsCount = this.cacheDropsCount;
        ReadAction.nonBlocking(() -> EditorConfigFileHierarchyServiceImpl.startBackgroundTask$lambda$6(this, virtualFile)).expireWith((Disposable)this).finishOnUiThread(ModalityState.any(), arg_0 -> EditorConfigFileHierarchyServiceImpl.startBackgroundTask$lambda$9(arg_0 -> EditorConfigFileHierarchyServiceImpl.startBackgroundTask$lambda$8(this, expectedCacheDropsCount, virtualFile, arg_0), arg_0)).submit((Executor)this.taskExecutor);
    }

    private final List<EditorConfigPsiFile> findApplicableFiles(VirtualFile virtualFile) {
        List<EditorConfigPsiFile> list;
        Application app = ApplicationManager.getApplication();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        app.assertReadAccessAllowed();
        if (!EditorConfigRegistry.shouldStopAtProjectRoot()) {
            list = this.findParentPsiFiles(virtualFile);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            list = EditorConfigPsiTreeUtil.INSTANCE.findAllParentsFiles(psiFile);
        }
        return list;
    }

    private final List<EditorConfigPsiFile> findParentPsiFiles(VirtualFile file) {
        int firstRoot;
        Sequence parents;
        int expectedCacheDropsCount;
        block8: {
            int n;
            Sequence $this$sortedBy$iv;
            block10: {
                block9: {
                    Sequence sequence;
                    Application app = ApplicationManager.getApplication();
                    ApplicationManager.getApplication().assertIsNonDispatchThread();
                    app.assertReadAccessAllowed();
                    expectedCacheDropsCount = this.cacheDropsCount;
                    List<VirtualFile> list = this.findParentFiles(file);
                    if (list == null || (sequence = CollectionsKt.asSequence((Iterable)list)) == null) break block9;
                    Sequence sequence2 = sequence;
                    EditorConfigVirtualFileDescriptor editorConfigVirtualFileDescriptor = new EditorConfigVirtualFileDescriptor(file);
                    boolean $i$f$sortedBy = false;
                    Sequence sequence3 = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(editorConfigVirtualFileDescriptor){
                        final /* synthetic */ EditorConfigVirtualFileDescriptor $receiver$inlined;
                        {
                            this.$receiver$inlined = editorConfigVirtualFileDescriptor;
                        }

                        public final int compare(T a, T b) {
                            VirtualFile p0 = (VirtualFile)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(this.$receiver$inlined.distanceToParent(p0));
                            p0 = (VirtualFile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$receiver$inlined.distanceToParent(p0)));
                        }
                    });
                    if (sequence3 != null && ($this$sortedBy$iv = SequencesKt.mapNotNull((Sequence)sequence3, arg_0 -> EditorConfigFileHierarchyServiceImpl.findParentPsiFiles$lambda$10(this, arg_0))) != null) break block10;
                }
                return null;
            }
            Sequence $this$indexOfFirst$iv = parents = $this$sortedBy$iv;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EditorConfigPsiFile p0 = (EditorConfigPsiFile)((Object)item$iv);
                boolean bl = false;
                if (p0.getHasValidRootDeclaration()) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = firstRoot = -1;
        }
        if (this.cacheDropsCount != expectedCacheDropsCount) {
            return null;
        }
        ProgressManager.checkCanceled();
        return firstRoot < 0 ? SequencesKt.toList((Sequence)parents) : SequencesKt.toList((Sequence)SequencesKt.take((Sequence)parents, (int)(firstRoot + 1)));
    }

    private final List<VirtualFile> findParentFiles(VirtualFile file) {
        Application app = ApplicationManager.getApplication();
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        app.assertReadAccessAllowed();
        String fileName = ".editorconfig";
        int expectedCacheDropsCount = this.cacheDropsCount;
        List result2 = new ArrayList();
        for (VirtualFile currentFolder = file.getParent(); currentFolder != null; currentFolder = currentFolder.getParent()) {
            if (this.cacheDropsCount != expectedCacheDropsCount) {
                return null;
            }
            ProgressManager.checkCanceled();
            VirtualFile child = currentFolder.findChild(fileName);
            if (child == null || child.isDirectory()) continue;
            result2.add(child);
        }
        return result2;
    }

    private static final void _init_$lambda$0(EditorConfigFileHierarchyServiceImpl this$0) {
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this$0);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)this$0);
    }

    private static final void updateHandlers$lambda$1(Project $project) {
        CodeStyleSettingsManager.getInstance((Project)$project).notifyCodeStyleSettingsChanged();
    }

    private static final boolean after$lambda$2(VFileEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PathUtil.getFileName((String)it.getPath()), (Object)".editorconfig") && it.isFromSave();
    }

    private static final List startBackgroundTask$lambda$6(EditorConfigFileHierarchyServiceImpl this$0, VirtualFile $virtualFile) {
        return this$0.findApplicableFiles($virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startBackgroundTask$lambda$8(EditorConfigFileHierarchyServiceImpl this$0, int $expectedCacheDropsCount, VirtualFile $virtualFile, List affectingFiles) {
        if (affectingFiles == null) {
            return Unit.INSTANCE;
        }
        Object object = this$0.cacheLocker;
        synchronized (object) {
            block5: {
                boolean bl = false;
                if ($expectedCacheDropsCount == this$0.cacheDropsCount) break block5;
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            ((Map)this$0.parentFilesCache).put($virtualFile, new SoftReference<List>(affectingFiles));
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final void startBackgroundTask$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final EditorConfigPsiFile findParentPsiFiles$lambda$10(EditorConfigFileHierarchyServiceImpl this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = PsiManager.getInstance((Project)this$0.project).findFile(it);
        return psiFile instanceof EditorConfigPsiFile ? (EditorConfigPsiFile)psiFile : null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EditorConfigFileHierarchyService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/editorconfig/language/services/impl/EditorConfigFileHierarchyServiceImpl$Companion;", "", "<init>", "()V", "Log", "Lcom/intellij/openapi/diagnostic/Logger;", "CacheSize", "", "intellij.editorconfig"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

