/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.context.impl;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCachedValue;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.minimatch.Minimatch;
import com.intellij.util.text.minimatch.MinimatchOptions;
import com.intellij.webSymbols.context.WebSymbolsContext;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "contexts", "", "Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$ContextEntry;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "getContextsInDirectory", "Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$DirectoryContext;", "directory", "priorityOffset", "", "DirectoryContext", "ContextEntry", "Companion", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsContextFileData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsContextFileData.kt\ncom/intellij/webSymbols/context/impl/WebSymbolsContextFileData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1#2:131\n774#3:132\n865#3,2:133\n1557#3:135\n1628#3,3:136\n*S KotlinDebug\n*F\n+ 1 WebSymbolsContextFileData.kt\ncom/intellij/webSymbols/context/impl/WebSymbolsContextFileData\n*L\n30#1:132\n30#1:133,2\n31#1:135\n31#1:136,3\n*E\n"})
public final class WebSymbolsContextFileData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final List<ContextEntry> contexts;
    @NotNull
    private static final Key<VirtualFileCachedValue<WebSymbolsContextFileData>> WEB_SYMBOLS_CONTEXT_FILE_DATA = new Key("web-symbols-context-file-data");

    private WebSymbolsContextFileData(VirtualFile file, List<ContextEntry> contexts) {
        this.file = file;
        this.contexts = contexts;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DirectoryContext> getContextsInDirectory(@NotNull VirtualFile directory, int priorityOffset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ContextEntry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                object = VfsUtil.getRelativePath((VirtualFile)directory, (VirtualFile)this.file.getParent());
                if (object == null) break block4;
                String it2 = object;
                boolean bl = false;
                String string = "/" + it2 + "/";
                object = string;
                if (string != null) break block5;
            }
            return CollectionsKt.emptyList();
        }
        Object path = object;
        Iterable iterable = this.contexts;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ContextEntry)element$iv$iv;
            boolean bl = false;
            Minimatch minimatch = it.getDirPattern();
            if (!(minimatch != null ? Minimatch.match$default((Minimatch)minimatch, (String)path, (boolean)false, (int)2, null) : true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ContextEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DirectoryContext(it.getFilePattern(), it.getContext(), (float)(it.getPriority() + priorityOffset) + (it.getFilePattern() != null ? 0.5f : 0.0f)));
        }
        return (List)destination$iv$iv;
    }

    public /* synthetic */ WebSymbolsContextFileData(VirtualFile file, List contexts, DefaultConstructorMarker $constructor_marker) {
        this(file, contexts);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J,\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00142\u001a\u0010\u001a\u001a\u0016\u0012\b\u0012\u00060\u0014j\u0002`\u001c\u0012\b\u0012\u00060\u0014j\u0002`\u001d0\u001bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$Companion;", "", "<init>", "()V", "WEB_SYMBOLS_CONTEXT_FILE_DATA", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vfs/VirtualFileCachedValue;", "Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData;", "getOrCreate", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "parseSafely", "contents", "", "parse", "readContextPattern", "", "reader", "Lcom/google/gson/stream/JsonReader;", "dirPattern", "", "contexts", "", "Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$ContextEntry;", "buildContextEntry", "pattern", "dirContext", "", "Lcom/intellij/webSymbols/ContextKind;", "Lcom/intellij/webSymbols/ContextName;", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebSymbolsContextFileData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsContextFileData.kt\ncom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,130:1\n25#2:131\n1#3:132\n1104#4,3:133\n*S KotlinDebug\n*F\n+ 1 WebSymbolsContextFileData.kt\ncom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$Companion\n*L\n65#1:131\n119#1:133,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebSymbolsContextFileData getOrCreate(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return (WebSymbolsContextFileData)VirtualFileUtil.getCachedValue$default((VirtualFile)file, (Key)WEB_SYMBOLS_CONTEXT_FILE_DATA, (boolean)false, null, (Function2)((Function2)new Function2<VirtualFile, CharSequence, WebSymbolsContextFileData>((Object)this){

                public final WebSymbolsContextFileData invoke(VirtualFile p0, CharSequence p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return com.intellij.webSymbols.context.impl.WebSymbolsContextFileData$Companion.access$parseSafely((Companion)this.receiver, p0, p1);
                }
            }), (int)6, null);
        }

        private final WebSymbolsContextFileData parseSafely(VirtualFile file, CharSequence contents) {
            CharSequence charSequence = contents;
            if (!(charSequence == null || charSequence.length() == 0)) {
                try {
                    return this.parse(file, contents);
                }
                catch (Exception e) {
                    Companion $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Failed to parse " + file.getPath(), (Throwable)e);
                }
            }
            return new WebSymbolsContextFileData(file, CollectionsKt.emptyList(), null);
        }

        private final WebSymbolsContextFileData parse(VirtualFile file, CharSequence contents) {
            JsonReader reader = new JsonReader((Reader)new CharSequenceReader(contents));
            reader.setLenient(true);
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                throw new IOException("Top level element should be an object");
            }
            List contexts = new ArrayList();
            this.readContextPattern(reader, "", contexts);
            return new WebSymbolsContextFileData(file, contexts, null);
        }

        private final void readContextPattern(JsonReader reader, String dirPattern, List<ContextEntry> contexts) {
            reader.beginObject();
            Map dirContext = new LinkedHashMap();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                    String string;
                    if (((CharSequence)dirPattern).length() > 0 && !StringsKt.endsWith$default((String)dirPattern, (String)"/", (boolean)false, (int)2, null)) {
                        Intrinsics.checkNotNull((Object)key);
                        string = dirPattern + "/" + StringsKt.removePrefix((String)key, (CharSequence)"/");
                    } else {
                        string = dirPattern + key;
                    }
                    String nestedPattern = string;
                    this.readContextPattern(reader, nestedPattern, contexts);
                    continue;
                }
                if (reader.peek() == JsonToken.STRING) {
                    dirContext.put(key, reader.nextString());
                    continue;
                }
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    dirContext.put(key, WebSymbolsContext.VALUE_NONE);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            if (!dirContext.isEmpty()) {
                contexts.add(((CharSequence)dirPattern).length() == 0 ? new ContextEntry(null, null, dirContext, 0) : this.buildContextEntry(dirPattern, dirContext));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final ContextEntry buildContextEntry(String pattern, Map<String, String> dirContext) {
            Regex regex;
            char[] cArray;
            String string;
            String filePattern;
            String string2;
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)pattern, (char)'/', (int)0, (boolean)false, (int)6, null);
            String string3 = pattern.substring(lastSlash + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String it = string2 = string3;
            boolean bl = false;
            String string4 = filePattern = !Intrinsics.areEqual((Object)it, (Object)"**") ? string2 : null;
            if (filePattern == null) {
                string = pattern;
            } else if (lastSlash >= 0) {
                String string5 = pattern.substring(0, lastSlash);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                string = "/";
            }
            String it2 = string;
            boolean bl2 = false;
            Object dirPattern = StringsKt.startsWith$default((String)it2, (String)"/", (boolean)false, (int)2, null) ? it2 : "/" + it2;
            CharSequence $this$count$iv = (CharSequence)dirPattern;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it3 = element$iv = $this$count$iv.charAt(i);
                boolean bl3 = false;
                if (!(it3 == '/')) continue;
                ++count$iv;
            }
            int priority = count$iv - StringUtil.getOccurrenceCount((String)dirPattern, (String)"/**/") - (StringsKt.endsWith$default((String)dirPattern, (String)"/**", (boolean)false, (int)2, null) ? 1 : 0) - 1;
            Minimatch minimatch = new Minimatch((String)(!StringsKt.endsWith$default((String)dirPattern, (String)"/**", (boolean)false, (int)2, null) ? (String)dirPattern + "/" : dirPattern), new MinimatchOptions(false, true, true, true, false, false, true, false, false, false, 945, null));
            Object object = filePattern;
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{'*'}), (boolean)false, (int)0, (int)6, null)) != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)".*", null, null, (int)0, null, Companion::buildContextEntry$lambda$3, (int)30, null)) != null) {
                void it4;
                Object object2 = object;
                Minimatch minimatch2 = minimatch;
                boolean bl4 = false;
                regex = new Regex((String)it4);
                minimatch = minimatch2;
            } else {
                regex = null;
            }
            int n = priority;
            Map<String, String> map = dirContext;
            Regex regex2 = regex;
            Minimatch minimatch3 = minimatch;
            return new ContextEntry(minimatch3, regex2, map, n);
        }

        private static final CharSequence buildContextEntry$lambda$3(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((CharSequence)it).length() > 0 ? (CharSequence)Regex.Companion.escape(it) : (CharSequence)it;
        }

        public static final /* synthetic */ WebSymbolsContextFileData access$parseSafely(Companion $this, VirtualFile file, CharSequence contents) {
            return $this.parseSafely(file, contents);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\u0006\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\n0\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\fH\u00c6\u0003JI\u0010\u001b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u001c\b\u0002\u0010\u0006\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\n0\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\fH\u00d6\u0001J\t\u0010 \u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R%\u0010\u0006\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$ContextEntry;", "", "dirPattern", "Lcom/intellij/util/text/minimatch/Minimatch;", "filePattern", "Lkotlin/text/Regex;", "context", "", "", "Lcom/intellij/webSymbols/ContextKind;", "Lcom/intellij/webSymbols/ContextName;", "priority", "", "<init>", "(Lcom/intellij/util/text/minimatch/Minimatch;Lkotlin/text/Regex;Ljava/util/Map;I)V", "getDirPattern", "()Lcom/intellij/util/text/minimatch/Minimatch;", "getFilePattern", "()Lkotlin/text/Regex;", "getContext", "()Ljava/util/Map;", "getPriority", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.webSymbols"})
    private static final class ContextEntry {
        @Nullable
        private final Minimatch dirPattern;
        @Nullable
        private final Regex filePattern;
        @NotNull
        private final Map<String, String> context;
        private final int priority;

        public ContextEntry(@Nullable Minimatch dirPattern, @Nullable Regex filePattern, @NotNull Map<String, String> context, int priority) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            this.dirPattern = dirPattern;
            this.filePattern = filePattern;
            this.context = context;
            this.priority = priority;
        }

        @Nullable
        public final Minimatch getDirPattern() {
            return this.dirPattern;
        }

        @Nullable
        public final Regex getFilePattern() {
            return this.filePattern;
        }

        @NotNull
        public final Map<String, String> getContext() {
            return this.context;
        }

        public final int getPriority() {
            return this.priority;
        }

        @Nullable
        public final Minimatch component1() {
            return this.dirPattern;
        }

        @Nullable
        public final Regex component2() {
            return this.filePattern;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.context;
        }

        public final int component4() {
            return this.priority;
        }

        @NotNull
        public final ContextEntry copy(@Nullable Minimatch dirPattern, @Nullable Regex filePattern, @NotNull Map<String, String> context, int priority) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return new ContextEntry(dirPattern, filePattern, context, priority);
        }

        public static /* synthetic */ ContextEntry copy$default(ContextEntry contextEntry, Minimatch minimatch, Regex regex, Map map, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                minimatch = contextEntry.dirPattern;
            }
            if ((n2 & 2) != 0) {
                regex = contextEntry.filePattern;
            }
            if ((n2 & 4) != 0) {
                map = contextEntry.context;
            }
            if ((n2 & 8) != 0) {
                n = contextEntry.priority;
            }
            return contextEntry.copy(minimatch, regex, map, n);
        }

        @NotNull
        public String toString() {
            return "ContextEntry(dirPattern=" + this.dirPattern + ", filePattern=" + this.filePattern + ", context=" + this.context + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            int result2 = this.dirPattern == null ? 0 : this.dirPattern.hashCode();
            result2 = result2 * 31 + (this.filePattern == null ? 0 : this.filePattern.hashCode());
            result2 = result2 * 31 + ((Object)this.context).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.priority);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextEntry)) {
                return false;
            }
            ContextEntry contextEntry = (ContextEntry)other;
            if (!Intrinsics.areEqual((Object)this.dirPattern, (Object)contextEntry.dirPattern)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.filePattern, (Object)contextEntry.filePattern)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.context, contextEntry.context)) {
                return false;
            }
            return this.priority == contextEntry.priority;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0004\u001a\u0016\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/webSymbols/context/impl/WebSymbolsContextFileData$DirectoryContext;", "", "filePattern", "Lkotlin/text/Regex;", "context", "", "", "Lcom/intellij/webSymbols/ContextKind;", "Lcom/intellij/webSymbols/ContextName;", "priority", "", "<init>", "(Lkotlin/text/Regex;Ljava/util/Map;F)V", "getContext", "()Ljava/util/Map;", "getPriority", "()F", "matches", "", "fileName", "toString", "intellij.platform.webSymbols"})
    public static final class DirectoryContext {
        @Nullable
        private final Regex filePattern;
        @NotNull
        private final Map<String, String> context;
        private final float priority;

        public DirectoryContext(@Nullable Regex filePattern, @NotNull Map<String, String> context, float priority) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            this.filePattern = filePattern;
            this.context = context;
            this.priority = priority;
        }

        @NotNull
        public final Map<String, String> getContext() {
            return this.context;
        }

        public final float getPriority() {
            return this.priority;
        }

        public final boolean matches(@Nullable String fileName) {
            return this.filePattern == null || fileName != null && this.filePattern.matches((CharSequence)fileName);
        }

        @NotNull
        public String toString() {
            return "DirectoryContext(filePattern=" + this.filePattern + ", context=" + this.context + ", priority=" + this.priority + ")";
        }
    }
}

