/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.sf.cglib.asm.$ClassVisitor;
import net.sf.cglib.asm.$Label;
import net.sf.cglib.asm.$Type;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.MethodInfoTransformer;
import net.sf.cglib.core.MethodWrapper;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.RejectModifierPredicate;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.BridgeMethodGenerator;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackGenerator;
import net.sf.cglib.proxy.CallbackInfo;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import org.jetbrains.annotations.NotNull;

public final class AdvancedEnhancer
extends AbstractClassGenerator {
    private static final CallbackFilter ALL_ZERO = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            return 0;
        }
    };
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(Enhancer.class.getName());
    private static final String BOUND_FIELD = "CGLIB$BOUND";
    private static final String THREAD_CALLBACKS_FIELD = "CGLIB$THREAD_CALLBACKS";
    private static final String STATIC_CALLBACKS_FIELD = "CGLIB$STATIC_CALLBACKS";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final String SET_STATIC_CALLBACKS_NAME = "CGLIB$SET_STATIC_CALLBACKS";
    private static final String CONSTRUCTED_FIELD = "CGLIB$CONSTRUCTED";
    private static final $Type FACTORY = TypeUtils.parseType("net.sf.cglib.proxy.Factory");
    private static final $Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final $Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final $Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final $Type CALLBACK = TypeUtils.parseType("net.sf.cglib.proxy.Callback");
    private static final $Type CALLBACK_ARRAY = $Type.getType(Callback[].class);
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = new Signature("CGLIB$SET_THREAD_CALLBACKS", $Type.VOID_TYPE, new $Type[]{CALLBACK_ARRAY});
    private static final Signature SET_STATIC_CALLBACKS = new Signature("CGLIB$SET_STATIC_CALLBACKS", $Type.VOID_TYPE, new $Type[]{CALLBACK_ARRAY});
    private static final Signature NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new $Type[]{CALLBACK_ARRAY});
    private static final Signature MULTIARG_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new $Type[]{Constants.TYPE_CLASS_ARRAY, Constants.TYPE_OBJECT_ARRAY, CALLBACK_ARRAY});
    private static final Signature SINGLE_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new $Type[]{CALLBACK});
    private static final Signature SET_CALLBACK = new Signature("setCallback", $Type.VOID_TYPE, new $Type[]{$Type.INT_TYPE, CALLBACK});
    private static final Signature GET_CALLBACK = new Signature("getCallback", CALLBACK, new $Type[]{$Type.INT_TYPE});
    private static final Signature SET_CALLBACKS = new Signature("setCallbacks", $Type.VOID_TYPE, new $Type[]{CALLBACK_ARRAY});
    private static final Signature GET_CALLBACKS = new Signature("getCallbacks", CALLBACK_ARRAY, new $Type[0]);
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private static final Signature BIND_CALLBACKS = TypeUtils.parseSignature("void CGLIB$BIND_CALLBACKS(Object)");
    private static final DefaultNamingPolicy JETBRAINS_NAMING_POLICY = new DefaultNamingPolicy(){

        @Override
        protected String getTag() {
            return "ByJetBrainsMainCglib";
        }
    };
    private Class<?>[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private $Type[] callbackTypes;
    private boolean classOnly;
    private Class<?> superclass;
    private Class<?>[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    private boolean interceptDuringConstruction = true;

    public AdvancedEnhancer() {
        super(SOURCE);
        this.setNamingPolicy(JETBRAINS_NAMING_POLICY);
    }

    public void setSuperclass(Class superclass) {
        if (superclass != null && superclass.isInterface()) {
            this.setInterfaces(new Class[]{superclass});
        } else {
            this.superclass = superclass != null && superclass.equals(Object.class) ? null : superclass;
        }
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(new Callback[]{callback});
    }

    public void setCallbacks(Callback[] callbacks) {
        if (callbacks != null && callbacks.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbacks;
    }

    public void setUseFactory(boolean useFactory) {
        this.useFactory = useFactory;
    }

    public void setInterceptDuringConstruction(boolean interceptDuringConstruction) {
        this.interceptDuringConstruction = interceptDuringConstruction;
    }

    public void setCallbackTypes(Class[] callbackTypes) {
        if (callbackTypes != null && callbackTypes.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = CallbackInfo.determineTypes(callbackTypes);
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Class[] argumentTypes, Object[] arguments) {
        this.classOnly = false;
        if (argumentTypes == null || arguments == null || argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        AdvancedEnhancer advancedEnhancer = this;
        synchronized (advancedEnhancer) {
            Object object;
            this.argumentTypes = argumentTypes;
            this.arguments = arguments;
            try {
                object = this.createHelper();
                this.arguments = null;
            }
            catch (Throwable throwable) {
                this.arguments = null;
                throw throwable;
            }
            return object;
        }
    }

    private void validate() {
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("Callbacks are required");
        }
        if (this.classOnly && this.callbackTypes == null) {
            throw new IllegalStateException("Callback types are required");
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            $Type[] check = CallbackInfo.determineTypes(this.callbacks);
            for (int i = 0; i < check.length; ++i) {
                if (check[i].equals(this.callbackTypes[i])) continue;
                throw new IllegalStateException("Callback " + String.valueOf(check[i]) + " is not assignable to " + String.valueOf(this.callbackTypes[i]));
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks);
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = ALL_ZERO;
        }
        if (this.interfaces != null) {
            for (Class<?> anInterface : this.interfaces) {
                if (anInterface == null) {
                    throw new IllegalStateException("Interfaces cannot be null");
                }
                if (anInterface.isInterface()) continue;
                throw new IllegalStateException(String.valueOf(anInterface) + " is not an interface");
            }
        }
    }

    private Object createHelper() {
        this.validate();
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[ReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        return super.create(this.createKey());
    }

    @NotNull
    private List<Object> createKey() {
        ArrayList<Object> tuple = new ArrayList<Object>();
        tuple.add(Arrays.asList(this.callbackTypes));
        tuple.add((this.useFactory ? 1 : 0) + (this.interceptDuringConstruction ? 2 : 0));
        if (this.superclass != null) {
            tuple.add(this.superclass.getName());
        }
        if (this.interfaces != null) {
            tuple.addAll(ContainerUtil.map((Object[])this.interfaces, Class::getName));
        }
        ArrayList<Object> arrayList = tuple;
        if (arrayList == null) {
            AdvancedEnhancer.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        ClassLoader superLoader;
        ClassLoader bestLoader = null;
        ClassLoader nonPluginLoader = null;
        Predicate<PluginClassLoader> isBetter = new Predicate<PluginClassLoader>(){
            private int myMaxIndex = -1;
            private Object2IntMap<ClassLoader> myMap = null;

            @Override
            public boolean test(@NotNull PluginClassLoader loader) {
                int index;
                boolean result2;
                if (loader == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (this.myMap == null) {
                    List plugins = PluginManagerCore.INSTANCE.getPluginSet().getEnabledModules();
                    int count = 0;
                    this.myMap = new Object2IntOpenHashMap(plugins.size());
                    for (IdeaPluginDescriptor descriptor : plugins) {
                        this.myMap.put((Object)descriptor.getClassLoader(), count++);
                    }
                }
                boolean bl = result2 = this.myMaxIndex < (index = this.myMap.applyAsInt((Object)loader));
                if (result2) {
                    this.myMaxIndex = index;
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "net/sf/cglib/proxy/AdvancedEnhancer$3", "test"));
            }
        };
        if (this.interfaces != null) {
            for (Class<?> anInterface : this.interfaces) {
                ClassLoader loader = anInterface.getClassLoader();
                if (loader instanceof PluginClassLoader) {
                    if (!isBetter.test((PluginClassLoader)loader)) continue;
                    bestLoader = (PluginClassLoader)loader;
                    continue;
                }
                if (nonPluginLoader != null) continue;
                nonPluginLoader = loader;
            }
        }
        ClassLoader classLoader = superLoader = this.superclass != null ? this.superclass.getClassLoader() : null;
        return superLoader instanceof PluginClassLoader && isBetter.test((PluginClassLoader)superLoader) ? superLoader : (bestLoader != null ? bestLoader : (superLoader != null ? superLoader : nonPluginLoader));
    }

    private static Signature rename(Signature sig, int index) {
        return new Signature("CGLIB$" + sig.getName() + "$" + index, sig.getDescriptor());
    }

    private static void getMethods(Class<?> superclass, Class<?>[] interfaces, List<Method> methods, List<Method> interfaceMethods, Set forcePublic) {
        List<Method> target;
        ReflectUtils.addAllMethods(superclass, methods);
        List<Method> list2 = target = interfaceMethods != null ? interfaceMethods : methods;
        if (interfaces != null) {
            for (Class<?> anInterface : interfaces) {
                if (anInterface == Factory.class) continue;
                ReflectUtils.addAllMethods(anInterface, target);
            }
        }
        if (interfaceMethods != null) {
            if (forcePublic != null) {
                forcePublic.addAll(MethodWrapper.createSet(interfaceMethods));
            }
            methods.addAll(interfaceMethods);
        }
        CollectionUtils.filter(methods, new DuplicatesPredicate());
        CollectionUtils.filter(methods, new RejectModifierPredicate(24));
        CollectionUtils.filter(methods, new VisibilityPredicate(superclass, true));
    }

    @Override
    public void generateClass($ClassVisitor v) {
        Class sc;
        Class clazz = sc = this.superclass == null ? Object.class : this.superclass;
        if (TypeUtils.isFinal(sc.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + String.valueOf(sc));
        }
        ArrayList constructors = new ArrayList(Arrays.asList(sc.getDeclaredConstructors()));
        AdvancedEnhancer.filterConstructors(sc, constructors);
        HashSet forcePublic = new HashSet();
        ArrayList<Method> actualMethods = new ArrayList<Method>();
        HashMap<Method, Method> covariantMethods = new HashMap<Method, Method>();
        AdvancedEnhancer.getMethods(sc, this.interfaces, actualMethods, new ArrayList<Method>(), forcePublic);
        for (Class aClass = sc; aClass != null; aClass = aClass.getSuperclass()) {
            for (Method method : aClass.getDeclaredMethods()) {
                if (!actualMethods.contains(method)) continue;
                AdvancedEnhancer.removeAllCovariantMethods(actualMethods, method, covariantMethods);
            }
        }
        ClassEmitter e = new ClassEmitter(v);
        e.begin_class(46, 1, this.getClassName(), $Type.getType(sc), this.useFactory ? TypeUtils.add(TypeUtils.getTypes(this.interfaces), FACTORY) : TypeUtils.getTypes(this.interfaces), "<generated>");
        List constructorInfo = CollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        e.declare_field(2, BOUND_FIELD, $Type.BOOLEAN_TYPE, null);
        if (!this.interceptDuringConstruction) {
            e.declare_field(2, CONSTRUCTED_FIELD, $Type.BOOLEAN_TYPE, null);
        }
        e.declare_field(26, THREAD_CALLBACKS_FIELD, THREAD_LOCAL, null);
        e.declare_field(26, STATIC_CALLBACKS_FIELD, CALLBACK_ARRAY, null);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.declare_field(2, AdvancedEnhancer.getCallbackField(i), this.callbackTypes[i], null);
        }
        HashMap<Method, MethodInfo> methodInfoMap = new HashMap<Method, MethodInfo>();
        for (Method method : actualMethods) {
            if (AdvancedEnhancer.isJdk8DefaultMethod(method)) continue;
            int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
            if (forcePublic.contains(MethodWrapper.create(method))) {
                modifiers = modifiers & 0xFFFFFFFB | 1;
            }
            if (covariantMethods.containsKey(method)) {
                modifiers |= 0x40;
            }
            methodInfoMap.put(method, ReflectUtils.getMethodInfo(method, modifiers));
        }
        this.emitMethods(e, methodInfoMap, covariantMethods);
        this.emitConstructors(e, constructorInfo);
        AdvancedEnhancer.emitSetThreadCallbacks(e);
        AdvancedEnhancer.emitSetStaticCallbacks(e);
        this.emitBindCallbacks(e);
        if (this.useFactory) {
            int[] keys = this.getCallbackKeys();
            AdvancedEnhancer.emitNewInstanceCallbacks(e);
            this.emitNewInstanceCallback(e);
            AdvancedEnhancer.emitNewInstanceMultiarg(e, constructorInfo);
            AdvancedEnhancer.emitGetCallback(e, keys);
            this.emitSetCallback(e, keys);
            this.emitGetCallbacks(e);
            this.emitSetCallbacks(e);
        }
        e.end_class();
    }

    private static boolean isJdk8DefaultMethod(Method method) {
        return (method.getModifiers() & 0x409) == 1 && method.getDeclaringClass().isInterface();
    }

    private static void removeAllCovariantMethods(List<Method> actualMethods, Method method, Map<Method, Method> covariantMethods) {
        if ((method.getModifiers() & 0x1000) != 0) {
            return;
        }
        Iterator<Method> it = actualMethods.iterator();
        while (it.hasNext()) {
            Method actualMethod = it.next();
            if (actualMethod.equals(method) || !actualMethod.getName().equals(method.getName()) || !Arrays.equals(actualMethod.getParameterTypes(), method.getParameterTypes()) || !ReflectionUtil.isAssignable(actualMethod.getReturnType(), method.getReturnType())) continue;
            if ((actualMethod.getModifiers() & 0x400) != 0 || (actualMethod.getModifiers() & 0x1000) != 0) {
                covariantMethods.put(actualMethod, method);
                continue;
            }
            it.remove();
        }
    }

    private static void filterConstructors(Class<?> sc, List<Constructor<?>> constructors) {
        CollectionUtils.filter(constructors, new VisibilityPredicate(sc, true));
        if (constructors.isEmpty()) {
            throw new IllegalArgumentException("No visible constructors in " + String.valueOf(sc));
        }
    }

    @Override
    protected Object firstInstance(Class type) {
        if (this.classOnly) {
            return type;
        }
        return this.createUsingReflection(type);
    }

    @Override
    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        if (instance instanceof Factory) {
            if (this.argumentTypes != null) {
                return ((Factory)instance).newInstance(this.argumentTypes, this.arguments, this.callbacks);
            }
            return ((Factory)instance).newInstance(this.callbacks);
        }
        return this.createUsingReflection(protoclass);
    }

    private static void setThreadCallbacks(Class<?> type, Callback[] callbacks) {
        AdvancedEnhancer.setCallbacksHelper(type, callbacks, SET_THREAD_CALLBACKS_NAME);
    }

    private static void setCallbacksHelper(Class<?> type, Callback[] callbacks, String methodName) {
        try {
            Method setter = AdvancedEnhancer.getCallbacksSetter(type, methodName);
            setter.invoke(null, new Object[]{callbacks});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not an enhanced class");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CodeGenerationException(e);
        }
    }

    private static Method getCallbacksSetter(Class<?> type, String methodName) throws NoSuchMethodException {
        return type.getDeclaredMethod(methodName, Callback[].class);
    }

    private Object createUsingReflection(Class<?> type) {
        AdvancedEnhancer.setThreadCallbacks(type, this.callbacks);
        try {
            if (this.argumentTypes != null) {
                Object object = ReflectUtils.newInstance(type, this.argumentTypes, this.arguments);
                return object;
            }
            Object object = ReflectUtils.newInstance(type);
            return object;
        }
        finally {
            AdvancedEnhancer.setThreadCallbacks(type, null);
        }
    }

    private void emitConstructors(ClassEmitter ce, List<? extends MethodInfo> constructors) {
        boolean seenNull = false;
        for (MethodInfo methodInfo : constructors) {
            CodeEmitter e = EmitUtils.begin_method(ce, methodInfo, 1);
            e.load_this();
            e.dup();
            e.load_args();
            Signature sig = methodInfo.getSignature();
            seenNull = seenNull || sig.getDescriptor().equals("()V");
            e.super_invoke_constructor(sig);
            e.invoke_static_this(BIND_CALLBACKS);
            if (!this.interceptDuringConstruction) {
                e.load_this();
                e.push(1);
                e.putfield(CONSTRUCTED_FIELD);
            }
            e.return_value();
            e.end_method();
        }
        if (!this.classOnly && !seenNull && this.arguments == null) {
            throw new IllegalArgumentException("Superclass has no null constructors but no arguments were given");
        }
    }

    private int[] getCallbackKeys() {
        int[] keys = new int[this.callbackTypes.length];
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            keys[i] = i;
        }
        return keys;
    }

    private static void emitGetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.begin_method(1, GET_CALLBACK, null);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, $Label end) {
                e.getfield(AdvancedEnhancer.getCallbackField(key));
                e.goTo(end);
            }

            @Override
            public void processDefault() {
                e.pop();
                e.aconst_null();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e = ce.begin_method(1, SET_CALLBACK, null);
        e.load_this();
        e.load_arg(1);
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, $Label end) {
                e.checkcast(AdvancedEnhancer.this.callbackTypes[key]);
                e.putfield(AdvancedEnhancer.getCallbackField(key));
                e.goTo(end);
            }

            @Override
            public void processDefault() {
                $Type type = $Type.getType(AssertionError.class);
                e.new_instance(type);
                e.dup();
                e.invoke_constructor(type);
                e.athrow();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, SET_CALLBACKS, null);
        e.load_this();
        e.load_arg(0);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup2();
            e.aaload(i);
            e.checkcast(this.callbackTypes[i]);
            e.putfield(AdvancedEnhancer.getCallbackField(i));
        }
        e.return_value();
        e.end_method();
    }

    private void emitGetCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, GET_CALLBACKS, null);
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.push(this.callbackTypes.length);
        e.newarray(CALLBACK);
        for (int i = 0; i < this.callbackTypes.length; ++i) {
            e.dup();
            e.push(i);
            e.load_this();
            e.getfield(AdvancedEnhancer.getCallbackField(i));
            e.aastore();
        }
        e.return_value();
        e.end_method();
    }

    private static void emitNewInstanceCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, NEW_INSTANCE, null);
        e.load_arg(0);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        AdvancedEnhancer.emitCommonNewInstance(e);
    }

    private static void emitCommonNewInstance(CodeEmitter e) {
        e.new_instance_this();
        e.dup();
        e.invoke_constructor_this();
        e.aconst_null();
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallback(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, SINGLE_NEW_INSTANCE, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                e.push(1);
                e.newarray(CALLBACK);
                e.dup();
                e.push(0);
                e.load_arg(0);
                e.aastore();
                e.invoke_static_this(SET_THREAD_CALLBACKS);
                break;
            }
            default: {
                e.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        AdvancedEnhancer.emitCommonNewInstance(e);
    }

    private static void emitNewInstanceMultiarg(ClassEmitter ce, List<MethodInfo> constructors) {
        final CodeEmitter e = ce.begin_method(1, MULTIARG_NEW_INSTANCE, null);
        e.load_arg(2);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        e.new_instance_this();
        e.dup();
        e.load_arg(0);
        EmitUtils.constructor_switch(e, constructors, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, $Label end) {
                MethodInfo constructor = (MethodInfo)key;
                $Type[] types = constructor.getSignature().getArgumentTypes();
                for (int i = 0; i < types.length; ++i) {
                    e.load_arg(1);
                    e.push(i);
                    e.aaload();
                    e.unbox(types[i]);
                }
                e.invoke_constructor_this(constructor.getSignature());
                e.goTo(end);
            }

            @Override
            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e.aconst_null();
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        e.return_value();
        e.end_method();
    }

    private void emitMethods(ClassEmitter ce, Map<Method, MethodInfo> methodMap, Map<Method, Method> covariantMethods) {
        CallbackGenerator[] generators = CallbackInfo.getGenerators(this.callbackTypes);
        HashMap<MethodInfo, MethodInfo> covariantInfoMap = new HashMap<MethodInfo, MethodInfo>();
        for (Method method : methodMap.keySet()) {
            Method delegate = covariantMethods.get(method);
            if (delegate == null) continue;
            covariantInfoMap.put(methodMap.get(method), ReflectUtils.getMethodInfo(delegate, delegate.getModifiers()));
        }
        BridgeMethodGenerator bridgeMethodGenerator = new BridgeMethodGenerator(covariantInfoMap);
        HashMap<BridgeMethodGenerator, ArrayList<MethodInfo>> groups = new HashMap<BridgeMethodGenerator, ArrayList<MethodInfo>>();
        final HashMap<MethodInfo, Integer> indexes = new HashMap<MethodInfo, Integer>();
        final HashMap<MethodInfo, Integer> originalModifiers = new HashMap<MethodInfo, Integer>();
        final Map positions = CollectionUtils.getIndexMap(new ArrayList<MethodInfo>(methodMap.values()));
        for (Method actualMethod : methodMap.keySet()) {
            MethodInfo method = methodMap.get(actualMethod);
            int index = this.filter.accept(actualMethod);
            if (index >= this.callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            originalModifiers.put(method, actualMethod != null ? actualMethod.getModifiers() : method.getModifiers());
            indexes.put(method, index);
            BridgeMethodGenerator generator = covariantMethods.containsKey(actualMethod) ? bridgeMethodGenerator : generators[index];
            ArrayList<MethodInfo> group = (ArrayList<MethodInfo>)groups.get(generator);
            if (group == null) {
                group = new ArrayList<MethodInfo>(methodMap.size());
                groups.put(generator, group);
            }
            group.add(method);
        }
        CodeEmitter se = ce.getStaticHook();
        se.new_instance(THREAD_LOCAL);
        se.dup();
        se.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
        se.putfield(THREAD_CALLBACKS_FIELD);
        CallbackGenerator.Context context = new CallbackGenerator.Context(){

            @Override
            public ClassLoader getClassLoader() {
                return AdvancedEnhancer.this.getClassLoader();
            }

            @Override
            public int getOriginalModifiers(MethodInfo method) {
                return (Integer)originalModifiers.get(method);
            }

            @Override
            public int getIndex(MethodInfo method) {
                return (Integer)indexes.get(method);
            }

            @Override
            public void emitCallback(CodeEmitter e, int index) {
                AdvancedEnhancer.emitCurrentCallback(e, index);
            }

            @Override
            public Signature getImplSignature(MethodInfo method) {
                return AdvancedEnhancer.rename(method.getSignature(), (Integer)positions.get(method));
            }

            @Override
            public void emitLoadArgsAndInvoke(CodeEmitter emitter, MethodInfo info) {
                emitter.super_invoke(info.getSignature());
            }

            @Override
            public CodeEmitter beginMethod(ClassEmitter ce, MethodInfo method) {
                CodeEmitter e = EmitUtils.begin_method(ce, method);
                if (!AdvancedEnhancer.this.interceptDuringConstruction && !TypeUtils.isAbstract(method.getModifiers())) {
                    $Label constructed = e.make_label();
                    e.load_this();
                    e.getfield(AdvancedEnhancer.CONSTRUCTED_FIELD);
                    e.if_jump(154, constructed);
                    e.load_this();
                    e.load_args();
                    e.super_invoke();
                    e.return_value();
                    e.mark(constructed);
                }
                return e;
            }
        };
        HashSet<BridgeMethodGenerator> seenGen = new HashSet<BridgeMethodGenerator>();
        for (int i = 0; i < this.callbackTypes.length + 1; ++i) {
            BridgeMethodGenerator gen;
            CallbackGenerator callbackGenerator = gen = i == this.callbackTypes.length ? bridgeMethodGenerator : generators[i];
            if (seenGen.contains(gen)) continue;
            seenGen.add(gen);
            List fmethods = (List)groups.get(gen);
            if (fmethods == null) continue;
            try {
                gen.generate(ce, context, fmethods);
                gen.generateStatic(se, context, fmethods);
                continue;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new CodeGenerationException(x);
            }
        }
        se.return_value();
        se.end_method();
    }

    private static void emitSetThreadCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, SET_THREAD_CALLBACKS, null);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.load_arg(0);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        e.return_value();
        e.end_method();
    }

    private static void emitSetStaticCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(9, SET_STATIC_CALLBACKS, null);
        e.load_arg(0);
        e.putfield(STATIC_CALLBACKS_FIELD);
        e.return_value();
        e.end_method();
    }

    private static void emitCurrentCallback(CodeEmitter e, int index) {
        e.load_this();
        e.getfield(AdvancedEnhancer.getCallbackField(index));
        e.dup();
        $Label end = e.make_label();
        e.ifnonnull(end);
        e.pop();
        e.load_this();
        e.invoke_static_this(BIND_CALLBACKS);
        e.load_this();
        e.getfield(AdvancedEnhancer.getCallbackField(index));
        e.mark(end);
    }

    private void emitBindCallbacks(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(26, BIND_CALLBACKS, null);
        Local me = e.make_local();
        e.load_arg(0);
        e.checkcast_this();
        e.store_local(me);
        $Label end = e.make_label();
        e.load_local(me);
        e.getfield(BOUND_FIELD);
        e.if_jump(154, end);
        e.load_local(me);
        e.push(1);
        e.putfield(BOUND_FIELD);
        e.getfield(THREAD_CALLBACKS_FIELD);
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e.dup();
        $Label found_callback = e.make_label();
        e.ifnonnull(found_callback);
        e.pop();
        e.getfield(STATIC_CALLBACKS_FIELD);
        e.dup();
        e.ifnonnull(found_callback);
        e.pop();
        e.goTo(end);
        e.mark(found_callback);
        e.checkcast(CALLBACK_ARRAY);
        e.load_local(me);
        e.swap();
        for (int i = this.callbackTypes.length - 1; i >= 0; --i) {
            if (i != 0) {
                e.dup2();
            }
            e.aaload(i);
            e.checkcast(this.callbackTypes[i]);
            e.putfield(AdvancedEnhancer.getCallbackField(i));
        }
        e.mark(end);
        e.return_value();
        e.end_method();
    }

    private static String getCallbackField(int index) {
        return "CGLIB$CALLBACK_" + index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sf/cglib/proxy/AdvancedEnhancer", "createKey"));
    }
}

