/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchManager;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.vcs.log.VcsUser;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsOptions;
import git4idea.config.UpdateMethod;
import git4idea.push.GitPushTagMode;
import git4idea.reset.GitResetMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Git.Settings", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class GitVcsSettings
extends SimplePersistentStateComponent<GitVcsOptions>
implements DvcsSyncSettings,
DvcsCompareSettings {
    private static final int PREVIOUS_COMMIT_AUTHORS_LIMIT = 16;
    private final Project project;

    public GitVcsSettings(Project project) {
        super((BaseState)new GitVcsOptions());
        this.project = project;
    }

    public GitVcsApplicationSettings getAppSettings() {
        return GitVcsApplicationSettings.getInstance();
    }

    public static GitVcsSettings getInstance(Project project) {
        return (GitVcsSettings)((Object)project.getService(GitVcsSettings.class));
    }

    @NotNull
    public UpdateMethod getUpdateMethod() {
        UpdateMethod updateMethod = ((GitVcsOptions)this.getState()).getUpdateMethod();
        if (updateMethod == null) {
            GitVcsSettings.$$$reportNull$$$0(0);
        }
        return updateMethod;
    }

    public void setUpdateMethod(UpdateMethod updateType) {
        ((GitVcsOptions)this.getState()).setUpdateMethod(updateType);
    }

    @NotNull
    public GitSaveChangesPolicy getSaveChangesPolicy() {
        GitSaveChangesPolicy gitSaveChangesPolicy = ((GitVcsOptions)this.getState()).getSaveChangesPolicy();
        if (gitSaveChangesPolicy == null) {
            GitVcsSettings.$$$reportNull$$$0(1);
        }
        return gitSaveChangesPolicy;
    }

    public void setSaveChangesPolicy(GitSaveChangesPolicy value) {
        ((GitVcsOptions)this.getState()).setSaveChangesPolicy(value);
    }

    public void saveCommitAuthor(@NotNull VcsUser author) {
        if (author == null) {
            GitVcsSettings.$$$reportNull$$$0(2);
        }
        List<String> previousCommitAuthors = ((GitVcsOptions)this.getState()).getPreviousCommitAuthors();
        previousCommitAuthors.remove(author.toString());
        while (previousCommitAuthors.size() >= 16) {
            previousCommitAuthors.remove(previousCommitAuthors.size() - 1);
        }
        previousCommitAuthors.add(0, author.toString());
    }

    public String[] getCommitAuthors() {
        return ArrayUtilRt.toStringArray(((GitVcsOptions)this.getState()).getPreviousCommitAuthors());
    }

    public void loadState(@NotNull GitVcsOptions state2) {
        if (state2 == null) {
            GitVcsSettings.$$$reportNull$$$0(3);
        }
        super.loadState((BaseState)state2);
        GitVcsSettings.migrateUpdateIncomingBranchInfo(state2);
    }

    private static void migrateUpdateIncomingBranchInfo(@NotNull GitVcsOptions state2) {
        if (state2 == null) {
            GitVcsSettings.$$$reportNull$$$0(4);
        }
        if (!state2.isUpdateBranchesInfo()) {
            state2.setIncomingCheckStrategy(GitIncomingCheckStrategy.Never);
            state2.setUpdateBranchesInfo(true);
        }
    }

    @Nullable
    public String getPathToGit() {
        return ((GitVcsOptions)this.getState()).getPathToGit();
    }

    public void setPathToGit(@Nullable String value) {
        ((GitVcsOptions)this.getState()).setPathToGit(value);
        GitExecutableDetector.fireExecutableChanged();
    }

    public boolean autoUpdateIfPushRejected() {
        return ((GitVcsOptions)this.getState()).isPushAutoUpdate();
    }

    public void setAutoUpdateIfPushRejected(boolean value) {
        ((GitVcsOptions)this.getState()).setPushAutoUpdate(value);
    }

    @NotNull
    public DvcsSyncSettings.Value getSyncSetting() {
        DvcsSyncSettings.Value value = ((GitVcsOptions)this.getState()).getRootSync();
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(5);
        }
        return value;
    }

    public void setSyncSetting(@NotNull DvcsSyncSettings.Value value) {
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(6);
        }
        ((GitVcsOptions)this.getState()).setRootSync(value);
    }

    @Nullable
    public String getRecentRootPath() {
        return ((GitVcsOptions)this.getState()).getRecentGitRootPath();
    }

    public void setRecentRoot(@NotNull String value) {
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(7);
        }
        ((GitVcsOptions)this.getState()).setRecentGitRootPath(value);
    }

    @NotNull
    public Map<String, String> getRecentBranchesByRepository() {
        Map<String, String> map2 = ((GitVcsOptions)this.getState()).getRecentBranchByRepository();
        if (map2 == null) {
            GitVcsSettings.$$$reportNull$$$0(8);
        }
        return map2;
    }

    public void setRecentBranchOfRepository(@NotNull String repositoryPath, @NotNull String branch) {
        if (repositoryPath == null) {
            GitVcsSettings.$$$reportNull$$$0(9);
        }
        if (branch == null) {
            GitVcsSettings.$$$reportNull$$$0(10);
        }
        ((GitVcsOptions)this.getState()).getRecentBranchByRepository().put(repositoryPath, branch);
    }

    @Nullable
    public String getRecentCommonBranch() {
        return ((GitVcsOptions)this.getState()).getRecentCommonBranch();
    }

    public void setRecentCommonBranch(@NotNull String value) {
        if (value == null) {
            GitVcsSettings.$$$reportNull$$$0(11);
        }
        ((GitVcsOptions)this.getState()).setRecentCommonBranch(value);
    }

    public boolean showRecentBranches() {
        return ((GitVcsOptions)this.getState()).getShowRecentBranches();
    }

    public void setShowRecentBranches(boolean value) {
        ((GitVcsOptions)this.getState()).setShowRecentBranches(value);
    }

    public boolean showTags() {
        return ((GitVcsOptions)this.getState()).getShowTags();
    }

    public void setShowTags(boolean value) {
        ((GitVcsOptions)this.getState()).setShowTags(value);
        ((DvcsBranchManager.DvcsBranchManagerListener)this.project.getMessageBus().syncPublisher(DvcsBranchManager.DVCS_BRANCH_SETTINGS_CHANGED)).showTagsSettingsChanged(value);
    }

    public boolean filterByActionInPopup() {
        return ((GitVcsOptions)this.getState()).getFilterByActionInPopup();
    }

    public void setFilterByActionInPopup(boolean value) {
        ((GitVcsOptions)this.getState()).setFilterByActionInPopup(value);
    }

    public boolean filterByRepositoryInPopup() {
        return ((GitVcsOptions)this.getState()).getFilterByRepositoryInPopup();
    }

    public void setFilterByRepositoryInPopup(boolean value) {
        ((GitVcsOptions)this.getState()).setFilterByRepositoryInPopup(value);
    }

    public boolean warnAboutCrlf() {
        return ((GitVcsOptions)this.getState()).getWarnAboutCrlf();
    }

    public void setWarnAboutCrlf(boolean value) {
        ((GitVcsOptions)this.getState()).setWarnAboutCrlf(value);
    }

    public boolean warnAboutDetachedHead() {
        return ((GitVcsOptions)this.getState()).isWarnAboutDetachedHead();
    }

    public void setWarnAboutDetachedHead(boolean value) {
        ((GitVcsOptions)this.getState()).setWarnAboutDetachedHead(value);
    }

    public boolean warnAboutLargeFiles() {
        return ((GitVcsOptions)this.getState()).isWarnAboutLargeFiles();
    }

    public void setWarnAboutLargeFiles(boolean value) {
        ((GitVcsOptions)this.getState()).setWarnAboutLargeFiles(value);
    }

    public boolean warnAboutBadFileNames() {
        return ((GitVcsOptions)this.getState()).isWarnAboutBadFileNames();
    }

    public void setWarnAboutLargeFilesLimitMb(int value) {
        ((GitVcsOptions)this.getState()).setWarnAboutLargeFilesLimitMb(value);
    }

    public int getWarnAboutLargeFilesLimitMb() {
        return ((GitVcsOptions)this.getState()).getWarnAboutLargeFilesLimitMb();
    }

    public void setWarnAboutBadFileNames(boolean value) {
        ((GitVcsOptions)this.getState()).setWarnAboutBadFileNames(value);
    }

    @Nullable
    public GitResetMode getResetMode() {
        return ((GitVcsOptions)this.getState()).getResetMode();
    }

    public void setResetMode(@NotNull GitResetMode mode) {
        if (mode == null) {
            GitVcsSettings.$$$reportNull$$$0(12);
        }
        ((GitVcsOptions)this.getState()).setResetMode(mode);
    }

    @Nullable
    public GitPushTagMode getPushTagMode() {
        return ((GitVcsOptions)this.getState()).getPushTags();
    }

    public void setPushTagMode(@Nullable GitPushTagMode value) {
        ((GitVcsOptions)this.getState()).setPushTags(value);
    }

    public boolean shouldSignOffCommit() {
        return ((GitVcsOptions)this.getState()).isSignOffCommit();
    }

    public void setSignOffCommit(boolean value) {
        ((GitVcsOptions)this.getState()).setSignOffCommit(value);
    }

    @NotNull
    public GitIncomingCheckStrategy getIncomingCheckStrategy() {
        GitIncomingCheckStrategy gitIncomingCheckStrategy = ((GitVcsOptions)this.getState()).getIncomingCheckStrategy();
        if (gitIncomingCheckStrategy == null) {
            GitVcsSettings.$$$reportNull$$$0(13);
        }
        return gitIncomingCheckStrategy;
    }

    public void setIncomingCheckStrategy(@NotNull GitIncomingCheckStrategy strategy) {
        if (strategy == null) {
            GitVcsSettings.$$$reportNull$$$0(14);
        }
        ((GitVcsOptions)this.getState()).setIncomingCheckStrategy(strategy);
    }

    public boolean shouldPreviewPushOnCommitAndPush() {
        return ((GitVcsOptions)this.getState()).isPreviewPushOnCommitAndPush();
    }

    public void setPreviewPushOnCommitAndPush(boolean value) {
        ((GitVcsOptions)this.getState()).setPreviewPushOnCommitAndPush(value);
    }

    public boolean isPreviewPushProtectedOnly() {
        return ((GitVcsOptions)this.getState()).isPreviewPushProtectedOnly();
    }

    public void setPreviewPushProtectedOnly(boolean value) {
        ((GitVcsOptions)this.getState()).setPreviewPushProtectedOnly(value);
    }

    public boolean isCommitRenamesSeparately() {
        return ((GitVcsOptions)this.getState()).isCommitRenamesSeparately();
    }

    public void setCommitRenamesSeparately(boolean value) {
        ((GitVcsOptions)this.getState()).setCommitRenamesSeparately(value);
    }

    @NotNull
    public DvcsBranchSettings getBranchSettings() {
        DvcsBranchSettings dvcsBranchSettings = ((GitVcsOptions)this.getState()).getBranchSettings();
        if (dvcsBranchSettings == null) {
            GitVcsSettings.$$$reportNull$$$0(15);
        }
        return dvcsBranchSettings;
    }

    public boolean shouldSetUserNameGlobally() {
        return ((GitVcsOptions)this.getState()).isSetUserNameGlobally();
    }

    public void setUserNameGlobally(boolean value) {
        ((GitVcsOptions)this.getState()).setSetUserNameGlobally(value);
    }

    public boolean shouldSwapSidesInCompareBranches() {
        return ((GitVcsOptions)this.getState()).isSwapSidesInCompareBranches();
    }

    public void setSwapSidesInCompareBranches(boolean value) {
        ((GitVcsOptions)this.getState()).setSwapSidesInCompareBranches(value);
    }

    public boolean shouldAddSuffixToCherryPicksOfPublishedCommits() {
        return ((GitVcsOptions)this.getState()).isAddSuffixToCherryPicksOfPublishedCommits();
    }

    public void setAddSuffixToCherryPicks(boolean value) {
        ((GitVcsOptions)this.getState()).setAddSuffixToCherryPicksOfPublishedCommits(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 9, 10, 11, 12, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitVcsSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaveChangesPolicy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitVcsSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncSetting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentBranchesByRepository";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncomingCheckStrategy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveCommitAuthor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "migrateUpdateIncomingBranchInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSyncSetting";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRecentRoot";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRecentBranchOfRepository";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setRecentCommonBranch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setResetMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIncomingCheckStrategy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 9, 10, 11, 12, 14 -> new IllegalArgumentException(string);
        };
    }

    @Tag(value="push-target-info")
    private static class PushTargetInfo
    extends DvcsBranchInfo {
        @Attribute(value="target-remote")
        public String targetRemoteName;
        @Attribute(value="target-branch")
        public String targetBranchName;

        PushTargetInfo() {
            this("", "", "", "");
        }

        PushTargetInfo(@NotNull String repositoryPath, @NotNull String source, @NotNull String targetRemote, @NotNull String targetBranch) {
            if (repositoryPath == null) {
                PushTargetInfo.$$$reportNull$$$0(0);
            }
            if (source == null) {
                PushTargetInfo.$$$reportNull$$$0(1);
            }
            if (targetRemote == null) {
                PushTargetInfo.$$$reportNull$$$0(2);
            }
            if (targetBranch == null) {
                PushTargetInfo.$$$reportNull$$$0(3);
            }
            super(repositoryPath, source);
            this.targetRemoteName = targetRemote;
            this.targetBranchName = targetBranch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushTargetInfo info = (PushTargetInfo)((Object)o);
            if (this.targetRemoteName != null ? !this.targetRemoteName.equals(info.targetRemoteName) : info.targetRemoteName != null) {
                return false;
            }
            return !(this.targetBranchName != null ? !this.targetBranchName.equals(info.targetBranchName) : info.targetBranchName != null);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.targetRemoteName, this.targetBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetRemote";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetBranch";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitVcsSettings$PushTargetInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

