/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.StashInfo;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a2\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a*\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\r\u001a=\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0018\"\u00020\r\u00a2\u0006\u0002\u0010\u0019\u001a4\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u0002\u001a\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "loadStashStack", "", "Lgit4idea/ui/StashInfo;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "createUnstashHandler", "Lgit4idea/commands/GitLineHandler;", "stash", "branch", "", "popStash", "", "reinstateIndex", "createStashHandler", "keepIndex", "message", "files", "", "Lcom/intellij/openapi/vcs/FilePath;", "parameters", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Collection;[Ljava/lang/String;)Lgit4idea/commands/GitLineHandler;", "refreshStash", "", "intellij.vcs.git"})
@JvmName(name="GitStashUtils")
@SourceDebugExtension(value={"SMAP\nGitStashUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashUtils.kt\ngit4idea/stash/GitStashUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,466:1\n1187#2,2:467\n1261#2,4:469\n1557#2:475\n1628#2,3:476\n15#3:473\n15#3:474\n*S KotlinDebug\n*F\n+ 1 GitStashUtils.kt\ngit4idea/stash/GitStashUtils\n*L\n374#1:467,2\n374#1:469,4\n399#1:475\n399#1:476,3\n388#1:473\n394#1:474\n*E\n"})
public final class GitStashUtils {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StashInfo> loadStashStack(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitLogParser.GitLogOption[] gitLogOptionArray = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR, GitLogParser.GitLogOption.SUBJECT};
        GitLogParser.GitLogOption[] options = gitLogOptionArray;
        Iterable $this$associate$iv = ArraysKt.withIndex((Object[])options);
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = new Pair(it.getValue(), (Object)it.getIndex());
            map2.put(it.getFirst(), it.getSecond());
        }
        Map indexedOptions = destination$iv$iv;
        Charset charset = GitConfigUtil.getLogEncodingCharset(project, root);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getLogEncodingCharset(...)");
        Charset charset2 = charset;
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STASH.readLockingCommand());
        h.setSilent(true);
        String[] capacity$iv22 = new String[]{"list", "--pretty=format:" + GitLogParser.makeFormatFromOptions(options, ":")};
        h.addParameters(capacity$iv22);
        h.setCharset(charset2);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(h);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult output2 = gitCommandResult;
        output2.throwOnError(new int[0]);
        List result2 = new ArrayList();
        for (String line : output2.getOutput()) {
            Hash hash;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNull((Object)line);
            char[] element$iv$iv = new char[]{':'};
            List parts = StringsKt.split$default((CharSequence)line, (char[])element$iv$iv, (boolean)false, (int)(options.length + 1), (int)2, null);
            if (parts.size() < options.length) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Can't parse stash record: " + line);
                continue;
            }
            String[] stringArray = new String[]{" "};
            List parents = StringsKt.split$default((CharSequence)((CharSequence)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.PARENTS))).intValue())), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parents.isEmpty()) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Can't parse stash record parents: " + line);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)((String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.HASH))).intValue()))), (String)"build(...)");
            Iterable $this$map$iv = parents.subList(1, parents.size());
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(HashImpl.build((String)it));
            }
            List parentHashes = (List)destination$iv$iv2;
            long authorTime = GitLogUtil.parseTime((String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.AUTHOR_TIME))).intValue()));
            String stash = (String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR))).intValue());
            String branch = parts.size() == options.length ? null : ((Object)StringsKt.trim((CharSequence)((String)parts.get(((Number)MapsKt.getValue((Map)indexedOptions, (Object)((Object)GitLogParser.GitLogOption.SUBJECT))).intValue())))).toString();
            String message = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.last((List)parts)))).toString();
            result2.add(new StashInfo(root, hash, parentHashes, authorTime, stash, branch, message));
        }
        return result2;
    }

    private static final GitLineHandler createUnstashHandler(Project project, StashInfo stash, String branch, boolean popStash, boolean reinstateIndex) {
        GitLineHandler h = new GitLineHandler(project, stash.getRoot(), GitCommand.STASH);
        String[] stringArray = (String[])branch;
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
            stringArray = new String[]{popStash ? "pop" : "apply"};
            h.addParameters(stringArray);
            if (reinstateIndex) {
                stringArray = new String[]{"--index"};
                h.addParameters(stringArray);
            }
        } else {
            stringArray = new String[]{"branch", branch};
            h.addParameters(stringArray);
        }
        stringArray = new String[]{stash.getStash()};
        h.addParameters(stringArray);
        return h;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GitLineHandler createStashHandler(@NotNull Project project, @NotNull VirtualFile root, boolean keepIndex, @NotNull String message) {
        String msg;
        void $this$createStashHandler_u24lambda_u242;
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List list2 = list = CollectionsKt.createListBuilder();
        Collection collection = CollectionsKt.emptyList();
        VirtualFile virtualFile = root;
        Project project2 = project;
        boolean bl = false;
        if (keepIndex) {
            $this$createStashHandler_u24lambda_u242.add("--keep-index");
        }
        if (((CharSequence)(msg = ((Object)StringsKt.trim((CharSequence)message)).toString())).length() > 0) {
            $this$createStashHandler_u24lambda_u242.add("--message");
            $this$createStashHandler_u24lambda_u242.add(msg);
        }
        Unit unit = Unit.INSTANCE;
        return GitStashUtils.createStashHandler(project2, virtualFile, (Collection<? extends FilePath>)collection, CollectionsKt.build((List)list));
    }

    public static /* synthetic */ GitLineHandler createStashHandler$default(Project project, VirtualFile virtualFile, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = "";
        }
        return GitStashUtils.createStashHandler(project, virtualFile, bl, string);
    }

    @NotNull
    public static final GitLineHandler createStashHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends FilePath> files, String ... parameters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return GitStashUtils.createStashHandler(project, root, files, ArraysKt.toList((Object[])parameters));
    }

    private static final GitLineHandler createStashHandler(Project project, VirtualFile root, Collection<? extends FilePath> files, List<String> parameters) {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.STASH);
        String[] stringArray = new String[]{"push"};
        handler.addParameters(stringArray);
        handler.addParameters(parameters);
        if (!files.isEmpty()) {
            if (GitVersionSpecialty.STASH_PUSH_PATHSPEC_FROM_FILE_SUPPORTED.existsIn(GitExecutableManager.getInstance().getVersion(project))) {
                stringArray = new String[]{"--pathspec-from-file=-"};
                handler.addParameters(stringArray);
                handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(VcsFileUtil.toRelativePaths((VirtualFile)root, files), "\n", handler.getCharset(), false));
            } else {
                handler.endOptions();
                handler.addRelativePaths(files);
            }
        }
        return handler;
    }

    public static final void refreshStash(@NotNull Project project, @NotNull VirtualFile root) {
        File reflogFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object object = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick(root);
        File file = object != null && (object = object.getRepositoryFiles()) != null ? ((GitRepositoryFiles)object).getStashReflogFile() : (reflogFile = null);
        if (reflogFile != null) {
            File[] fileArray = new File[]{reflogFile};
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (File[])fileArray);
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ GitLineHandler access$createUnstashHandler(Project project, StashInfo stash, String branch, boolean popStash, boolean reinstateIndex) {
        return GitStashUtils.createUnstashHandler(project, stash, branch, popStash, reinstateIndex);
    }

    static {
        Logger logger = Logger.getInstance((String)"#git4idea.stash.GitStashUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

