/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.popup;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchesDivergedBanner;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.GitReference;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.branch.GitRefType;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitBranchPopupFetchAction;
import git4idea.ui.branch.popup.GitBranchesTreePopupBase;
import git4idea.ui.branch.popup.GitBranchesTreePopupFilterByAction;
import git4idea.ui.branch.popup.GitBranchesTreePopupFilterByRepository;
import git4idea.ui.branch.popup.GitBranchesTreePopupRenderer;
import git4idea.ui.branch.popup.GitBranchesTreePopupStep;
import git4idea.ui.branch.popup.GitBranchesTreePopupStepBase;
import git4idea.ui.branch.tree.GitBranchesTreeModel;
import git4idea.ui.branch.tree.GitBranchesTreeRenderer;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0014J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0014J\b\u0010#\u001a\u00020\rH\u0014\u00a8\u0006%"}, d2={"Lgit4idea/ui/branch/popup/GitBranchesTreePopup;", "Lgit4idea/ui/branch/popup/GitBranchesTreePopupBase;", "Lgit4idea/ui/branch/popup/GitBranchesTreePopupStep;", "project", "Lcom/intellij/openapi/project/Project;", "step", "parent", "Lcom/intellij/openapi/ui/popup/JBPopup;", "parentValue", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/popup/GitBranchesTreePopupStep;Lcom/intellij/openapi/ui/popup/JBPopup;Ljava/lang/Object;)V", "getSearchFiledEmptyText", "", "warnThatBranchesDivergedIfNeeded", "", "getTreeEmptyText", "searchPattern", "handleIconClick", "", "userObject", "toggleFavorite", "installGeneralShortcutActions", "getHeaderToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createNextStepPopup", "Lcom/intellij/ui/popup/WizardPopup;", "nextStep", "Lcom/intellij/openapi/ui/popup/PopupStep;", "createRenderer", "Lgit4idea/ui/branch/tree/GitBranchesTreeRenderer;", "treeStep", "createWarning", "Ljavax/swing/JComponent;", "text", "getShortcutActionPlace", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchesTreePopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesTreePopup.kt\ngit4idea/ui/branch/popup/GitBranchesTreePopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1#2:148\n31#3,2:149\n1755#4,3:151\n1863#4,2:154\n*S KotlinDebug\n*F\n+ 1 GitBranchesTreePopup.kt\ngit4idea/ui/branch/popup/GitBranchesTreePopup\n*L\n81#1:149,2\n82#1:151,3\n83#1:154,2\n*E\n"})
public final class GitBranchesTreePopup
extends GitBranchesTreePopupBase<GitBranchesTreePopupStep> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DIMENSION_SERVICE_KEY = "Git.Branch.Popup";
    @Language(value="devkit-action-id")
    @NotNull
    private static final String HEADER_SETTINGS_ACTION_GROUP = "Git.Branches.Popup.Settings";

    public GitBranchesTreePopup(@NotNull Project project, @NotNull GitBranchesTreePopupStep step, @Nullable JBPopup parent, @Nullable Object parentValue) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        super(project, (GitBranchesTreePopupStepBase)step, parent, parentValue, DIMENSION_SERVICE_KEY);
        this.installGeneralShortcutActions();
        if (!this.isChild()) {
            this.warnThatBranchesDivergedIfNeeded();
        }
    }

    public /* synthetic */ GitBranchesTreePopup(Project project, GitBranchesTreePopupStep gitBranchesTreePopupStep, JBPopup jBPopup, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jBPopup = null;
        }
        if ((n & 8) != 0) {
            object = null;
        }
        this(project, gitBranchesTreePopupStep, jBPopup, object);
    }

    @Override
    @NotNull
    protected String getSearchFiledEmptyText() {
        String string;
        Object[] objectArray;
        String string2;
        Object object;
        int separatorKind;
        boolean isActionFilterSelected = GitBranchesTreePopupFilterByAction.Companion.isSelected(this.getProject());
        boolean isRepositoryFilterSelected = GitBranchesTreePopupFilterByRepository.Companion.isSelected(this.getProject());
        int n = separatorKind = isActionFilterSelected && isRepositoryFilterSelected ? 2 : 1;
        if (isActionFilterSelected) {
            object = new Object[]{separatorKind};
            string2 = GitBundle.message("git.branches.popup.search.field.actions.empty.text", object);
        } else {
            string2 = "";
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        String byActions = string3;
        if (isRepositoryFilterSelected) {
            objectArray = new Object[]{separatorKind};
            string = GitBundle.message("git.branches.popup.search.field.repositories.empty.text", objectArray);
        } else {
            string = "";
        }
        object = string;
        Intrinsics.checkNotNull((Object)object);
        Object byRepository = object;
        objectArray = new Object[]{byActions, byRepository};
        String string4 = GitBundle.message("git.branches.popup.search.field.empty.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        return string4;
    }

    private final void warnThatBranchesDivergedIfNeeded() {
        if (((GitBranchesTreePopupStep)this.getTreeStep()).isBranchesDiverged()) {
            this.setWarning(DvcsBundle.message((String)"branch.popup.warning.branches.have.diverged", (Object[])new Object[0]));
        }
    }

    @Override
    @NotNull
    protected String getTreeEmptyText(@Nullable String searchPattern) {
        String string;
        boolean filtersActive;
        boolean bl = filtersActive = GitBranchesTreePopupFilterByAction.Companion.isSelected(this.getProject()) || GitBranchesTreePopupFilterByRepository.Companion.isSelected(this.getProject());
        if (filtersActive) {
            Object[] objectArray = new Object[]{searchPattern};
            String string2 = GitBundle.message("git.branches.popup.tree.no.nodes", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{searchPattern};
            String string3 = GitBundle.message("git.branches.popup.tree.no.branches", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    @Override
    protected boolean handleIconClick(@Nullable Object userObject) {
        this.toggleFavorite(userObject);
        return true;
    }

    private final void toggleFavorite(Object userObject) {
        GitRepository repository;
        boolean bl;
        GitBranchManager branchManager;
        GitRefType branchType;
        List repositories;
        GitReference reference;
        block11: {
            Object object;
            block13: {
                block12: {
                    GitBranchesTreeModel.RefUnderRepository refUnderRepository = userObject instanceof GitBranchesTreeModel.RefUnderRepository ? (GitBranchesTreeModel.RefUnderRepository)userObject : null;
                    GitReference gitReference = userObject instanceof GitReference ? (GitReference)userObject : null;
                    if (gitReference == null) {
                        GitBranchesTreeModel.RefUnderRepository refUnderRepository2 = refUnderRepository;
                        gitReference = refUnderRepository2 != null ? refUnderRepository2.getRef() : null;
                        if (gitReference == null) {
                            return;
                        }
                    }
                    reference = gitReference;
                    object = refUnderRepository;
                    if (object == null || (object = ((GitBranchesTreeModel.RefUnderRepository)object).getRepository()) == null) break block12;
                    List p0 = object;
                    boolean bl2 = false;
                    List list = CollectionsKt.listOf(p0);
                    object = list;
                    if (list != null) break block13;
                }
                object = ((GitBranchesTreePopupStep)this.getTreeStep()).getAffectedRepositories$intellij_vcs_git();
            }
            repositories = object;
            branchType = GitRefType.Companion.of$default(GitRefType.Companion, reference, false, 2, null);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            branchManager = (GitBranchManager)((Object)object2);
            Iterable $this$any$iv = repositories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    repository = (GitRepository)element$iv;
                    boolean bl3 = false;
                    if (!(!branchManager.isFavorite(branchType, repository, reference.getName()))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean anyNotFavorite = bl;
        Iterable $this$forEach$iv = repositories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            repository = (GitRepository)element$iv;
            boolean bl4 = false;
            branchManager.setFavorite(branchType, repository, reference.getName(), anyNotFavorite);
        }
    }

    private final void installGeneralShortcutActions() {
        this.registerAction("toggle_favorite", KeyStroke.getKeyStroke("SPACE"), new AbstractAction(this){
            final /* synthetic */ GitBranchesTreePopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Object object;
                Object p0;
                Object object2 = this.this$0.getTree().getLastSelectedPathComponent();
                if (object2 != null) {
                    p0 = object2;
                    boolean bl = false;
                    object = TreeUtil.getUserObject((Object)p0);
                } else {
                    object = null;
                }
                Object object3 = object;
                GitBranchesTreePopup gitBranchesTreePopup = this.this$0;
                p0 = object3;
                boolean bl = false;
                GitBranchesTreePopup.access$toggleFavorite(gitBranchesTreePopup, p0);
            }
        });
    }

    @Override
    @NotNull
    public ActionToolbar getHeaderToolbar() {
        AnAction settingsGroup = this.getAm().getAction(HEADER_SETTINGS_ACTION_GROUP);
        ActionToolbar actionToolbar = new ActionToolbar[]{new GitBranchPopupFetchAction(((Object)((Object)this)).getClass()), settingsGroup};
        DefaultActionGroup toolbarGroup = new DefaultActionGroup((AnAction[])actionToolbar);
        ActionToolbar actionToolbar2 = this.getAm().createActionToolbar(GitBranchesTreePopupBase.Companion.getTOP_LEVEL_ACTION_PLACE$intellij_vcs_git(), (ActionGroup)toolbarGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar $this$getHeaderToolbar_u24lambda_u242 = actionToolbar = actionToolbar2;
        boolean bl = false;
        $this$getHeaderToolbar_u24lambda_u242.setTargetComponent(this.getContent());
        $this$getHeaderToolbar_u24lambda_u242.setReservePlaceAutoPopupIcon(false);
        $this$getHeaderToolbar_u24lambda_u242.getComponent().setOpaque(false);
        return actionToolbar;
    }

    @Override
    @NotNull
    protected WizardPopup createNextStepPopup(@Nullable PopupStep<?> nextStep, @NotNull Object parentValue) {
        WizardPopup wizardPopup;
        Intrinsics.checkNotNullParameter((Object)parentValue, (String)"parentValue");
        if (nextStep instanceof GitBranchesTreePopupStep) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            wizardPopup = new GitBranchesTreePopup(project, (GitBranchesTreePopupStep)nextStep, (JBPopup)this, parentValue);
        } else {
            WizardPopup wizardPopup2 = super.createPopup((WizardPopup)this, nextStep, parentValue);
            wizardPopup = wizardPopup2;
            Intrinsics.checkNotNullExpressionValue((Object)wizardPopup2, (String)"createPopup(...)");
        }
        return wizardPopup;
    }

    @Override
    @NotNull
    protected GitBranchesTreeRenderer createRenderer(@NotNull GitBranchesTreePopupStep treeStep) {
        Intrinsics.checkNotNullParameter((Object)treeStep, (String)"treeStep");
        return new GitBranchesTreePopupRenderer(treeStep);
    }

    @NotNull
    protected JComponent createWarning(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return (JComponent)DvcsBranchesDivergedBanner.Companion.create("reference.VersionControl.Git.SynchronousBranchControl", text2);
    }

    @Override
    @NotNull
    protected String getShortcutActionPlace() {
        return this.isChild() ? GitBranchesTreePopupStep.Companion.getSINGLE_REPOSITORY_ACTION_PLACE$intellij_vcs_git() : GitBranchesTreePopupBase.Companion.getTOP_LEVEL_ACTION_PLACE$intellij_vcs_git();
    }

    @JvmStatic
    public static final void show(@NotNull Project project, @Nullable GitRepository selectedRepository) {
        Companion.show(project, selectedRepository);
    }

    @JvmStatic
    @NotNull
    public static final JBPopup create(@NotNull Project project, @Nullable GitRepository selectedRepository) {
        return Companion.create(project, selectedRepository);
    }

    public static final /* synthetic */ void access$toggleFavorite(GitBranchesTreePopup $this, Object userObject) {
        $this.toggleFavorite(userObject);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/ui/branch/popup/GitBranchesTreePopup$Companion;", "", "<init>", "()V", "DIMENSION_SERVICE_KEY", "", "HEADER_SETTINGS_ACTION_GROUP", "show", "", "project", "Lcom/intellij/openapi/project/Project;", "selectedRepository", "Lgit4idea/repo/GitRepository;", "create", "Lcom/intellij/openapi/ui/popup/JBPopup;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void show(@NotNull Project project, @Nullable GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.create(project, selectedRepository).showCenteredInCurrentWindow(project);
        }

        @JvmStatic
        @NotNull
        public final JBPopup create(@NotNull Project project, @Nullable GitRepository selectedRepository) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List repositories = DvcsUtil.sortRepositories((Collection)GitRepositoryManager.getInstance(project).getRepositories());
            GitRepository selectedRepoIfNeeded = GitBranchActionsUtil.userWantsSyncControl(project) ? null : selectedRepository;
            Intrinsics.checkNotNull((Object)repositories);
            return (JBPopup)new GitBranchesTreePopup(project, new GitBranchesTreePopupStep(project, selectedRepoIfNeeded, repositories, true), null, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

