/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFileNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserRootNode;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class ChangesBrowserNode<T>
extends DefaultMutableTreeNode
implements UserDataHolderEx {
    public static final Tag IGNORED_FILES_TAG = new VcsBundleTag("changes.nodetitle.ignored.files");
    public static final Tag LOCKED_FOLDERS_TAG = new VcsBundleTag("changes.nodetitle.locked.folders");
    public static final Tag LOGICALLY_LOCKED_TAG = new VcsBundleTag("changes.nodetitle.logicallt.locked.folders");
    public static final Tag UNVERSIONED_FILES_TAG = new VcsBundleTag("changes.nodetitle.unversioned.files");
    public static final Tag MODIFIED_WITHOUT_EDITING_TAG = new VcsBundleTag("changes.nodetitle.modified.without.editing");
    public static final Tag SWITCHED_FILES_TAG = new VcsBundleTag("changes.nodetitle.switched.files");
    public static final Tag SWITCHED_ROOTS_TAG = new VcsBundleTag("changes.nodetitle.switched.roots");
    public static final Tag LOCALLY_DELETED_NODE_TAG = new VcsBundleTag("changes.nodetitle.locally.deleted.files");
    protected static final int CONFLICTS_SORT_WEIGHT = 0;
    protected static final int DEFAULT_CHANGE_LIST_SORT_WEIGHT = 1;
    protected static final int CHANGE_LIST_SORT_WEIGHT = 2;
    protected static final int REPOSITORY_SORT_WEIGHT = 3;
    protected static final int MODULE_SORT_WEIGHT = 4;
    protected static final int DIRECTORY_PATH_SORT_WEIGHT = 5;
    protected static final int FILE_PATH_SORT_WEIGHT = 6;
    protected static final int CHANGE_SORT_WEIGHT = 7;
    protected static final int VIRTUAL_FILE_SORT_WEIGHT = 8;
    protected static final int UNVERSIONED_SORT_WEIGHT = 9;
    protected static final int DEFAULT_SORT_WEIGHT = 10;
    protected static final int IGNORED_SORT_WEIGHT = 11;
    protected static final int DELETED_SORT_WEIGHT = 12;
    private static final Color UNKNOWN_COLOR = JBColor.marker((String)"ChangesBrowserNode::UNKNOWN_COLOR");
    public static final Convertor<TreePath, String> TO_TEXT_CONVERTER = path -> ((ChangesBrowserNode)path.getLastPathComponent()).getTextPresentation();
    private int myFileCount = -1;
    private int myDirectoryCount = -1;
    private boolean myHelper;
    @Nullable
    private Color myBackgroundColor = UNKNOWN_COLOR;
    private UserDataHolderBase myUserDataHolder;

    protected ChangesBrowserNode(T userObject) {
        super(userObject);
    }

    @ApiStatus.Internal
    @Nullable
    final Color getBackgroundColorCached() {
        Color backgroundColor = this.myBackgroundColor;
        return backgroundColor == UNKNOWN_COLOR ? null : backgroundColor;
    }

    @ApiStatus.Internal
    final boolean hasBackgroundColorCached() {
        Color backgroundColor = this.myBackgroundColor;
        return backgroundColor != UNKNOWN_COLOR;
    }

    @ApiStatus.Internal
    final boolean cacheBackgroundColor(@NotNull Project project) {
        Color backgroundColor;
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(0);
        }
        if ((backgroundColor = this.myBackgroundColor) != UNKNOWN_COLOR) {
            return false;
        }
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-318216, EA-829418");){
            backgroundColor = this.getBackgroundColor(project);
        }
        this.myBackgroundColor = backgroundColor;
        return backgroundColor != null;
    }

    @NotNull
    public static ChangesBrowserNode<?> createRoot() {
        ChangesBrowserRootNode root = new ChangesBrowserRootNode();
        root.markAsHelperNode();
        ChangesBrowserRootNode changesBrowserRootNode = root;
        if (changesBrowserRootNode == null) {
            ChangesBrowserNode.$$$reportNull$$$0(1);
        }
        return changesBrowserRootNode;
    }

    @NotNull
    public static ChangesBrowserNode<?> createChange(@Nullable Project project, @NotNull Change userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(2);
        }
        return new ChangesBrowserChangeNode(project, userObject, null);
    }

    @NotNull
    public static ChangesBrowserNode<?> createFile(@Nullable Project project, @NotNull VirtualFile userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(3);
        }
        return new ChangesBrowserFileNode(project, userObject);
    }

    @NotNull
    public static ChangesBrowserNode<?> createFilePath(@NotNull FilePath userObject, @Nullable FileStatus status) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(4);
        }
        return new ChangesBrowserFilePathNode(userObject, status);
    }

    @NotNull
    public static ChangesBrowserNode<?> createFilePath(@NotNull FilePath userObject) {
        if (userObject == null) {
            ChangesBrowserNode.$$$reportNull$$$0(5);
        }
        return ChangesBrowserNode.createFilePath(userObject, null);
    }

    @NotNull
    public static ChangesBrowserNode<?> createLogicallyLocked(@Nullable Project project, @NotNull VirtualFile file, @NotNull LogicalLock lock) {
        if (file == null) {
            ChangesBrowserNode.$$$reportNull$$$0(6);
        }
        if (lock == null) {
            ChangesBrowserNode.$$$reportNull$$$0(7);
        }
        return new ChangesBrowserLogicallyLockedFile(project, file, lock);
    }

    @NotNull
    public static ChangesBrowserNode<?> createLockedFolders(@NotNull Project project) {
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(8);
        }
        return new ChangesBrowserLockedFoldersNode(project);
    }

    @NotNull
    public static ChangesBrowserNode<?> createLocallyDeleted(@NotNull LocallyDeletedChange change) {
        if (change == null) {
            ChangesBrowserNode.$$$reportNull$$$0(9);
        }
        return new ChangesBrowserLocallyDeletedNode(change);
    }

    @Override
    public ChangesBrowserNode<?> getParent() {
        return (ChangesBrowserNode)super.getParent();
    }

    @Nullable
    public <V> V getUserData(@NotNull Key<V> key) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(10);
        }
        return (V)((holder = this.myUserDataHolder) == null ? null : holder.getUserData(key));
    }

    public <V> void putUserData(@NotNull Key<V> key, @Nullable V value) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(11);
        }
        if ((holder = this.myUserDataHolder) == null) {
            this.myUserDataHolder = holder = new UserDataHolderBase();
        }
        holder.putUserData(key, value);
    }

    @NotNull
    public <V> V putUserDataIfAbsent(@NotNull Key<V> key, @NotNull V value) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(12);
        }
        if (value == null) {
            ChangesBrowserNode.$$$reportNull$$$0(13);
        }
        if ((holder = this.myUserDataHolder) == null) {
            this.myUserDataHolder = holder = new UserDataHolderBase();
        }
        Object object = holder.putUserDataIfAbsent(key, value);
        if (object == null) {
            ChangesBrowserNode.$$$reportNull$$$0(14);
        }
        return (V)object;
    }

    public <V> boolean replace(@NotNull Key<V> key, @Nullable V oldValue, @Nullable V newValue) {
        UserDataHolderBase holder;
        if (key == null) {
            ChangesBrowserNode.$$$reportNull$$$0(15);
        }
        if ((holder = this.myUserDataHolder) == null) {
            this.myUserDataHolder = holder = new UserDataHolderBase();
        }
        return holder.replace(key, oldValue, newValue);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.resetCounters();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.resetCounters();
    }

    protected boolean isFile() {
        return false;
    }

    protected boolean isDirectory() {
        return false;
    }

    public final void markAsHelperNode() {
        this.myHelper = true;
    }

    public boolean isMeaningfulNode() {
        return !this.myHelper;
    }

    public int getFileCount() {
        if (this.myFileCount == -1) {
            this.myFileCount = (this.isFile() ? 1 : 0) + this.sumForChildren(ChangesBrowserNode::getFileCount);
        }
        return this.myFileCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = (this.isDirectory() ? 1 : 0) + this.sumForChildren(ChangesBrowserNode::getDirectoryCount);
        }
        return this.myDirectoryCount;
    }

    protected void resetCounters() {
        this.myFileCount = -1;
        this.myDirectoryCount = -1;
    }

    private int sumForChildren(@NotNull ToIntFunction<? super ChangesBrowserNode<?>> counter) {
        if (counter == null) {
            ChangesBrowserNode.$$$reportNull$$$0(16);
        }
        int sum = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            ChangesBrowserNode child = (ChangesBrowserNode)this.getChildAt(i);
            sum += counter.applyAsInt(child);
        }
        return sum;
    }

    @NotNull
    public List<Change> getAllChangesUnder() {
        List<Change> list = this.getAllObjectsUnder(Change.class);
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public <U> List<U> getAllObjectsUnder(@NotNull Class<U> clazz) {
        if (clazz == null) {
            ChangesBrowserNode.$$$reportNull$$$0(18);
        }
        List list = this.traverseObjectsUnder().filter(clazz).toList();
        if (list == null) {
            ChangesBrowserNode.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public JBIterable<?> traverseObjectsUnder() {
        JBIterable jBIterable = this.traverse().map(TreeUtil::getUserObject);
        if (jBIterable == null) {
            ChangesBrowserNode.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ChangesBrowserNode<?>> traverse() {
        JBIterable iterable;
        JBIterable jBIterable = iterable = TreeUtil.treeNodeTraverser((TreeNode)this).preOrderDfsTraversal();
        if (jBIterable == null) {
            ChangesBrowserNode.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ChangesBrowserNode<?>> iterateNodeChildren() {
        JBIterable iterable;
        JBIterable jBIterable = iterable = TreeUtil.nodeChildren((TreeNode)this);
        if (jBIterable == null) {
            ChangesBrowserNode.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<VirtualFile> iterateFilesUnder() {
        JBIterable jBIterable = this.traverseObjectsUnder().filter(VirtualFile.class).filter(VirtualFile::isValid);
        if (jBIterable == null) {
            ChangesBrowserNode.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<FilePath> iterateFilePathsUnder() {
        JBIterable jBIterable = this.traverse().filter(DefaultMutableTreeNode::isLeaf).map(ChangesBrowserNode::getUserObject).filter(FilePath.class);
        if (jBIterable == null) {
            ChangesBrowserNode.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    public void render(@NotNull JTree tree, @NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (tree == null) {
            ChangesBrowserNode.$$$reportNull$$$0(25);
        }
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(26);
        }
        this.render(renderer, selected, expanded, hasFocus);
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(27);
        }
        renderer.append(this.getTextPresentation());
        this.appendCount(renderer);
    }

    @Nls
    @NotNull
    protected String getCountText() {
        int count = this.getFileCount();
        int dirCount = this.getDirectoryCount();
        Object result2 = "";
        if (dirCount != 0 || count != 0) {
            result2 = FontUtil.spaceAndThinSpace() + (dirCount == 0 ? VcsBundle.message((String)"changes.nodetitle.changecount", (Object[])new Object[]{count}) : (count == 0 ? VcsBundle.message((String)"changes.nodetitle.directory.changecount", (Object[])new Object[]{dirCount}) : VcsBundle.message((String)"changes.nodetitle.directory.file.changecount", (Object[])new Object[]{dirCount, count})));
        }
        String string = result2;
        if (string == null) {
            ChangesBrowserNode.$$$reportNull$$$0(28);
        }
        return string;
    }

    protected void appendCount(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(29);
        }
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    public String toString() {
        return this.getTextPresentation();
    }

    @Override
    public void setUserObject(Object userObject) {
        if (userObject != this.getUserObject()) {
            Logger.getInstance(ChangesBrowserNode.class).error("Should not replace UserObject for ChangesBrowserNode");
        }
        super.setUserObject(userObject);
    }

    @Nls
    public String getTextPresentation() {
        PluginException.reportDeprecatedDefault(this.getClass(), (String)"getTextPresentation", (String)"A proper implementation required");
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    @ApiStatus.Internal
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    @ApiStatus.Internal
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    public int getSortWeight() {
        return 10;
    }

    public int compareUserObjects(T o2) {
        return 0;
    }

    protected static int compareFileNames(@NotNull String name1, @NotNull String name2) {
        if (name1 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(30);
        }
        if (name2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(31);
        }
        return FileNameComparator.getInstance().compare(name1, name2);
    }

    public static int compareFilePaths(@NotNull FilePath path1, @NotNull FilePath path2) {
        if (path1 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(32);
        }
        if (path2 == null) {
            ChangesBrowserNode.$$$reportNull$$$0(33);
        }
        return ChangesComparator.getFilePathComparator(true).compare(path1, path2);
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable FilePath parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(34);
        }
        if (parentPath != null) {
            String presentablePath = VcsUtil.getPresentablePath((Project)renderer.getProject(), (FilePath)parentPath, (boolean)true, (boolean)true);
            if (presentablePath.isEmpty()) {
                return;
            }
            renderer.append(FontUtil.spaceAndThinSpace() + presentablePath, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    protected void appendParentPath(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable VirtualFile parentPath) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(35);
        }
        if (parentPath != null) {
            String presentablePath = VcsUtil.getPresentablePath((Project)renderer.getProject(), (VirtualFile)parentPath, (boolean)true, (boolean)true);
            if (presentablePath.isEmpty()) {
                return;
            }
            renderer.append(FontUtil.spaceAndThinSpace() + presentablePath, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    protected void appendUpdatingState(@NotNull ChangesBrowserNodeRenderer renderer) {
        if (renderer == null) {
            ChangesBrowserNode.$$$reportNull$$$0(36);
        }
        renderer.append((this.getCountText().isEmpty() ? FontUtil.spaceAndThinSpace() : ", ") + VcsBundle.message((String)"changes.nodetitle.updating", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Nullable
    public Color getBackgroundColor(@NotNull Project project) {
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(37);
        }
        return ChangesBrowserNode.getBackgroundColorFor(project, this.getUserObject());
    }

    @DirtyUI
    @Nullable
    protected static Color getBackgroundColorFor(@NotNull Project project, @Nullable Object object) {
        VirtualFile file;
        if (project == null) {
            ChangesBrowserNode.$$$reportNull$$$0(38);
        }
        if ((file = object instanceof FilePath ? ChangesBrowserNode.getScopeVirtualFileFor((FilePath)object) : (object instanceof Change ? ChangesBrowserNode.getScopeVirtualFileFor(ChangesUtil.getFilePath((Change)((Change)object))) : (VirtualFile)ObjectUtils.tryCast((Object)object, VirtualFile.class))) != null) {
            return VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)file);
        }
        return null;
    }

    @Nullable
    private static VirtualFile getScopeVirtualFileFor(@NotNull FilePath filePath) {
        if (filePath == null) {
            ChangesBrowserNode.$$$reportNull$$$0(39);
        }
        if (filePath.isNonLocal()) {
            return null;
        }
        return VcsImplUtil.findValidParentAccurately(filePath);
    }

    public boolean shouldExpandByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 14, 17, 19, 20, 21, 22, 23, 24, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRoot";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChangesUnder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllObjectsUnder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseObjectsUnder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNodeChildren";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateFilesUnder";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateFilePathsUnder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCountText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cacheBackgroundColor";
                break;
            }
            case 1: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLogicallyLocked";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLockedFolders";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLocallyDeleted";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sumForChildren";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllObjectsUnder";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendCount";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareFileNames";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "compareFilePaths";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendParentPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "appendUpdatingState";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColorFor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getScopeVirtualFileFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 14, 17, 19, 20, 21, 22, 23, 24, 28 -> new IllegalStateException(string);
        };
    }

    public static class VcsBundleTag
    implements Tag {
        @PropertyKey(resourceBundle="messages.VcsBundle")
        @NotNull
        private final @PropertyKey(resourceBundle="messages.VcsBundle") @NotNull String myKey;

        public VcsBundleTag(@PropertyKey(resourceBundle="messages.VcsBundle") @NotNull @PropertyKey(resourceBundle="messages.VcsBundle") @NotNull String key) {
            if (key == null) {
                VcsBundleTag.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Override
        @Nls
        public String toString() {
            return VcsBundle.message((String)this.myKey, (Object[])new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$VcsBundleTag", "<init>"));
        }
    }

    public static interface Tag {
        @Nls
        public String toString();
    }

    static interface NodeWithCollapsedParents {
        @ApiStatus.Internal
        public void addCollapsedParent(@NotNull ChangesBrowserNode<?> var1);
    }

    public static interface NodeWithFilePath {
        @NotNull
        public FilePath getNodeFilePath();
    }

    public static abstract class ValueTag<T>
    implements Tag {
        public final T value;

        public ValueTag(@NotNull T value) {
            if (value == null) {
                ValueTag.$$$reportNull$$$0(0);
            }
            this.value = value;
        }

        @NotNull
        protected T getValue() {
            T t = this.value;
            if (t == null) {
                ValueTag.$$$reportNull$$$0(1);
            }
            return t;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueTag tag = (ValueTag)o;
            return Objects.equals(this.value, tag.value);
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$ValueTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$ValueTag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class WrapperTag
    extends ValueTag<Object> {
        public static Tag wrap(@Nullable Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Tag) {
                return (Tag)object;
            }
            return new WrapperTag(object);
        }

        private WrapperTag(@NotNull Object value) {
            if (value == null) {
                WrapperTag.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @Nls
        public String toString() {
            return this.value.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$WrapperTag", "<init>"));
        }
    }

    public static class TagImpl
    implements Tag {
        @NotNull
        @Nls
        private final String myValue;

        public TagImpl(@NotNull @Nls String value) {
            if (value == null) {
                TagImpl.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        @Nls
        public String toString() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$TagImpl", "<init>"));
        }
    }
}

