from collections.abc import Iterator
from typing import Any, NoReturn

from django.template.base import Origin
from django.template.base import Template as _BaseTemplate
from django.template.engine import Engine
from django.template.exceptions import TemplateDoesNotExist

from .base import BaseEngine, _EngineTemplate

class DjangoTemplates(BaseEngine):
    engine: Engine
    def __init__(self, params: dict[str, Any]) -> None: ...
    def from_string(self, template_code: str) -> Template: ...
    def get_template(self, template_name: str) -> Template: ...
    def get_templatetag_libraries(self, custom_libraries: dict[str, str]) -> dict[str, str]: ...

def copy_exception(exc: TemplateDoesNotExist, backend: DjangoTemplates | None = None) -> TemplateDoesNotExist: ...
def reraise(exc: TemplateDoesNotExist, backend: DjangoTemplates) -> NoReturn: ...
def get_template_tag_modules() -> Iterator[tuple[str, str]]: ...
def get_installed_libraries() -> dict[str, str]: ...
def get_package_libraries(pkg: Any) -> Iterator[str]: ...

class Template(_EngineTemplate):
    template: _BaseTemplate
    backend: DjangoTemplates
    def __init__(self, template: _BaseTemplate, backend: BaseEngine) -> None: ...
    @property
    def origin(self) -> Origin: ...
