set(TEST_PHOTOSPP_ROOT_DIR  "" ${PHOTOSPP_ROOT_DIR})
IF(TEST_PHOTOSPP_ROOT_DIR STREQUAL "")
IF(DEFINED ENV{PHOTOSPP_ROOT_DIR})
set(PHOTOSPP_ROOT_DIR  $ENV{PHOTOSPP_ROOT_DIR})
else()
set(PHOTOSPP_ROOT_DIR  "/usr")
endif()
endif()
find_path(PHOTOSPP_INCLUDE_DIR Photos/Photos.h
          HINTS $ENV{PHOTOSPP_ROOT_DIR}/include ${PHOTOSPP_ROOT_DIR}/include NO_DEFAULT_PATH)
set(PHOTOSPP_VERSION 0.00)
if (PHOTOSPP_INCLUDE_DIR)
  if (EXISTS ${PHOTOSPP_INCLUDE_DIR}/Photos/Version.h)
    file(STRINGS ${PHOTOSPP_INCLUDE_DIR}/Photos/Version.h PHOTOS_VERSION_STRING_CONTENT REGEX "^#define[ ]+PHOTOS_VERSION[ ]+\"")
    string(REGEX MATCH "[1234567890\.]+[a-zA-Z]*" PHOTOSPP_VERSION ${PHOTOS_VERSION_STRING_CONTENT})
  endif()
endif()

find_library(PHOTOSPP_CxxInterface_LIBRARY NAMES PhotosCxxInterface
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib ${PHOTOSPP_ROOT_DIR}/lib
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib64 ${PHOTOSPP_ROOT_DIR}/lib64
             )

find_library(PHOTOSPP_Fortran_LIBRARY NAMES PhotosFortran
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib ${PHOTOSPP_ROOT_DIR}/lib
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib64 ${PHOTOSPP_ROOT_DIR}/lib64
             )

#This is for PHOTOS3.6x
find_library(PHOTOSPP_Photospp_LIBRARY NAMES Photospp
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib ${PHOTOSPP_ROOT_DIR}/lib
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib64 ${PHOTOSPP_ROOT_DIR}/lib64
             )

find_library(PHOTOSPP_HEPEVT_LIBRARY NAMES PhotosppHEPEVT
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib ${PHOTOSPP_ROOT_DIR}/lib
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib64 ${PHOTOSPP_ROOT_DIR}/lib64
             )

find_library(PHOTOSPP_HepMC_LIBRARY NAMES PhotosppHepMC
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib ${PHOTOSPP_ROOT_DIR}/lib
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib64 ${PHOTOSPP_ROOT_DIR}/lib64
             )

find_library(PHOTOSPP_HepMC3_LIBRARY NAMES PhotosppHepMC3
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib ${PHOTOSPP_ROOT_DIR}/lib
             HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib64 ${PHOTOSPP_ROOT_DIR}/lib64
             )

foreach(comp ${PHOTOSPP_FIND_COMPONENTS})
  find_library(PHOTOSPP_${comp}_LIBRARY NAMES Photospp${comp}
               HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib   ${PHOTOSPP_ROOT_DIR}/lib
               HINTS $ENV{PHOTOSPP_ROOT_DIR}/lib64 ${PHOTOSPP_ROOT_DIR}/lib64
               )
endforeach()

set(PHOTOSPP_INCLUDE_DIRS ${PHOTOSPP_INCLUDE_DIR})
if (PHOTOSPP_HepMC3_LIBRARY)
  set(PHOTOSPP_HEPMC3_LIBRARIES  ${PHOTOSPP_HepMC3_LIBRARY}   )
  set(Photospp_HEPMC3_FOUND TRUE)
endif()
if (PHOTOSPP_Photospp_LIBRARY  AND  PHOTOSPP_HepMC_LIBRARY)
  set(PHOTOSPP_LIBRARIES ${PHOTOSPP_Photospp_LIBRARY} ${PHOTOSPP_HEPEVT_LIBRARY}  )
  set(PHOTOSPP_HEPMC2_LIBRARIES  ${PHOTOSPP_HepMC_LIBRARY}   )
  set(Photospp_HEPMC2_FOUND TRUE)
else()
  if (PHOTOSPP_CxxInterface_LIBRARY)
    set(PHOTOSPP_LIBRARIES ${PHOTOSPP_CxxInterface_LIBRARY} ${PHOTOSPP_Fortran_LIBRARY})
    set(PHOTOSPP_HEPMC2_LIBRARIES  ${PHOTOSPP_CxxInterface_LIBRARY}  )
    set(Photospp_HEPMC2_FOUND TRUE)
  endif()
endif()

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Photospp REQUIRED_VARS PHOTOSPP_INCLUDE_DIR PHOTOSPP_LIBRARIES PHOTOSPP_VERSION  HANDLE_COMPONENTS)

mark_as_advanced(Photospp_FOUND PHOTOSPP_INCLUDE_DIR PHOTOSPP_INCLUDE_DIRS  PHOTOSPP_LIBRARIES)
