/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ECOPRO_H
#define ECOPRO_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"

#ifdef ECOPRO_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR			0
#define DRIVER_VERSION_MINOR			0
#define DRIVER_VERSION_SUBMINOR		1

#define DRIVER_BITMAP_FILE				PIX_PATH"/ecopro.bmp"
#define DRIVER_CONFIG_FILE				"ecopro.conf"
#define DRIVER_UPS_FAMILY				"ECO Pro 350-1200"
#define DRIVER_UPS_PREFIX				"ECO Pro"
#define DRIVER_UPS_SUFFIX				""

#define UPS_MAX_MODELS					0

/* 
 * Licznik pozycji ustawie z drivera
 */
#define INT_MAX_SETUPITEMS				1
/* 
 * Identyfikatory ustawie UPS-a
 */
#define INT_UPSCFG_SERIALCOMM			0

/*
 * Bity stanow pracy
 */
#define USB_AND_POWERFAIL				TIOCM_CTS
#define USB_FLAG_POWERFAIL				TIOCM_CTS

#define USB_AND_LOWBATTERY				TIOCM_CD
#define USB_FLAG_LOWBATTERY			TIOCM_CD

/*
 * Indeksy z tablicy ustawien UPS-a
 */
#define SETUP_TABLE_ITEMS				0x01
// Indeksy tablicy ustawien
#define IDX_SHUTDOWN						0x00

/*
 * Indeksy z tablicy parametrow UPS-a
 */
#define PARAMS_TABLE_ITEMS				0x01
// Indeksy tablicy parametrow
#define IDXP_STATEFLAG					0x00

/*
 * Structures
 */
typedef struct _sdrv_config_
{
	/* struct size used for versioning */
	unsigned long	ulSize;
	/* serial port configured by user */
	int				iSerialPort;
	char				szSerialPort[MAX_PATHBUFF];
	/* setup table */
	unsigned int	uiSetupTable[SETUP_TABLE_ITEMS];
	/* parameters table */
	unsigned int	uiParamsTable[PARAMS_TABLE_ITEMS];
} sdrv_config, *lpsdrv_config;

/* 
 * Enumerators
 */
typedef enum _eups_structs_
{
	EU_STATE		= 1	// EU_INFORMATIONS
} eups_structs;

/* 
 * Function prototypes - internal
 */
int		EcoPro_DoInit(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetUPSStructures(eups_structs eType, void *lpvBuff, int *lpiBuffSize, int *lpiBuffErrPos);
int		EcoPro_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoGetDriverMode(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		EcoPro_ReadConfig();
int		EcoPro_GetAllUpsParams(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_GetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		EcoPro_SetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);

#else/*ECOPRO_DRIVER_BUILD*/

int		ecopro_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif/*ECOPRO_DRIVER_BUILD*/

#endif/*ECOPRO_H*/
