/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MONITOR_H
#define MONITOR_H 1

#include <netdb.h>
#include <arpa/inet.h>
extern int h_errno;

#include "ioctldef.h"

#include "gldefs.h"
#include "common.h"
#include "conf.h"
#include "cshmem.h"
#include "cemail.h"
#include "structs.h"
#include "clog.h"

/* intervals (in seconds) */
#define INT_LOOP_INTERVAL		5
#define INT_MONITOR_INTERVAL	4
#define INT_ACTION_INTERVAL		1
#define INT_EXITWAIT_INTERVAL	5

/* max. no of communication errors */
#define INT_MAX_COMMERRORS		16

/* function prototypes */
LPFNIOCTL get_ups_interface(char *name);

int	getAllUpsData();
int	checkUpsStates( void );
int	testUpsLink( void );

void	monitor( void *lpv );
void	*actions( void *lpv );
void	executeActions( int iEventIdx );
void	*shutdown( void/*ssdownhlp*/ *lpsc );
int		shutdown_system( int imode );
int		sendToNetClients( sprogramevent spe );
void	*netShutdownThread( void *lpv );

int		netMgmtRecvData(int sock, struct sockaddr_in *bsai, char *buff, int isize, int itimeout);
int		checkForConnection(int sock, int itimeoutms);
void	*netManagement( void *lpv );

int		update_main_config();
int		update_user_config();
int		read_action_config(CConf *pcfg, int iIndex, sprogramevent *lpspe);
void	print_device_parameters(lpsapp_config lpsac, lpsflow_ctl lpsfc);
int 	service_start();
void	stop_monitoring();
void	terminate(int iCode);


#endif/*MONITOR_H*/

