/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef NET_H
#define NET_H

#include "structs.h"
#include "gldefs.h"
#include "ioctldef.h"

#ifdef NET_DRIVER_BUILD

/* 
 * Driver definitions
 */
#define DRIVER_VERSION_MAJOR		0
#define DRIVER_VERSION_MINOR		9
#define DRIVER_VERSION_SUBMINOR		1

#define DRIVER_BITMAP_FILE			PIX_PATH"/net.bmp"
#define DRIVER_CONFIG_FILE			"net.conf"
#define DRIVER_UPS_FAMILY			"NET 500-2200"
#define DRIVER_UPS_PREFIX			"NET"
#define DRIVER_UPS_SUFFIX			"DPC"

// number of UPS models
#define UPS_MAX_MODELS				5
// hierarchy of models
#define UPS_MODEL1					"500"
#define UPS_MODEL2					"700"
#define UPS_MODEL3					"1000"
#define UPS_MODEL4					"1400"
#define UPS_MODEL5					"2200"

#define INT_UPS_MODEL1				67
#define INT_UPS_MODEL2				68
#define INT_UPS_MODEL3				69
#define INT_UPS_MODEL4				70
#define INT_UPS_MODEL5				71
// new models added
#define INT_UPS_MODEL1_2			76
#define INT_UPS_MODEL2_2			73
#define INT_UPS_MODEL3_2			74
#define INT_UPS_MODEL4_2			75
#define INT_UPS_MODEL5_2			71 //ten jeden bez zmian

/* 
 * Config items count
 */
#define INT_MAX_SETUPITEMS				6
/* 
 * ID's of config items
 */
#define INT_UPSCFG_SERIALCOMM			0
#define INT_UPSCFG_BUZZER				1
#define INT_UPSCFG_V_TH_LOWER			2
#define INT_UPSCFG_V_TH_UPPER			3
#define INT_UPSCFG_V_TH_AVR				4
#define INT_UPSCFG_STANDBYDELAY			5

// default values
#define DEFAULT_STANDBY_TIME			120
#define DEFAULT_LOWER_TT				185
#define DEFAULT_AVR_TT					200
#define DEFAULT_UPPER_TT				270

/* 
 * frame codes
 */
#define FRAME_INITCODE					0xD0
#define FRAME_BUSYCODE					0xCF
#define FRAME_CTL_TOREAD				0x80
#define FRAME_CTL_TWOBYTES				0x40

/*
 * UPS data
 */
// sysflag register
#define FRAME_CODE_SYSFLAG					0x0D
#define SFB_AND_STANDBY						0xE7
#define SFB_OR_STANDBY						0x08
#define SFB_AND_STANDBY2					0xC7
#define SFB_OR_STANDBY2						0x30
#define SFB_AND_LATCH						0x2F
#define SFB_OR_LATCH						0xC0
#define SFB_AND_TEST						0xED
#define SFB_OR_TEST							0x02
#define SFB_AND_SOUND						0xFB
#define SFB_OR_SOUND						0x04

// UPS type
#define FRAME_CODE_UPSTYPE					0x2D

// accu value
#define FRAME_CODE_AKUVALUE					0x3D

// input value
#define FRAME_CODE_POWERVALUE				0x35

// avr transfer treshold
#define FRAME_CODE_AVRVALUE					0x3B
// upper transfer treshold
#define FRAME_CODE_RUPVALUE					0x39
// lower transfer treshold
#define FRAME_CODE_RLOVALUE					0x37

// A port shadow - AVR state
#define FRAME_CODE_PORTASH					0x2A
#define PAB_AND_AVRUP						0x04
#define PAB_FLAG_AVRUP						0x04
// time to standby
#define FRAME_CODE_STANDBYTIME				0x1C

/*
 * UPS state bits
 */
#define FRAME_CODE_UPSSTATE			0x2F
#define USB_AND_STANDBY				0x01
#define USB_FLAG_STANDBY			0x01
#define USB_AND_POWERFAIL			0x05
#define USB_FLAG_POWERFAIL			0x04
#define USB_AND_POWEROK				0x05
#define USB_FLAG_POWEROK			0x00
#define USB_AND_SHORT				0x10
#define USB_FLAG_SHORT				0x10
#define USB_AND_OVERLOAD			0x20
#define USB_FLAG_OVERLOAD			0x20

// Sysflag
#define FLAG_SYSFLAG				0x40

// UPS setup table items number
#define SETUP_TABLE_ITEMS			0x06
// UPS Setup table indexes
#define SETUP_ITEM_V_TH_UPPER		0x00
#define SETUP_ITEM_V_TH_LOWER		0x01
#define SETUP_ITEM_V_TH_AVR			0x02
#define SETUP_ITEM_BUZZER_EN		0x03
#define SETUP_ITEM_STANDBY_TIME		0x04
#define IDX_SHUTDOWN				0x05

// UPS parameters table items number
#define PARAMS_TABLE_ITEMS			0x09
// UPS parameters table indexes
#define IDXP_UPSTYPE				0x00
#define IDXP_U_AKU					0x01
#define IDXP_U_POWER				0x02
#define IDXP_SYSFLAG				0x03
#define IDXP_STATEFLAG				0x04
#define IDXP_STATEAVR				0x05
#define IDXP_TH_AVRUP				0x06
#define IDXP_TH_UPPER				0x07
#define IDXP_TH_LOWER				0x08

/* 
 * Macros
 */
#undef FAILED
#define FAILED( var )				(BOOL)((var == 0) ? 0 : 1)

/* 
 * Structures
 */
typedef struct _sdrv_config_
{
	/* struct size used for versioning */
	unsigned long	ulSize;
	/* serial port configured by user */
	int				iSerialPort;
	char			szSerialPort[MAX_PATHBUFF];
	/* tablica ustawien */
	unsigned int	uiSetupTable[SETUP_TABLE_ITEMS];
	/* tablica parametrow */
	unsigned int	uiParamsTable[PARAMS_TABLE_ITEMS];
	
} sdrv_config, *lpsdrv_config;

/* 
 * Enumerators
 */
/* typy danych o jakie odpytuje sterownik UPS'a */
typedef enum _eups_datatypes_
{
	EU_CLEANFRAME	= 1,
	EU_UPSTYPE		= 2,
	EU_U_AKU		= 3,
	EU_U_POWER		= 4,
	EU_SYSFLAG		= 5,
	EU_STATE		= 6,
	EU_STATEAVR		= 7,
	EU_S_AVRUP		= 8,
	EU_S_UPPER		= 9,
	EU_S_LOWER		= 10,
	EU_STANDBY_TIME	= 11
} eups_datatypes;

/* 
 * Function prototypes - internal
 */
int		Net_DoInit(void *lpvBuff, int *lpiBuffSize);
int		Net_DoUnInit(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetConfigFileName(void *lpvBuff, int *lpiBuffSize);
int		Net_DoAutoConfigure(void *lpvBuff, int *lpiBuffSize);
int		Net_DoConfigure(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetUpsInfoMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetUpsStateMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsState(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetUpsParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsParams(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetUpsSetupParamsMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetDriverInfo(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsCharacteristics(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetExtendedError(void *lpvBuff, int *lpiBuffSize);
int		Net_DoTestUpsLink(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUPSdata(eups_datatypes eType, void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetUPSdata(eups_datatypes eType, void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsCharacteristicMask(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetUpsCharacteristic(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetConfigParamsCount(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetConfigParams(void *lpvBuff, int *lpiBuffSize);
int		Net_DoSetConfigParam(void *lpvBuff, int *lpiBuffSize);
int		Net_DoUpdateConfig(void *lpvBuff, int *lpiBuffSize);
int		Net_DoGetDriverMode(void *lpvBuff, int *lpiBuffSize);
int		Net_DoUpsShutdown(void *lpvBuff, int *lpiBuffSize);

int		Net_ReadConfig();

int		Net_GetAllUpsParams(void *lpvBuff, int *lpiBuffSize);
int		Net_GetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);
int		Net_SetAllUpsSetupParams(void *lpvBuff, int *lpiBuffSize);

#else /*NET_DRIVER_BUILD*/

int		net_ioctl(long lCommand, void *lpvBuff, int *lpiBuffSize);

#endif/*NET_DRIVER_BUILD*/

#endif/*NET_H*/
