/* esco - interpreter for a lot (in future) esoteric languages.
 * Copyright (C) 2007-2011, Zasenko Sergey
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <config.h>
#include <string.h>
#include "bfmemory.h"
#include "defs.h"

BFMemory::BFMemory(int _size,bfcell fillc) {
    if (_size != 0) {
        size = _size;
    }
    else
        size = BFDEFMEMSIZE;
    bfcell* tmem = new bfcell [size];
    memset(tmem, fillc, size);

    mem = tmem;
    ptr = 0;
}

BFMemory::~BFMemory() {
    delete [] mem;
}

const bfcell* BFMemory::getData() {
    return mem;
}

int BFMemory::setPtr(unsigned int _ptr) {
    if (_ptr < size) {
        ptr = _ptr;
        return 1;
    }
    else
        return 0;
}

int BFMemory::getSize() {
    return size;
};

