// Package xprint is the X client API for the XpExtension extension.
package xprint

// This file is automatically generated from xprint.xml. Edit at your peril!

import (
	"github.com/jezek/xgb"

	"github.com/jezek/xgb/xproto"
)

// Init must be called before using the XpExtension extension.
func Init(c *xgb.Conn) error {
	reply, err := xproto.QueryExtension(c, 11, "XpExtension").Reply()
	switch {
	case err != nil:
		return err
	case !reply.Present:
		return xgb.Errorf("No extension named XpExtension could be found on on the server.")
	}

	c.ExtLock.Lock()
	c.Extensions["XpExtension"] = reply.MajorOpcode
	c.ExtLock.Unlock()
	for evNum, fun := range xgb.NewExtEventFuncs["XpExtension"] {
		xgb.NewEventFuncs[int(reply.FirstEvent)+evNum] = fun
	}
	for errNum, fun := range xgb.NewExtErrorFuncs["XpExtension"] {
		xgb.NewErrorFuncs[int(reply.FirstError)+errNum] = fun
	}
	return nil
}

func init() {
	xgb.NewExtEventFuncs["XpExtension"] = make(map[int]xgb.NewEventFun)
	xgb.NewExtErrorFuncs["XpExtension"] = make(map[int]xgb.NewErrorFun)
}

const (
	AttrJobAttr     = 1
	AttrDocAttr     = 2
	AttrPageAttr    = 3
	AttrPrinterAttr = 4
	AttrServerAttr  = 5
	AttrMediumAttr  = 6
	AttrSpoolerAttr = 7
)

// AttributNotify is the event number for a AttributNotifyEvent.
const AttributNotify = 1

type AttributNotifyEvent struct {
	Sequence uint16
	Detail   byte
	Context  Pcontext
}

// AttributNotifyEventNew constructs a AttributNotifyEvent value that implements xgb.Event from a byte slice.
func AttributNotifyEventNew(buf []byte) xgb.Event {
	v := AttributNotifyEvent{}
	b := 1 // don't read event number

	v.Detail = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Context = Pcontext(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Bytes writes a AttributNotifyEvent value to a byte slice.
func (v AttributNotifyEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 1
	b += 1

	buf[b] = v.Detail
	b += 1

	b += 2 // skip sequence number

	xgb.Put32(buf[b:], uint32(v.Context))
	b += 4

	return buf
}

// SequenceId returns the sequence id attached to the AttributNotify event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v AttributNotifyEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of AttributNotifyEvent.
func (v AttributNotifyEvent) String() string {
	fieldVals := make([]string, 0, 2)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("Detail: %d", v.Detail))
	fieldVals = append(fieldVals, xgb.Sprintf("Context: %d", v.Context))
	return "AttributNotify {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["XpExtension"][1] = AttributNotifyEventNew
}

// BadBadContext is the error number for a BadBadContext.
const BadBadContext = 0

type BadContextError struct {
	Sequence uint16
	NiceName string
}

// BadContextErrorNew constructs a BadContextError value that implements xgb.Error from a byte slice.
func BadContextErrorNew(buf []byte) xgb.Error {
	v := BadContextError{}
	v.NiceName = "BadContext"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadContext error.
// This is mostly used internally.
func (err BadContextError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadContext error. If no bad value exists, 0 is returned.
func (err BadContextError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadContext error.

func (err BadContextError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadContext {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XpExtension"][0] = BadContextErrorNew
}

// BadBadSequence is the error number for a BadBadSequence.
const BadBadSequence = 1

type BadSequenceError struct {
	Sequence uint16
	NiceName string
}

// BadSequenceErrorNew constructs a BadSequenceError value that implements xgb.Error from a byte slice.
func BadSequenceErrorNew(buf []byte) xgb.Error {
	v := BadSequenceError{}
	v.NiceName = "BadSequence"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadSequence error.
// This is mostly used internally.
func (err BadSequenceError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadSequence error. If no bad value exists, 0 is returned.
func (err BadSequenceError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadSequence error.

func (err BadSequenceError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadSequence {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XpExtension"][1] = BadSequenceErrorNew
}

const (
	DetailStartJobNotify  = 1
	DetailEndJobNotify    = 2
	DetailStartDocNotify  = 3
	DetailEndDocNotify    = 4
	DetailStartPageNotify = 5
	DetailEndPageNotify   = 6
)

const (
	EvMaskNoEventMask   = 0
	EvMaskPrintMask     = 1
	EvMaskAttributeMask = 2
)

const (
	GetDocFinished       = 0
	GetDocSecondConsumer = 1
)

// Notify is the event number for a NotifyEvent.
const Notify = 0

type NotifyEvent struct {
	Sequence uint16
	Detail   byte
	Context  Pcontext
	Cancel   bool
}

// NotifyEventNew constructs a NotifyEvent value that implements xgb.Event from a byte slice.
func NotifyEventNew(buf []byte) xgb.Event {
	v := NotifyEvent{}
	b := 1 // don't read event number

	v.Detail = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Context = Pcontext(xgb.Get32(buf[b:]))
	b += 4

	if buf[b] == 1 {
		v.Cancel = true
	} else {
		v.Cancel = false
	}
	b += 1

	return v
}

// Bytes writes a NotifyEvent value to a byte slice.
func (v NotifyEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 0
	b += 1

	buf[b] = v.Detail
	b += 1

	b += 2 // skip sequence number

	xgb.Put32(buf[b:], uint32(v.Context))
	b += 4

	if v.Cancel {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// SequenceId returns the sequence id attached to the Notify event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v NotifyEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of NotifyEvent.
func (v NotifyEvent) String() string {
	fieldVals := make([]string, 0, 3)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("Detail: %d", v.Detail))
	fieldVals = append(fieldVals, xgb.Sprintf("Context: %d", v.Context))
	fieldVals = append(fieldVals, xgb.Sprintf("Cancel: %t", v.Cancel))
	return "Notify {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["XpExtension"][0] = NotifyEventNew
}

type Pcontext uint32

func NewPcontextId(c *xgb.Conn) (Pcontext, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Pcontext(id), nil
}

type Printer struct {
	NameLen uint32
	Name    []String8 // size: xgb.Pad((int(NameLen) * 1))
	// alignment gap to multiple of 4
	DescLen     uint32
	Description []String8 // size: xgb.Pad((int(DescLen) * 1))
	// alignment gap to multiple of 4
}

// PrinterRead reads a byte slice into a Printer value.
func PrinterRead(buf []byte, v *Printer) int {
	b := 0

	v.NameLen = xgb.Get32(buf[b:])
	b += 4

	v.Name = make([]String8, v.NameLen)
	for i := 0; i < int(v.NameLen); i++ {
		v.Name[i] = String8(buf[b])
		b += 1
	}

	b = (b + 3) & ^3 // alignment gap

	v.DescLen = xgb.Get32(buf[b:])
	b += 4

	v.Description = make([]String8, v.DescLen)
	for i := 0; i < int(v.DescLen); i++ {
		v.Description[i] = String8(buf[b])
		b += 1
	}

	b = (b + 3) & ^3 // alignment gap

	return b
}

// PrinterReadList reads a byte slice into a list of Printer values.
func PrinterReadList(buf []byte, dest []Printer) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = Printer{}
		b += PrinterRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a Printer value to a byte slice.
func (v Printer) Bytes() []byte {
	buf := make([]byte, (((((4 + xgb.Pad((int(v.NameLen) * 1))) + 4) + 4) + xgb.Pad((int(v.DescLen) * 1))) + 4))
	b := 0

	xgb.Put32(buf[b:], v.NameLen)
	b += 4

	for i := 0; i < int(v.NameLen); i++ {
		buf[b] = byte(v.Name[i])
		b += 1
	}

	b = (b + 3) & ^3 // alignment gap

	xgb.Put32(buf[b:], v.DescLen)
	b += 4

	for i := 0; i < int(v.DescLen); i++ {
		buf[b] = byte(v.Description[i])
		b += 1
	}

	b = (b + 3) & ^3 // alignment gap

	return buf[:b]
}

// PrinterListBytes writes a list of Printer values to a byte slice.
func PrinterListBytes(buf []byte, list []Printer) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// PrinterListSize computes the size (bytes) of a list of Printer values.
func PrinterListSize(list []Printer) int {
	size := 0
	for _, item := range list {
		size += (((((4 + xgb.Pad((int(item.NameLen) * 1))) + 4) + 4) + xgb.Pad((int(item.DescLen) * 1))) + 4)
	}
	return size
}

type String8 byte

// Skipping definition for base type 'Bool'

// Skipping definition for base type 'Byte'

// Skipping definition for base type 'Card8'

// Skipping definition for base type 'Char'

// Skipping definition for base type 'Void'

// Skipping definition for base type 'Double'

// Skipping definition for base type 'Float'

// Skipping definition for base type 'Int16'

// Skipping definition for base type 'Int32'

// Skipping definition for base type 'Int8'

// Skipping definition for base type 'Card16'

// Skipping definition for base type 'Card32'

// CreateContextCookie is a cookie used only for CreateContext requests.
type CreateContextCookie struct {
	*xgb.Cookie
}

// CreateContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateContext(c *xgb.Conn, ContextId uint32, PrinterNameLen uint32, LocaleLen uint32, PrinterName []String8, Locale []String8) CreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'CreateContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createContextRequest(c, ContextId, PrinterNameLen, LocaleLen, PrinterName, Locale), cookie)
	return CreateContextCookie{cookie}
}

// CreateContextChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateContextCookie.Check()
func CreateContextChecked(c *xgb.Conn, ContextId uint32, PrinterNameLen uint32, LocaleLen uint32, PrinterName []String8, Locale []String8) CreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'CreateContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createContextRequest(c, ContextId, PrinterNameLen, LocaleLen, PrinterName, Locale), cookie)
	return CreateContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateContext
// createContextRequest writes a CreateContext request to a byte slice.
func createContextRequest(c *xgb.Conn, ContextId uint32, PrinterNameLen uint32, LocaleLen uint32, PrinterName []String8, Locale []String8) []byte {
	size := xgb.Pad((((16 + xgb.Pad((int(PrinterNameLen) * 1))) + 4) + xgb.Pad((int(LocaleLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 2 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], ContextId)
	b += 4

	xgb.Put32(buf[b:], PrinterNameLen)
	b += 4

	xgb.Put32(buf[b:], LocaleLen)
	b += 4

	for i := 0; i < int(PrinterNameLen); i++ {
		buf[b] = byte(PrinterName[i])
		b += 1
	}

	b = (b + 3) & ^3 // alignment gap

	for i := 0; i < int(LocaleLen); i++ {
		buf[b] = byte(Locale[i])
		b += 1
	}

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// PrintDestroyContextCookie is a cookie used only for PrintDestroyContext requests.
type PrintDestroyContextCookie struct {
	*xgb.Cookie
}

// PrintDestroyContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintDestroyContext(c *xgb.Conn, Context uint32) PrintDestroyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintDestroyContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printDestroyContextRequest(c, Context), cookie)
	return PrintDestroyContextCookie{cookie}
}

// PrintDestroyContextChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintDestroyContextCookie.Check()
func PrintDestroyContextChecked(c *xgb.Conn, Context uint32) PrintDestroyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintDestroyContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printDestroyContextRequest(c, Context), cookie)
	return PrintDestroyContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintDestroyContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintDestroyContext
// printDestroyContextRequest writes a PrintDestroyContext request to a byte slice.
func printDestroyContextRequest(c *xgb.Conn, Context uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 5 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Context)
	b += 4

	return buf
}

// PrintEndDocCookie is a cookie used only for PrintEndDoc requests.
type PrintEndDocCookie struct {
	*xgb.Cookie
}

// PrintEndDoc sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintEndDoc(c *xgb.Conn, Cancel bool) PrintEndDocCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintEndDoc' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printEndDocRequest(c, Cancel), cookie)
	return PrintEndDocCookie{cookie}
}

// PrintEndDocChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintEndDocCookie.Check()
func PrintEndDocChecked(c *xgb.Conn, Cancel bool) PrintEndDocCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintEndDoc' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printEndDocRequest(c, Cancel), cookie)
	return PrintEndDocCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintEndDocCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintEndDoc
// printEndDocRequest writes a PrintEndDoc request to a byte slice.
func printEndDocRequest(c *xgb.Conn, Cancel bool) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 10 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	if Cancel {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// PrintEndJobCookie is a cookie used only for PrintEndJob requests.
type PrintEndJobCookie struct {
	*xgb.Cookie
}

// PrintEndJob sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintEndJob(c *xgb.Conn, Cancel bool) PrintEndJobCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintEndJob' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printEndJobRequest(c, Cancel), cookie)
	return PrintEndJobCookie{cookie}
}

// PrintEndJobChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintEndJobCookie.Check()
func PrintEndJobChecked(c *xgb.Conn, Cancel bool) PrintEndJobCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintEndJob' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printEndJobRequest(c, Cancel), cookie)
	return PrintEndJobCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintEndJobCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintEndJob
// printEndJobRequest writes a PrintEndJob request to a byte slice.
func printEndJobRequest(c *xgb.Conn, Cancel bool) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 8 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	if Cancel {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	return buf
}

// PrintEndPageCookie is a cookie used only for PrintEndPage requests.
type PrintEndPageCookie struct {
	*xgb.Cookie
}

// PrintEndPage sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintEndPage(c *xgb.Conn, Cancel bool) PrintEndPageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintEndPage' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printEndPageRequest(c, Cancel), cookie)
	return PrintEndPageCookie{cookie}
}

// PrintEndPageChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintEndPageCookie.Check()
func PrintEndPageChecked(c *xgb.Conn, Cancel bool) PrintEndPageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintEndPage' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printEndPageRequest(c, Cancel), cookie)
	return PrintEndPageCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintEndPageCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintEndPage
// printEndPageRequest writes a PrintEndPage request to a byte slice.
func printEndPageRequest(c *xgb.Conn, Cancel bool) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 14 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	if Cancel {
		buf[b] = 1
	} else {
		buf[b] = 0
	}
	b += 1

	b += 3 // padding

	return buf
}

// PrintGetAttributesCookie is a cookie used only for PrintGetAttributes requests.
type PrintGetAttributesCookie struct {
	*xgb.Cookie
}

// PrintGetAttributes sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetAttributesCookie.Reply()
func PrintGetAttributes(c *xgb.Conn, Context Pcontext, Pool byte) PrintGetAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetAttributes' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetAttributesRequest(c, Context, Pool), cookie)
	return PrintGetAttributesCookie{cookie}
}

// PrintGetAttributesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetAttributesUnchecked(c *xgb.Conn, Context Pcontext, Pool byte) PrintGetAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetAttributes' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetAttributesRequest(c, Context, Pool), cookie)
	return PrintGetAttributesCookie{cookie}
}

// PrintGetAttributesReply represents the data returned from a PrintGetAttributes request.
type PrintGetAttributesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	StringLen uint32
	// padding: 20 bytes
	Attributes []String8 // size: xgb.Pad((int(StringLen) * 1))
}

// Reply blocks and returns the reply data for a PrintGetAttributes request.
func (cook PrintGetAttributesCookie) Reply() (*PrintGetAttributesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetAttributesReply(buf), nil
}

// printGetAttributesReply reads a byte slice into a PrintGetAttributesReply value.
func printGetAttributesReply(buf []byte) *PrintGetAttributesReply {
	v := new(PrintGetAttributesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.StringLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Attributes = make([]String8, v.StringLen)
	for i := 0; i < int(v.StringLen); i++ {
		v.Attributes[i] = String8(buf[b])
		b += 1
	}

	return v
}

// Write request to wire for PrintGetAttributes
// printGetAttributesRequest writes a PrintGetAttributes request to a byte slice.
func printGetAttributesRequest(c *xgb.Conn, Context Pcontext, Pool byte) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 17 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	buf[b] = Pool
	b += 1

	b += 3 // padding

	return buf
}

// PrintGetContextCookie is a cookie used only for PrintGetContext requests.
type PrintGetContextCookie struct {
	*xgb.Cookie
}

// PrintGetContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetContextCookie.Reply()
func PrintGetContext(c *xgb.Conn) PrintGetContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetContextRequest(c), cookie)
	return PrintGetContextCookie{cookie}
}

// PrintGetContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetContextUnchecked(c *xgb.Conn) PrintGetContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetContextRequest(c), cookie)
	return PrintGetContextCookie{cookie}
}

// PrintGetContextReply represents the data returned from a PrintGetContext request.
type PrintGetContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Context uint32
}

// Reply blocks and returns the reply data for a PrintGetContext request.
func (cook PrintGetContextCookie) Reply() (*PrintGetContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetContextReply(buf), nil
}

// printGetContextReply reads a byte slice into a PrintGetContextReply value.
func printGetContextReply(buf []byte) *PrintGetContextReply {
	v := new(PrintGetContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Context = xgb.Get32(buf[b:])
	b += 4

	return v
}

// Write request to wire for PrintGetContext
// printGetContextRequest writes a PrintGetContext request to a byte slice.
func printGetContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 4 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// PrintGetDocumentDataCookie is a cookie used only for PrintGetDocumentData requests.
type PrintGetDocumentDataCookie struct {
	*xgb.Cookie
}

// PrintGetDocumentData sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetDocumentDataCookie.Reply()
func PrintGetDocumentData(c *xgb.Conn, Context Pcontext, MaxBytes uint32) PrintGetDocumentDataCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetDocumentData' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetDocumentDataRequest(c, Context, MaxBytes), cookie)
	return PrintGetDocumentDataCookie{cookie}
}

// PrintGetDocumentDataUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetDocumentDataUnchecked(c *xgb.Conn, Context Pcontext, MaxBytes uint32) PrintGetDocumentDataCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetDocumentData' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetDocumentDataRequest(c, Context, MaxBytes), cookie)
	return PrintGetDocumentDataCookie{cookie}
}

// PrintGetDocumentDataReply represents the data returned from a PrintGetDocumentData request.
type PrintGetDocumentDataReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	StatusCode   uint32
	FinishedFlag uint32
	DataLen      uint32
	// padding: 12 bytes
	Data []byte // size: xgb.Pad((int(DataLen) * 1))
}

// Reply blocks and returns the reply data for a PrintGetDocumentData request.
func (cook PrintGetDocumentDataCookie) Reply() (*PrintGetDocumentDataReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetDocumentDataReply(buf), nil
}

// printGetDocumentDataReply reads a byte slice into a PrintGetDocumentDataReply value.
func printGetDocumentDataReply(buf []byte) *PrintGetDocumentDataReply {
	v := new(PrintGetDocumentDataReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.StatusCode = xgb.Get32(buf[b:])
	b += 4

	v.FinishedFlag = xgb.Get32(buf[b:])
	b += 4

	v.DataLen = xgb.Get32(buf[b:])
	b += 4

	b += 12 // padding

	v.Data = make([]byte, v.DataLen)
	copy(v.Data[:v.DataLen], buf[b:])
	b += int(v.DataLen)

	return v
}

// Write request to wire for PrintGetDocumentData
// printGetDocumentDataRequest writes a PrintGetDocumentData request to a byte slice.
func printGetDocumentDataRequest(c *xgb.Conn, Context Pcontext, MaxBytes uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 12 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], MaxBytes)
	b += 4

	return buf
}

// PrintGetImageResolutionCookie is a cookie used only for PrintGetImageResolution requests.
type PrintGetImageResolutionCookie struct {
	*xgb.Cookie
}

// PrintGetImageResolution sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetImageResolutionCookie.Reply()
func PrintGetImageResolution(c *xgb.Conn, Context Pcontext) PrintGetImageResolutionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetImageResolution' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetImageResolutionRequest(c, Context), cookie)
	return PrintGetImageResolutionCookie{cookie}
}

// PrintGetImageResolutionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetImageResolutionUnchecked(c *xgb.Conn, Context Pcontext) PrintGetImageResolutionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetImageResolution' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetImageResolutionRequest(c, Context), cookie)
	return PrintGetImageResolutionCookie{cookie}
}

// PrintGetImageResolutionReply represents the data returned from a PrintGetImageResolution request.
type PrintGetImageResolutionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ImageResolution uint16
}

// Reply blocks and returns the reply data for a PrintGetImageResolution request.
func (cook PrintGetImageResolutionCookie) Reply() (*PrintGetImageResolutionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetImageResolutionReply(buf), nil
}

// printGetImageResolutionReply reads a byte slice into a PrintGetImageResolutionReply value.
func printGetImageResolutionReply(buf []byte) *PrintGetImageResolutionReply {
	v := new(PrintGetImageResolutionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ImageResolution = xgb.Get16(buf[b:])
	b += 2

	return v
}

// Write request to wire for PrintGetImageResolution
// printGetImageResolutionRequest writes a PrintGetImageResolution request to a byte slice.
func printGetImageResolutionRequest(c *xgb.Conn, Context Pcontext) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 24 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	return buf
}

// PrintGetOneAttributesCookie is a cookie used only for PrintGetOneAttributes requests.
type PrintGetOneAttributesCookie struct {
	*xgb.Cookie
}

// PrintGetOneAttributes sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetOneAttributesCookie.Reply()
func PrintGetOneAttributes(c *xgb.Conn, Context Pcontext, NameLen uint32, Pool byte, Name []String8) PrintGetOneAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetOneAttributes' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetOneAttributesRequest(c, Context, NameLen, Pool, Name), cookie)
	return PrintGetOneAttributesCookie{cookie}
}

// PrintGetOneAttributesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetOneAttributesUnchecked(c *xgb.Conn, Context Pcontext, NameLen uint32, Pool byte, Name []String8) PrintGetOneAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetOneAttributes' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetOneAttributesRequest(c, Context, NameLen, Pool, Name), cookie)
	return PrintGetOneAttributesCookie{cookie}
}

// PrintGetOneAttributesReply represents the data returned from a PrintGetOneAttributes request.
type PrintGetOneAttributesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ValueLen uint32
	// padding: 20 bytes
	Value []String8 // size: xgb.Pad((int(ValueLen) * 1))
}

// Reply blocks and returns the reply data for a PrintGetOneAttributes request.
func (cook PrintGetOneAttributesCookie) Reply() (*PrintGetOneAttributesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetOneAttributesReply(buf), nil
}

// printGetOneAttributesReply reads a byte slice into a PrintGetOneAttributesReply value.
func printGetOneAttributesReply(buf []byte) *PrintGetOneAttributesReply {
	v := new(PrintGetOneAttributesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ValueLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Value = make([]String8, v.ValueLen)
	for i := 0; i < int(v.ValueLen); i++ {
		v.Value[i] = String8(buf[b])
		b += 1
	}

	return v
}

// Write request to wire for PrintGetOneAttributes
// printGetOneAttributesRequest writes a PrintGetOneAttributes request to a byte slice.
func printGetOneAttributesRequest(c *xgb.Conn, Context Pcontext, NameLen uint32, Pool byte, Name []String8) []byte {
	size := xgb.Pad((16 + xgb.Pad((int(NameLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 19 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], NameLen)
	b += 4

	buf[b] = Pool
	b += 1

	b += 3 // padding

	for i := 0; i < int(NameLen); i++ {
		buf[b] = byte(Name[i])
		b += 1
	}

	return buf
}

// PrintGetPageDimensionsCookie is a cookie used only for PrintGetPageDimensions requests.
type PrintGetPageDimensionsCookie struct {
	*xgb.Cookie
}

// PrintGetPageDimensions sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetPageDimensionsCookie.Reply()
func PrintGetPageDimensions(c *xgb.Conn, Context Pcontext) PrintGetPageDimensionsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetPageDimensions' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetPageDimensionsRequest(c, Context), cookie)
	return PrintGetPageDimensionsCookie{cookie}
}

// PrintGetPageDimensionsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetPageDimensionsUnchecked(c *xgb.Conn, Context Pcontext) PrintGetPageDimensionsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetPageDimensions' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetPageDimensionsRequest(c, Context), cookie)
	return PrintGetPageDimensionsCookie{cookie}
}

// PrintGetPageDimensionsReply represents the data returned from a PrintGetPageDimensions request.
type PrintGetPageDimensionsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Width              uint16
	Height             uint16
	OffsetX            uint16
	OffsetY            uint16
	ReproducibleWidth  uint16
	ReproducibleHeight uint16
}

// Reply blocks and returns the reply data for a PrintGetPageDimensions request.
func (cook PrintGetPageDimensionsCookie) Reply() (*PrintGetPageDimensionsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetPageDimensionsReply(buf), nil
}

// printGetPageDimensionsReply reads a byte slice into a PrintGetPageDimensionsReply value.
func printGetPageDimensionsReply(buf []byte) *PrintGetPageDimensionsReply {
	v := new(PrintGetPageDimensionsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.OffsetX = xgb.Get16(buf[b:])
	b += 2

	v.OffsetY = xgb.Get16(buf[b:])
	b += 2

	v.ReproducibleWidth = xgb.Get16(buf[b:])
	b += 2

	v.ReproducibleHeight = xgb.Get16(buf[b:])
	b += 2

	return v
}

// Write request to wire for PrintGetPageDimensions
// printGetPageDimensionsRequest writes a PrintGetPageDimensions request to a byte slice.
func printGetPageDimensionsRequest(c *xgb.Conn, Context Pcontext) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 21 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	return buf
}

// PrintGetPrinterListCookie is a cookie used only for PrintGetPrinterList requests.
type PrintGetPrinterListCookie struct {
	*xgb.Cookie
}

// PrintGetPrinterList sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetPrinterListCookie.Reply()
func PrintGetPrinterList(c *xgb.Conn, PrinterNameLen uint32, LocaleLen uint32, PrinterName []String8, Locale []String8) PrintGetPrinterListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetPrinterList' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetPrinterListRequest(c, PrinterNameLen, LocaleLen, PrinterName, Locale), cookie)
	return PrintGetPrinterListCookie{cookie}
}

// PrintGetPrinterListUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetPrinterListUnchecked(c *xgb.Conn, PrinterNameLen uint32, LocaleLen uint32, PrinterName []String8, Locale []String8) PrintGetPrinterListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetPrinterList' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetPrinterListRequest(c, PrinterNameLen, LocaleLen, PrinterName, Locale), cookie)
	return PrintGetPrinterListCookie{cookie}
}

// PrintGetPrinterListReply represents the data returned from a PrintGetPrinterList request.
type PrintGetPrinterListReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ListCount uint32
	// padding: 20 bytes
	Printers []Printer // size: PrinterListSize(Printers)
}

// Reply blocks and returns the reply data for a PrintGetPrinterList request.
func (cook PrintGetPrinterListCookie) Reply() (*PrintGetPrinterListReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetPrinterListReply(buf), nil
}

// printGetPrinterListReply reads a byte slice into a PrintGetPrinterListReply value.
func printGetPrinterListReply(buf []byte) *PrintGetPrinterListReply {
	v := new(PrintGetPrinterListReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ListCount = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Printers = make([]Printer, v.ListCount)
	b += PrinterReadList(buf[b:], v.Printers)

	return v
}

// Write request to wire for PrintGetPrinterList
// printGetPrinterListRequest writes a PrintGetPrinterList request to a byte slice.
func printGetPrinterListRequest(c *xgb.Conn, PrinterNameLen uint32, LocaleLen uint32, PrinterName []String8, Locale []String8) []byte {
	size := xgb.Pad((((12 + xgb.Pad((int(PrinterNameLen) * 1))) + 4) + xgb.Pad((int(LocaleLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 1 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], PrinterNameLen)
	b += 4

	xgb.Put32(buf[b:], LocaleLen)
	b += 4

	for i := 0; i < int(PrinterNameLen); i++ {
		buf[b] = byte(PrinterName[i])
		b += 1
	}

	b = (b + 3) & ^3 // alignment gap

	for i := 0; i < int(LocaleLen); i++ {
		buf[b] = byte(Locale[i])
		b += 1
	}

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// PrintGetScreenOfContextCookie is a cookie used only for PrintGetScreenOfContext requests.
type PrintGetScreenOfContextCookie struct {
	*xgb.Cookie
}

// PrintGetScreenOfContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintGetScreenOfContextCookie.Reply()
func PrintGetScreenOfContext(c *xgb.Conn) PrintGetScreenOfContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetScreenOfContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printGetScreenOfContextRequest(c), cookie)
	return PrintGetScreenOfContextCookie{cookie}
}

// PrintGetScreenOfContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintGetScreenOfContextUnchecked(c *xgb.Conn) PrintGetScreenOfContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintGetScreenOfContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printGetScreenOfContextRequest(c), cookie)
	return PrintGetScreenOfContextCookie{cookie}
}

// PrintGetScreenOfContextReply represents the data returned from a PrintGetScreenOfContext request.
type PrintGetScreenOfContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Root xproto.Window
}

// Reply blocks and returns the reply data for a PrintGetScreenOfContext request.
func (cook PrintGetScreenOfContextCookie) Reply() (*PrintGetScreenOfContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printGetScreenOfContextReply(buf), nil
}

// printGetScreenOfContextReply reads a byte slice into a PrintGetScreenOfContextReply value.
func printGetScreenOfContextReply(buf []byte) *PrintGetScreenOfContextReply {
	v := new(PrintGetScreenOfContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Root = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	return v
}

// Write request to wire for PrintGetScreenOfContext
// printGetScreenOfContextRequest writes a PrintGetScreenOfContext request to a byte slice.
func printGetScreenOfContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 6 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// PrintInputSelectedCookie is a cookie used only for PrintInputSelected requests.
type PrintInputSelectedCookie struct {
	*xgb.Cookie
}

// PrintInputSelected sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintInputSelectedCookie.Reply()
func PrintInputSelected(c *xgb.Conn, Context Pcontext) PrintInputSelectedCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintInputSelected' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printInputSelectedRequest(c, Context), cookie)
	return PrintInputSelectedCookie{cookie}
}

// PrintInputSelectedUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintInputSelectedUnchecked(c *xgb.Conn, Context Pcontext) PrintInputSelectedCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintInputSelected' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printInputSelectedRequest(c, Context), cookie)
	return PrintInputSelectedCookie{cookie}
}

// PrintInputSelectedReply represents the data returned from a PrintInputSelected request.
type PrintInputSelectedReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	EventMask     uint32
	AllEventsMask uint32
}

// Reply blocks and returns the reply data for a PrintInputSelected request.
func (cook PrintInputSelectedCookie) Reply() (*PrintInputSelectedReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printInputSelectedReply(buf), nil
}

// printInputSelectedReply reads a byte slice into a PrintInputSelectedReply value.
func printInputSelectedReply(buf []byte) *PrintInputSelectedReply {
	v := new(PrintInputSelectedReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.EventMask = xgb.Get32(buf[b:])
	b += 4

	v.AllEventsMask = xgb.Get32(buf[b:])
	b += 4

	return v
}

// Write request to wire for PrintInputSelected
// printInputSelectedRequest writes a PrintInputSelected request to a byte slice.
func printInputSelectedRequest(c *xgb.Conn, Context Pcontext) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 16 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	return buf
}

// PrintPutDocumentDataCookie is a cookie used only for PrintPutDocumentData requests.
type PrintPutDocumentDataCookie struct {
	*xgb.Cookie
}

// PrintPutDocumentData sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintPutDocumentData(c *xgb.Conn, Drawable xproto.Drawable, LenData uint32, LenFmt uint16, LenOptions uint16, Data []byte, DocFormat []String8, Options []String8) PrintPutDocumentDataCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintPutDocumentData' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printPutDocumentDataRequest(c, Drawable, LenData, LenFmt, LenOptions, Data, DocFormat, Options), cookie)
	return PrintPutDocumentDataCookie{cookie}
}

// PrintPutDocumentDataChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintPutDocumentDataCookie.Check()
func PrintPutDocumentDataChecked(c *xgb.Conn, Drawable xproto.Drawable, LenData uint32, LenFmt uint16, LenOptions uint16, Data []byte, DocFormat []String8, Options []String8) PrintPutDocumentDataCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintPutDocumentData' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printPutDocumentDataRequest(c, Drawable, LenData, LenFmt, LenOptions, Data, DocFormat, Options), cookie)
	return PrintPutDocumentDataCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintPutDocumentDataCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintPutDocumentData
// printPutDocumentDataRequest writes a PrintPutDocumentData request to a byte slice.
func printPutDocumentDataRequest(c *xgb.Conn, Drawable xproto.Drawable, LenData uint32, LenFmt uint16, LenOptions uint16, Data []byte, DocFormat []String8, Options []String8) []byte {
	size := xgb.Pad((((((16 + xgb.Pad((int(LenData) * 1))) + 4) + xgb.Pad((int(LenFmt) * 1))) + 4) + xgb.Pad((int(LenOptions) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 11 // request opcode
	b += 1

	blen := b
	b += 2

	xgb.Put32(buf[b:], uint32(Drawable))
	b += 4

	xgb.Put32(buf[b:], LenData)
	b += 4

	xgb.Put16(buf[b:], LenFmt)
	b += 2

	xgb.Put16(buf[b:], LenOptions)
	b += 2

	copy(buf[b:], Data[:LenData])
	b += int(LenData)

	b = (b + 3) & ^3 // alignment gap

	for i := 0; i < int(LenFmt); i++ {
		buf[b] = byte(DocFormat[i])
		b += 1
	}

	b = (b + 3) & ^3 // alignment gap

	for i := 0; i < int(LenOptions); i++ {
		buf[b] = byte(Options[i])
		b += 1
	}

	b = xgb.Pad(b)
	xgb.Put16(buf[blen:], uint16(b/4)) // write request size in 4-byte units
	return buf[:b]
}

// PrintQueryScreensCookie is a cookie used only for PrintQueryScreens requests.
type PrintQueryScreensCookie struct {
	*xgb.Cookie
}

// PrintQueryScreens sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintQueryScreensCookie.Reply()
func PrintQueryScreens(c *xgb.Conn) PrintQueryScreensCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintQueryScreens' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printQueryScreensRequest(c), cookie)
	return PrintQueryScreensCookie{cookie}
}

// PrintQueryScreensUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintQueryScreensUnchecked(c *xgb.Conn) PrintQueryScreensCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintQueryScreens' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printQueryScreensRequest(c), cookie)
	return PrintQueryScreensCookie{cookie}
}

// PrintQueryScreensReply represents the data returned from a PrintQueryScreens request.
type PrintQueryScreensReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ListCount uint32
	// padding: 20 bytes
	Roots []xproto.Window // size: xgb.Pad((int(ListCount) * 4))
}

// Reply blocks and returns the reply data for a PrintQueryScreens request.
func (cook PrintQueryScreensCookie) Reply() (*PrintQueryScreensReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printQueryScreensReply(buf), nil
}

// printQueryScreensReply reads a byte slice into a PrintQueryScreensReply value.
func printQueryScreensReply(buf []byte) *PrintQueryScreensReply {
	v := new(PrintQueryScreensReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ListCount = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Roots = make([]xproto.Window, v.ListCount)
	for i := 0; i < int(v.ListCount); i++ {
		v.Roots[i] = xproto.Window(xgb.Get32(buf[b:]))
		b += 4
	}

	return v
}

// Write request to wire for PrintQueryScreens
// printQueryScreensRequest writes a PrintQueryScreens request to a byte slice.
func printQueryScreensRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 22 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// PrintQueryVersionCookie is a cookie used only for PrintQueryVersion requests.
type PrintQueryVersionCookie struct {
	*xgb.Cookie
}

// PrintQueryVersion sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintQueryVersionCookie.Reply()
func PrintQueryVersion(c *xgb.Conn) PrintQueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintQueryVersion' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printQueryVersionRequest(c), cookie)
	return PrintQueryVersionCookie{cookie}
}

// PrintQueryVersionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintQueryVersionUnchecked(c *xgb.Conn) PrintQueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintQueryVersion' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printQueryVersionRequest(c), cookie)
	return PrintQueryVersionCookie{cookie}
}

// PrintQueryVersionReply represents the data returned from a PrintQueryVersion request.
type PrintQueryVersionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	MajorVersion uint16
	MinorVersion uint16
}

// Reply blocks and returns the reply data for a PrintQueryVersion request.
func (cook PrintQueryVersionCookie) Reply() (*PrintQueryVersionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printQueryVersionReply(buf), nil
}

// printQueryVersionReply reads a byte slice into a PrintQueryVersionReply value.
func printQueryVersionReply(buf []byte) *PrintQueryVersionReply {
	v := new(PrintQueryVersionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.MajorVersion = xgb.Get16(buf[b:])
	b += 2

	v.MinorVersion = xgb.Get16(buf[b:])
	b += 2

	return v
}

// Write request to wire for PrintQueryVersion
// printQueryVersionRequest writes a PrintQueryVersion request to a byte slice.
func printQueryVersionRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 0 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// PrintRehashPrinterListCookie is a cookie used only for PrintRehashPrinterList requests.
type PrintRehashPrinterListCookie struct {
	*xgb.Cookie
}

// PrintRehashPrinterList sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintRehashPrinterList(c *xgb.Conn) PrintRehashPrinterListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintRehashPrinterList' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printRehashPrinterListRequest(c), cookie)
	return PrintRehashPrinterListCookie{cookie}
}

// PrintRehashPrinterListChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintRehashPrinterListCookie.Check()
func PrintRehashPrinterListChecked(c *xgb.Conn) PrintRehashPrinterListCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintRehashPrinterList' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printRehashPrinterListRequest(c), cookie)
	return PrintRehashPrinterListCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintRehashPrinterListCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintRehashPrinterList
// printRehashPrinterListRequest writes a PrintRehashPrinterList request to a byte slice.
func printRehashPrinterListRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 20 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// PrintSelectInputCookie is a cookie used only for PrintSelectInput requests.
type PrintSelectInputCookie struct {
	*xgb.Cookie
}

// PrintSelectInput sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintSelectInput(c *xgb.Conn, Context Pcontext, EventMask uint32) PrintSelectInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSelectInput' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printSelectInputRequest(c, Context, EventMask), cookie)
	return PrintSelectInputCookie{cookie}
}

// PrintSelectInputChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintSelectInputCookie.Check()
func PrintSelectInputChecked(c *xgb.Conn, Context Pcontext, EventMask uint32) PrintSelectInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSelectInput' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printSelectInputRequest(c, Context, EventMask), cookie)
	return PrintSelectInputCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintSelectInputCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintSelectInput
// printSelectInputRequest writes a PrintSelectInput request to a byte slice.
func printSelectInputRequest(c *xgb.Conn, Context Pcontext, EventMask uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 15 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], EventMask)
	b += 4

	return buf
}

// PrintSetAttributesCookie is a cookie used only for PrintSetAttributes requests.
type PrintSetAttributesCookie struct {
	*xgb.Cookie
}

// PrintSetAttributes sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintSetAttributes(c *xgb.Conn, Context Pcontext, StringLen uint32, Pool byte, Rule byte, Attributes []String8) PrintSetAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSetAttributes' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printSetAttributesRequest(c, Context, StringLen, Pool, Rule, Attributes), cookie)
	return PrintSetAttributesCookie{cookie}
}

// PrintSetAttributesChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintSetAttributesCookie.Check()
func PrintSetAttributesChecked(c *xgb.Conn, Context Pcontext, StringLen uint32, Pool byte, Rule byte, Attributes []String8) PrintSetAttributesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSetAttributes' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printSetAttributesRequest(c, Context, StringLen, Pool, Rule, Attributes), cookie)
	return PrintSetAttributesCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintSetAttributesCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintSetAttributes
// printSetAttributesRequest writes a PrintSetAttributes request to a byte slice.
func printSetAttributesRequest(c *xgb.Conn, Context Pcontext, StringLen uint32, Pool byte, Rule byte, Attributes []String8) []byte {
	size := xgb.Pad((16 + xgb.Pad((len(Attributes) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 18 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put32(buf[b:], StringLen)
	b += 4

	buf[b] = Pool
	b += 1

	buf[b] = Rule
	b += 1

	b += 2 // padding

	for i := 0; i < int(len(Attributes)); i++ {
		buf[b] = byte(Attributes[i])
		b += 1
	}

	return buf
}

// PrintSetContextCookie is a cookie used only for PrintSetContext requests.
type PrintSetContextCookie struct {
	*xgb.Cookie
}

// PrintSetContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintSetContext(c *xgb.Conn, Context uint32) PrintSetContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSetContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printSetContextRequest(c, Context), cookie)
	return PrintSetContextCookie{cookie}
}

// PrintSetContextChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintSetContextCookie.Check()
func PrintSetContextChecked(c *xgb.Conn, Context uint32) PrintSetContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSetContext' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printSetContextRequest(c, Context), cookie)
	return PrintSetContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintSetContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintSetContext
// printSetContextRequest writes a PrintSetContext request to a byte slice.
func printSetContextRequest(c *xgb.Conn, Context uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 3 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Context)
	b += 4

	return buf
}

// PrintSetImageResolutionCookie is a cookie used only for PrintSetImageResolution requests.
type PrintSetImageResolutionCookie struct {
	*xgb.Cookie
}

// PrintSetImageResolution sends a checked request.
// If an error occurs, it will be returned with the reply by calling PrintSetImageResolutionCookie.Reply()
func PrintSetImageResolution(c *xgb.Conn, Context Pcontext, ImageResolution uint16) PrintSetImageResolutionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSetImageResolution' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(printSetImageResolutionRequest(c, Context, ImageResolution), cookie)
	return PrintSetImageResolutionCookie{cookie}
}

// PrintSetImageResolutionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintSetImageResolutionUnchecked(c *xgb.Conn, Context Pcontext, ImageResolution uint16) PrintSetImageResolutionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintSetImageResolution' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(printSetImageResolutionRequest(c, Context, ImageResolution), cookie)
	return PrintSetImageResolutionCookie{cookie}
}

// PrintSetImageResolutionReply represents the data returned from a PrintSetImageResolution request.
type PrintSetImageResolutionReply struct {
	Sequence            uint16 // sequence number of the request for this reply
	Length              uint32 // number of bytes in this reply
	Status              bool
	PreviousResolutions uint16
}

// Reply blocks and returns the reply data for a PrintSetImageResolution request.
func (cook PrintSetImageResolutionCookie) Reply() (*PrintSetImageResolutionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return printSetImageResolutionReply(buf), nil
}

// printSetImageResolutionReply reads a byte slice into a PrintSetImageResolutionReply value.
func printSetImageResolutionReply(buf []byte) *PrintSetImageResolutionReply {
	v := new(PrintSetImageResolutionReply)
	b := 1 // skip reply determinant

	if buf[b] == 1 {
		v.Status = true
	} else {
		v.Status = false
	}
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.PreviousResolutions = xgb.Get16(buf[b:])
	b += 2

	return v
}

// Write request to wire for PrintSetImageResolution
// printSetImageResolutionRequest writes a PrintSetImageResolution request to a byte slice.
func printSetImageResolutionRequest(c *xgb.Conn, Context Pcontext, ImageResolution uint16) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 23 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Context))
	b += 4

	xgb.Put16(buf[b:], ImageResolution)
	b += 2

	return buf
}

// PrintStartDocCookie is a cookie used only for PrintStartDoc requests.
type PrintStartDocCookie struct {
	*xgb.Cookie
}

// PrintStartDoc sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintStartDoc(c *xgb.Conn, DriverMode byte) PrintStartDocCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintStartDoc' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printStartDocRequest(c, DriverMode), cookie)
	return PrintStartDocCookie{cookie}
}

// PrintStartDocChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintStartDocCookie.Check()
func PrintStartDocChecked(c *xgb.Conn, DriverMode byte) PrintStartDocCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintStartDoc' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printStartDocRequest(c, DriverMode), cookie)
	return PrintStartDocCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintStartDocCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintStartDoc
// printStartDocRequest writes a PrintStartDoc request to a byte slice.
func printStartDocRequest(c *xgb.Conn, DriverMode byte) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 9 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = DriverMode
	b += 1

	return buf
}

// PrintStartJobCookie is a cookie used only for PrintStartJob requests.
type PrintStartJobCookie struct {
	*xgb.Cookie
}

// PrintStartJob sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintStartJob(c *xgb.Conn, OutputMode byte) PrintStartJobCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintStartJob' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printStartJobRequest(c, OutputMode), cookie)
	return PrintStartJobCookie{cookie}
}

// PrintStartJobChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintStartJobCookie.Check()
func PrintStartJobChecked(c *xgb.Conn, OutputMode byte) PrintStartJobCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintStartJob' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printStartJobRequest(c, OutputMode), cookie)
	return PrintStartJobCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintStartJobCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintStartJob
// printStartJobRequest writes a PrintStartJob request to a byte slice.
func printStartJobRequest(c *xgb.Conn, OutputMode byte) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 7 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = OutputMode
	b += 1

	return buf
}

// PrintStartPageCookie is a cookie used only for PrintStartPage requests.
type PrintStartPageCookie struct {
	*xgb.Cookie
}

// PrintStartPage sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func PrintStartPage(c *xgb.Conn, Window xproto.Window) PrintStartPageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintStartPage' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(printStartPageRequest(c, Window), cookie)
	return PrintStartPageCookie{cookie}
}

// PrintStartPageChecked sends a checked request.
// If an error occurs, it can be retrieved using PrintStartPageCookie.Check()
func PrintStartPageChecked(c *xgb.Conn, Window xproto.Window) PrintStartPageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XpExtension"]; !ok {
		panic("Cannot issue request 'PrintStartPage' using the uninitialized extension 'XpExtension'. xprint.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(printStartPageRequest(c, Window), cookie)
	return PrintStartPageCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook PrintStartPageCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for PrintStartPage
// printStartPageRequest writes a PrintStartPage request to a byte slice.
func printStartPageRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XpExtension"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 13 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}
