#pragma once

#include <vector>
#include <string>
#include <optional>

#include <nlohmann/json.hpp>

namespace cucumber::messages {

using json = nlohmann::json;

//
// Represents the Exception message in Cucumber's message protocol
// @see <a href=https://github.com/cucumber/messages>Github - Cucumber - Messages</a>
//
// A simplified representation of an exception
//
// Generated code

struct exception
{
    std::string type;
    std::optional<std::string> message;
    std::optional<std::string> stack_trace;

    std::string to_string() const;

    void to_json(json& j) const;
    std::string to_json() const;
};

std::ostream&
operator<<(std::ostream& os, const exception& msg);

void to_json(json& j, const exception& m);

}
