//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: Intersection.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef Intersection_hpp
#define Intersection_hpp
//==============================================================================
// Includes
#include "Types.hpp"
#include "cVector2f.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
// TEMP: Intersection tests return true or false result

inline bool RayCircleIntersection (	const cVector2f &p1, const cVector2f &p2, 
									const cVector2f &p3, const float &r)
{
	float u, a, b, c, result;
	
	u = (	(p3.mX - p1.mX) * (p2.mX - p1.mX) + 
			(p3.mY - p1.mY) * (p2.mY - p1.mY) ) /
		(POW2 (p2.mX - p1.mX) + POW2 (p2.mY - p1.mY));
	if ( u < 0 || u > 1 )
		return false;
	
	a = POW2 (p2.mX - p1.mX) + POW2 (p2.mY - p1.mY);
	b = 2 * ((p2.mX - p1.mX) * (p1.mX - p3.mX) + 
			(p2.mY - p1.mY) * (p1.mY - p3.mY));
	c = POW2 (p3.mX) + POW2 (p3.mY) + POW2 (p1.mX) + POW2 (p1.mY) - 2 * 
		(p3.mX * p1.mX + p3.mY * p1.mY) - POW2 (r);
	
	result = b * b - 4 * a * c;
	if ( result >= 0 )
		return true;
	return false;
}

inline float RayRayIntersection (const cVector2f &p1, const cVector2f &p2, 
								const cVector2f &p3, const cVector2f &p4)
{
	float ua, ub, d;
	
	// The denominator
	d = ((p4.mY - p3.mY) * (p2.mX - p1.mX) - (p4.mX - p3.mX) * (p2.mY - p1.mY));
	if ( d == 0.0f )
		return -1.0f;
	
	ua = ((p4.mX - p3.mX) * (p1.mY - p3.mY) - (p4.mY - p3.mY) * (p1.mX - p3.mX))
		/ d;
	ub = ((p2.mX - p1.mX) * (p1.mY - p3.mY) - (p2.mY - p1.mY) * (p1.mX - p3.mX))
		/ d;
	
	if ( ua < 0.0f || ua > 1.0f || ub < 0.0f || ub > 1.0f )
		return -1.0f;
	return ua;
}

inline bool CircleCircleIntersection (const cVector2f &p1, const float &r1,
										const cVector2f &p2, const float &r2)
{
	float distance = (p2 - p1).GetLenght ();
	if ( distance <= r1 + r2 )
		return true;
	return false;
}

//==============================================================================
}		// End of the ShootingStar namespace
#endif // Intersection_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
