//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cBullet.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cBullet.hpp"

#include <GL/gl.h>
#include "cWorld.hpp"
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! Constructor
//------------------------------------------------------------------------------
cBullet::cBullet (void):
mTTL (500),
mLenght (1.0f)
{
	SetCollisionModel (CollisionModel_Ray);
	SetDamage (5);
};
//==============================================================================

//==============================================================================
//! Destructor
//------------------------------------------------------------------------------
cBullet::~cBullet (void)
{
	// Empty
};
//==============================================================================

//==============================================================================
//! Rendering interface
//------------------------------------------------------------------------------
void 
cBullet::Render (Uint32 deltaTime)
{
	glPushAttrib (GL_LINE_BIT);
	
	glDisable (GL_TEXTURE_2D);
	glBegin (GL_LINES);
		glColor4f (1.0f, 1.0f, 1.0f, 0.2f);
		glVertex2f (0.0f, 0.0f);
		glColor4f (0.5f, 0.5f, 0.5f, 0.0f);
		glVertex2f (0.0f, mLenght);
	glEnd ();
	glEnable (GL_TEXTURE_2D);
	
	glPopAttrib ();
}
//==============================================================================

//==============================================================================
//! Updating interface
//------------------------------------------------------------------------------
void 
cBullet::Update (Uint32 deltaTime)
{
	if ( mTTL <= deltaTime )
		Kill ();
	else
		mTTL -= deltaTime;
	
	if ( mLenght < 500.0f )
		mLenght += GetVelocity ().GetLenght () * deltaTime;
}
//==============================================================================

//==============================================================================
// EOF
//==============================================================================
